/*
 * Copyright (C) 2008, 2012, 2013 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef GradientImage_h
#define GradientImage_h

#include "FloatSize.h"
#include "GeneratedImage.h"
#include "Gradient.h"
#include "Image.h"
#include <wtf/RefPtr.h>

namespace WebCore {

class ImageBuffer;

class GradientImage final : public GeneratedImage {
public:
    static PassRefPtr<GradientImage> create(PassRefPtr<Gradient> generator, const FloatSize& size)
    {
        return adoptRef(new GradientImage(generator, size));
    }

    virtual ~GradientImage();

protected:
    virtual void draw(GraphicsContext&, const FloatRect& dstRect, const FloatRect& srcRect, CompositeOperator, BlendMode, ImageOrientationDescription) override;
    virtual void drawPattern(GraphicsContext&, const FloatRect& srcRect, const AffineTransform& patternTransform,
        const FloatPoint& phase, const FloatSize& spacing, CompositeOperator, const FloatRect& destRect, BlendMode) override;

    GradientImage(PassRefPtr<Gradient>, const FloatSize&);

private:
    virtual bool isGradientImage() const override { return true; }
    virtual void dump(TextStream&) const override;
    
    RefPtr<Gradient> m_gradient;
    std::unique_ptr<ImageBuffer> m_cachedImageBuffer;
    FloatSize m_cachedAdjustedSize;
    unsigned m_cachedGeneratorHash;
};

}

#endif
