/***************************************************************************
                          pybrowse_part.cpp  -  description
                             -------------------
    begin                : Tue Aug 28 2001
    copyright            : (C) 2001 by Christian Bird
    email                : chrisb@lineo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pybrowse_part.h"
#include "pybrowse_part.moc"
#include "kpybrowser.h"
#include "pybrowse.xpm"

#include <kaction.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kmessagebox.h>
#include <qimage.h>
#include <kdockwidget.h>




class PluginView : public KXMLGUIClient
{
  friend class KatePluginPyBrowse;

  public:
    Kate::MainWindow *win;
};


extern "C"
{
  void* init_katepybrowseplugin()
  {
    KGlobal::locale()->insertCatalogue("katepybrowse");
    return new KatePluginFactory;
  }
}

KatePluginFactory::KatePluginFactory()
{
  s_instance = new KInstance( "kate" );
}

KatePluginFactory::~KatePluginFactory()
{
  delete s_instance;
}

QObject* KatePluginFactory::createObject( QObject* parent,
     const char* name, const char*,
     const QStringList & )
{
  return new KatePluginPyBrowse( parent, name );
}

KInstance* KatePluginFactory::s_instance = 0L;

KatePluginPyBrowse::KatePluginPyBrowse( QObject* parent,const char* name )
    : Kate::Plugin ( (Kate::Application *)parent, name )
{
	kpybrowser = NULL;
	my_dock = NULL;
}

KatePluginPyBrowse::~KatePluginPyBrowse()
{
}

void KatePluginPyBrowse::addView (Kate::MainWindow *win)
{
   PluginView *view = new PluginView();
   
   main_win = win;
  (void) new KAction ( i18n("Update Python Browser"), 0, this,
                      SLOT( slotUpdatePyBrowser() ), view->actionCollection(),
                      "python_update_pybrowse" );

   //set up the menus   
   view->setInstance(new KInstance("kate"));
   view->setXMLFile( "plugins/katepybrowse/ui.rc" );
   win->guiFactory()->addClient(view);
   view->win = win;
   
   //create a python head pixmap for the tab
   QPixmap *py_pixmap = new QPixmap(pybrowse_xpm);
   QImage py_image = py_pixmap->convertToImage().smoothScale(20, 20);
   py_pixmap->convertFromImage(py_image);

   //create the browser and put it into a dockwidget using kate's tool view manager
   
   Kate::ToolViewManager *tool_view_manager = win->toolViewManager();
   my_dock = tool_view_manager->addToolView(KDockWidget::DockLeft, "kpybrowser", (*py_pixmap), i18n("Python Browser"));
   kpybrowser = new KPyBrowser(my_dock, "kpybrowser");
   my_dock->setWidget(kpybrowser);
   my_dock->setToolTipString(i18n("Python Browser"));
   kpybrowser->show();
   
   connect(kpybrowser, SIGNAL(selected(QString, int)), this, SLOT(slotSelected(QString, int)));
   m_views.append (view);
}

void KatePluginPyBrowse::removeView(Kate::MainWindow *win)
{
  for (uint z=0; z < m_views.count(); z++)
    if (m_views.at(z)->win == win)
    {
      PluginView *view = m_views.at(z);
      m_views.remove (view);
      win->guiFactory()->removeClient (view);
      delete view;
    } 

    if (my_dock != NULL)
    {
        main_win->toolViewManager()->removeToolView(my_dock);
	delete my_dock;
	my_dock = NULL;
	kpybrowser = NULL;
    }

}


void KatePluginPyBrowse::slotSelected(QString name, int line)
{
	//TO DO - deal with setting the active view to be the file that has this class
	//if multiple files are open.
	
	if (name == "Classes" || name == "Globals")
		return;
	
	Kate::View *view = main_win->viewManager()->activeView();
	
	Kate::Document *doc = view->getDoc();
	QString docline = doc->textLine(line);
	int numlines = doc->numLines();
	int done = 0, apiline = -1, forward_line = line,backward_line = line-1;
	while (!done)
	{
	  done = 1;
		if (forward_line < numlines)
		{
			if (doc->textLine(forward_line).find(name) > -1)
			{
				apiline = forward_line;
				break;
			}
			forward_line++;
			done = 0;
		}
		if (backward_line > -1)
		{
		  if (doc->textLine(backward_line).find(name) > -1)
			{
				apiline = backward_line;
				break;
			}
			backward_line--;
			done = 0;			
		}
	}
	if (apiline == -1)
	{
		KMessageBox::information(0,
			i18n("Could not find Method/Class %1").arg(name), i18n("Selection"));
	}                                                              		
	else
	{
		view->setCursorPosition(apiline, 0);
	}
	view->setFocus();
}

void KatePluginPyBrowse::slotUpdatePyBrowser()
{
  Kate::ViewManager *viewManager = main_win->viewManager();
  if (viewManager == NULL)
  	return;
  Kate::View *view = viewManager->activeView();
  if (view == NULL)
  	return;
  QString pytext(view->getDoc()->text());
  kpybrowser->parseText(pytext);
}

	

void KatePluginPyBrowse::slotShowPyBrowser()
{
   //TO DO implement this later so that you can turn the browser off and on
}
