/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import sun.print.ServiceDialog;
import sun.print.SunAlternateMedia;

public class ServiceUI {
    private static void removeUnsupportedAttributes(PrintService printService, DocFlavor docFlavor, AttributeSet attributeSet) {
        AttributeSet attributeSet2 = printService.getUnsupportedAttributes(docFlavor, attributeSet);
        if (attributeSet2 != null) {
            Attribute[] attributeArray = attributeSet2.toArray();
            for (int i2 = 0; i2 < attributeArray.length; ++i2) {
                Class clazz = attributeArray[i2].getCategory();
                if (printService.isAttributeCategorySupported(clazz)) {
                    Attribute attribute = (Attribute)printService.getDefaultAttributeValue(clazz);
                    if (attribute != null) {
                        attributeSet.add(attribute);
                        continue;
                    }
                    attributeSet.remove(clazz);
                    continue;
                }
                attributeSet.remove(clazz);
            }
        }
    }

    public static PrintService printDialog(GraphicsConfiguration graphicsConfiguration, int n2, int n3, PrintService[] printServiceArray, PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        int n4 = -1;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (printServiceArray == null || printServiceArray.length == 0) {
            throw new IllegalArgumentException("services must be non-null and non-empty");
        }
        if (printRequestAttributeSet == null) {
            throw new IllegalArgumentException("attributes must be non-null");
        }
        if (printService != null) {
            for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
                if (!((Object)printServiceArray[i2]).equals(printService)) continue;
                n4 = i2;
                break;
            }
            if (n4 < 0) {
                throw new IllegalArgumentException("services must contain defaultService");
            }
        } else {
            n4 = 0;
        }
        ServiceDialog serviceDialog = new ServiceDialog(graphicsConfiguration, n2, n3, printServiceArray, n4, docFlavor, printRequestAttributeSet);
        serviceDialog.show();
        if (serviceDialog.getStatus() == 1) {
            Class clazz;
            PrintRequestAttributeSet printRequestAttributeSet2 = serviceDialog.getAttributes();
            Class clazz2 = Destination.class;
            Class clazz3 = SunAlternateMedia.class;
            Class clazz4 = clazz = Fidelity.class;
            if (printRequestAttributeSet.containsKey(clazz2) && !printRequestAttributeSet2.containsKey(clazz2)) {
                printRequestAttributeSet.remove(clazz2);
            }
            if (printRequestAttributeSet.containsKey(clazz3) && !printRequestAttributeSet2.containsKey(clazz3)) {
                printRequestAttributeSet.remove(clazz3);
            }
            printRequestAttributeSet.addAll(printRequestAttributeSet2);
            Fidelity fidelity = (Fidelity)printRequestAttributeSet.get(clazz);
            if (fidelity != null && fidelity == Fidelity.FIDELITY_TRUE) {
                ServiceUI.removeUnsupportedAttributes(serviceDialog.getPrintService(), docFlavor, printRequestAttributeSet);
            }
        }
        return serviceDialog.getPrintService();
    }
}

