/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public abstract class MessageDigest
extends MessageDigestSpi {
    private String algorithm;
    private static final int INITIAL = 0;
    private static final int IN_PROGRESS = 1;
    private int state = 0;
    private Provider provider;

    public final int getDigestLength() {
        int n2 = this.engineGetDigestLength();
        if (n2 == 0) {
            try {
                MessageDigest messageDigest = (MessageDigest)this.clone();
                byte[] byArray = messageDigest.digest();
                return byArray.length;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return n2;
            }
        }
        return n2;
    }

    public void reset() {
        this.engineReset();
        this.state = 0;
    }

    public byte[] digest() {
        byte[] byArray = this.engineDigest();
        this.state = 0;
        return byArray;
    }

    public void update(byte by) {
        this.engineUpdate(by);
        this.state = 1;
    }

    public void update(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
        this.state = 1;
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public int digest(byte[] byArray, int n2, int n3) throws DigestException {
        if (byArray == null) {
            throw new IllegalArgumentException("No output buffer given");
        }
        if (byArray.length - n2 < n3) {
            throw new IllegalArgumentException("Output buffer too small for specified offset and length");
        }
        int n4 = this.engineDigest(byArray, n2, n3);
        this.state = 0;
        return n4;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new IllegalArgumentException("No input buffer given");
        }
        if (byArray.length - n2 < n3) {
            throw new IllegalArgumentException("Input buffer too short");
        }
        this.engineUpdate(byArray, n2, n3);
        this.state = 1;
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print(this.algorithm + " Message Digest from " + this.provider.getName() + ", ");
        switch (this.state) {
            case 0: {
                printStream.print("<initialized>");
                break;
            }
            case 1: {
                printStream.print("<in progress>");
            }
        }
        printStream.println();
        return byteArrayOutputStream.toString();
    }

    protected MessageDigest(String string) {
        this.algorithm = string;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "MessageDigest", (String)null);
            if (objectArray[0] instanceof MessageDigest) {
                MessageDigest messageDigest = (MessageDigest)objectArray[0];
                messageDigest.provider = (Provider)objectArray[1];
                return messageDigest;
            }
            Delegate delegate = new Delegate((MessageDigestSpi)objectArray[0], string);
            delegate.provider = (Provider)objectArray[1];
            return delegate;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "MessageDigest", string2);
        if (objectArray[0] instanceof MessageDigest) {
            MessageDigest messageDigest = (MessageDigest)objectArray[0];
            messageDigest.provider = (Provider)objectArray[1];
            return messageDigest;
        }
        Delegate delegate = new Delegate((MessageDigestSpi)objectArray[0], string);
        delegate.provider = (Provider)objectArray[1];
        return delegate;
    }

    public static MessageDigest getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "MessageDigest", provider);
        if (objectArray[0] instanceof MessageDigest) {
            MessageDigest messageDigest = (MessageDigest)objectArray[0];
            messageDigest.provider = (Provider)objectArray[1];
            return messageDigest;
        }
        Delegate delegate = new Delegate((MessageDigestSpi)objectArray[0], string);
        delegate.provider = (Provider)objectArray[1];
        return delegate;
    }

    static class Delegate
    extends MessageDigest {
        private MessageDigestSpi digestSpi;

        protected int engineGetDigestLength() {
            return this.digestSpi.engineGetDigestLength();
        }

        protected void engineReset() {
            this.digestSpi.engineReset();
        }

        protected byte[] engineDigest() {
            return this.digestSpi.engineDigest();
        }

        protected void engineUpdate(byte by) {
            this.digestSpi.engineUpdate(by);
        }

        protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
            return this.digestSpi.engineDigest(byArray, n2, n3);
        }

        protected void engineUpdate(byte[] byArray, int n2, int n3) {
            this.digestSpi.engineUpdate(byArray, n2, n3);
        }

        public Object clone() throws CloneNotSupportedException {
            if (this.digestSpi instanceof Cloneable) {
                MessageDigestSpi messageDigestSpi = (MessageDigestSpi)this.digestSpi.clone();
                Delegate delegate = new Delegate(messageDigestSpi, ((MessageDigest)this).algorithm);
                ((MessageDigest)delegate).provider = ((MessageDigest)this).provider;
                ((MessageDigest)delegate).state = ((MessageDigest)this).state;
                return delegate;
            }
            throw new CloneNotSupportedException();
        }

        public Delegate(MessageDigestSpi messageDigestSpi, String string) {
            super(string);
            this.digestSpi = messageDigestSpi;
        }
    }
}

