/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComponentInputMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;
import javax.swing.text.JTextComponent;
import sun.security.action.GetPropertyAction;

class SynthOptionPaneUI
extends OptionPaneUI
implements SynthUI {
    public static final int MinimumWidth = 262;
    public static final int MinimumHeight = 90;
    private static String newline = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private SynthStyle style;
    protected JOptionPane optionPane;
    protected Dimension minimumSize;
    protected JComponent inputComponent;
    protected Component initialFocusComponent;
    protected boolean hasCustomComponents;
    protected PropertyChangeListener propertyChangeListener;
    private int multiClickThreshold;

    protected int getInitialValueIndex() {
        if (this.optionPane != null) {
            Object object = this.optionPane.getInitialValue();
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                return 0;
            }
            if (object != null) {
                for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
                    if (!objectArray[i2].equals(object)) continue;
                    return i2;
                }
            }
        }
        return -1;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    static {
        if (newline == null) {
            newline = "\n";
        }
    }

    SynthOptionPaneUI() {
    }

    protected void installComponents() {
        this.optionPane.add(this.createMessageArea());
        Container container = this.createSeparator();
        if (container != null) {
            this.optionPane.add(container);
            SynthContext synthContext = this.getContext(this.optionPane, 1);
            this.optionPane.add(Box.createVerticalStrut(synthContext.getStyle().getInt(synthContext, "OptionPane.separatorPadding", 6)));
            synthContext.dispose();
        }
        this.optionPane.add(this.createButtonArea());
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
    }

    protected void installDefaults() {
        this.fetchStyle(this.optionPane);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, inputMap);
        LazyActionMap.installLazyActionMap(this.optionPane, SynthOptionPaneUI.class, "OptionPane.actionMap");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void resetInputValue() {
        if (this.inputComponent != null && this.inputComponent instanceof JTextField) {
            this.optionPane.setInputValue(((JTextField)this.inputComponent).getText());
        } else if (this.inputComponent != null && this.inputComponent instanceof JComboBox) {
            this.optionPane.setInputValue(((JComboBox)this.inputComponent).getSelectedItem());
        } else if (this.inputComponent != null) {
            this.optionPane.setInputValue(((JList)this.inputComponent).getSelectedValue());
        }
    }

    protected void uninstallComponents() {
        this.hasCustomComponents = false;
        this.inputComponent = null;
        this.initialFocusComponent = null;
        this.optionPane.removeAll();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.optionPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, null);
        SwingUtilities.replaceUIActionMap(this.optionPane, null);
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected Container createButtonArea() {
        JPanel jPanel = new JPanel();
        jPanel.setName("OptionPane.buttonArea");
        SynthContext synthContext = this.getContext(this.optionPane, 1);
        SynthStyle synthStyle = synthContext.getStyle();
        jPanel.setLayout(new ButtonAreaLayout(synthStyle.getBoolean(synthContext, "OptionPane.sameSizeButtons", true), synthStyle.getInt(synthContext, "OptionPane.buttonPadding", 10), synthStyle.getInt(synthContext, "OptionPane.buttonOrientation", 4), synthStyle.getBoolean(synthContext, "OptionPane.isYesLast", true)));
        this.addButtonComponents(jPanel, this.getButtons(synthContext), this.getInitialValueIndex());
        synthContext.dispose();
        return jPanel;
    }

    protected Container createMessageArea() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        jPanel.setName("OptionPane.messageArea");
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setName("OptionPane.body");
        jPanel3.setName("OptionPane.realBody");
        if (this.getIcon() != null) {
            serializable = new JPanel();
            serializable.setName("OptionPane.separator");
            serializable.setPreferredSize(new Dimension(15, 1));
            jPanel3.add((Component)serializable, "Before");
        }
        jPanel3.add((Component)jPanel2, "Center");
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        SynthContext synthContext = this.getContext(this.optionPane, 1);
        ((GridBagConstraints)serializable).anchor = synthContext.getStyle().getInt(synthContext, "OptionPane.messageAnchor", 10);
        synthContext.dispose();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(jPanel2, (GridBagConstraints)serializable, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        jPanel.add((Component)jPanel3, "Center");
        this.addIcon(jPanel);
        return jPanel;
    }

    protected Container createSeparator() {
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setName("OptionPane.separator");
        return jSeparator;
    }

    protected void addIcon(Container container) {
        Icon icon = this.getIcon();
        if (icon != null) {
            JLabel jLabel = new JLabel(icon);
            jLabel.setName("OptionPane.iconLabel");
            jLabel.setVerticalAlignment(1);
            container.add((Component)jLabel, "Before");
        }
    }

    public Dimension getMinimumOptionPaneSize() {
        if (this.minimumSize == null) {
            return new Dimension(262, 90);
        }
        return new Dimension(this.minimumSize.width, this.minimumSize.height);
    }

    protected LayoutManager createLayoutManager() {
        return new BoxLayout(this.optionPane, 1);
    }

    protected ActionListener createButtonActionListener(int n2) {
        return new ButtonActionListener(n2);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected Object getMessage() {
        this.inputComponent = null;
        if (this.optionPane != null) {
            if (this.optionPane.getWantsInput()) {
                JComponent jComponent;
                JComponent jComponent2;
                Object object = this.optionPane.getMessage();
                Object[] objectArray = this.optionPane.getSelectionValues();
                Object object2 = this.optionPane.getInitialSelectionValue();
                if (objectArray != null) {
                    if (objectArray.length < 20) {
                        jComponent2 = new JComboBox();
                        jComponent2.setName("OptionPane.comboBox");
                        int n2 = objectArray.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            ((JComboBox)jComponent2).addItem(objectArray[i2]);
                        }
                        if (object2 != null) {
                            ((JComboBox)jComponent2).setSelectedItem(object2);
                        }
                        this.inputComponent = jComponent2;
                        jComponent = jComponent2;
                    } else {
                        jComponent2 = new JList(objectArray);
                        JScrollPane jScrollPane = new JScrollPane(jComponent2);
                        jComponent2.setName("OptionPane.scrollPane");
                        jComponent2.setName("OptionPane.list");
                        ((JList)jComponent2).setVisibleRowCount(10);
                        ((JList)jComponent2).setSelectionMode(0);
                        if (object2 != null) {
                            ((JList)jComponent2).setSelectedValue(object2, true);
                        }
                        jComponent2.addMouseListener(new ListSelectionListener());
                        jComponent = jScrollPane;
                        this.inputComponent = jComponent2;
                    }
                } else {
                    jComponent2 = new MultiplexingTextField(20);
                    jComponent2.setName("OptionPane.textField");
                    ((MultiplexingTextField)jComponent2).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke("ENTER")});
                    if (object2 != null) {
                        String string = object2.toString();
                        ((JTextComponent)jComponent2).setText(string);
                        ((JTextComponent)jComponent2).setSelectionStart(0);
                        ((JTextComponent)jComponent2).setSelectionEnd(string.length());
                    }
                    ((JTextField)jComponent2).addActionListener(new TextFieldActionListener());
                    jComponent = this.inputComponent = jComponent2;
                }
                jComponent2 = object == null ? new Object[]{jComponent} : new Object[]{object, jComponent};
                return jComponent2;
            }
            return this.optionPane.getMessage();
        }
        return null;
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("close", new CloseAction());
    }

    protected Icon getIcon() {
        Icon icon;
        Icon icon2 = icon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (icon == null && this.optionPane != null) {
            icon = this.getIconForType(this.optionPane.getMessageType());
        }
        return icon;
    }

    protected Icon getIconForType(int n2) {
        if (n2 < 0 || n2 > 3) {
            return null;
        }
        String string = null;
        switch (n2) {
            case 0: {
                string = "OptionPane.errorIcon";
                break;
            }
            case 1: {
                string = "OptionPane.informationIcon";
                break;
            }
            case 2: {
                string = "OptionPane.warningIcon";
                break;
            }
            case 3: {
                string = "OptionPane.questionIcon";
            }
        }
        if (string != null) {
            SynthContext synthContext = this.getContext(this.optionPane, 1);
            Icon icon = synthContext.getStyle().getIcon(synthContext, string);
            synthContext.dispose();
            return icon;
        }
        return null;
    }

    InputMap getInputMap(int n2) {
        if (n2 == 2) {
            SynthContext synthContext = this.getContext(this.optionPane, 1);
            Object[] objectArray = (Object[])synthContext.getStyle().get(synthContext, "OptionPane.windowBindings");
            ComponentInputMap componentInputMap = null;
            if (objectArray != null) {
                componentInputMap = LookAndFeel.makeComponentInputMap(this.optionPane, objectArray);
            }
            synthContext.dispose();
            return componentInputMap;
        }
        return null;
    }

    private void configureButton(JButton jButton) {
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.minimumSize = (Dimension)this.style.get(synthContext, "OptionPane.minimumSize");
            this.multiClickThreshold = this.style.getInt(synthContext, "OptionPane.buttonClickThreshhold", 0);
        }
        synthContext.dispose();
    }

    public void installUI(JComponent jComponent) {
        this.optionPane = (JOptionPane)jComponent;
        this.installDefaults();
        this.optionPane.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallComponents();
        this.optionPane.setLayout(null);
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    private void configureMessageLabel(JLabel jLabel) {
    }

    public void selectInitialValue(JOptionPane jOptionPane) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
        } else {
            JRootPane jRootPane;
            if (this.initialFocusComponent != null) {
                this.initialFocusComponent.requestFocus();
            }
            if (this.initialFocusComponent instanceof JButton && (jRootPane = SwingUtilities.getRootPane(this.initialFocusComponent)) != null) {
                jRootPane.setDefaultButton((JButton)this.initialFocusComponent);
            }
        }
    }

    public boolean containsCustomComponents(JOptionPane jOptionPane) {
        return this.hasCustomComponents;
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if ((JOptionPane)jComponent == this.optionPane) {
            Dimension dimension = this.getMinimumOptionPaneSize();
            LayoutManager layoutManager = jComponent.getLayout();
            if (layoutManager != null) {
                Dimension dimension2 = layoutManager.preferredLayoutSize(jComponent);
                if (dimension != null) {
                    return new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
                }
                return dimension2;
            }
            return dimension;
        }
        return null;
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    protected Object[] getButtons(SynthContext synthContext) {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                int n2 = this.optionPane.getOptionType();
                Locale locale = this.optionPane.getLocale();
                SynthStyle synthStyle = synthContext.getStyle();
                Object[] objectArray2 = n2 == 0 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), synthStyle.getIcon(synthContext, "OptionPane.yesIcon")), new ButtonFactory(UIManager.getString((Object)"OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), synthStyle.getIcon(synthContext, "OptionPane.noIcon"))} : (n2 == 1 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), synthStyle.getIcon(synthContext, "OptionPane.yesIcon")), new ButtonFactory(UIManager.getString((Object)"OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), synthStyle.getIcon(synthContext, "OptionPane.noIcon")), new ButtonFactory(UIManager.getString((Object)"OptionPane.cancelButtonText", locale), this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), synthStyle.getIcon(synthContext, "OptionPane.cancelIcon"))} : (n2 == 2 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.okButtonText", locale), this.getMnemonic("OptionPane.okButtonMnemonic", locale), synthStyle.getIcon(synthContext, "OptionPane.okIcon")), new ButtonFactory(UIManager.getString((Object)"OptionPane.cancelButtonText", locale), this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), synthStyle.getIcon(synthContext, "OptionPane.cancelIcon"))} : new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.okButtonText", locale), this.getMnemonic("OptionPane.okButtonMnemonic", locale), synthStyle.getIcon(synthContext, "OptionPane.okIcon"))}));
                return objectArray2;
            }
            return objectArray;
        }
        return null;
    }

    protected void addButtonComponents(Container container, Object[] objectArray, int n2) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl2 = this.getSizeButtonsToSameWidth();
            boolean bl3 = true;
            int n3 = objectArray.length;
            JButton[] jButtonArray = null;
            if (bl2) {
                jButtonArray = new JButton[n3];
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                JButton jButton;
                Component component;
                Object object = objectArray[i2];
                if (object instanceof Component) {
                    bl3 = false;
                    component = (Component)object;
                    container.add(component);
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof ButtonFactory ? ((ButtonFactory)object).createButton() : (object instanceof Icon ? new JButton((Icon)object) : new JButton(object.toString()));
                    jButton.setName("OptionPane.button");
                    jButton.setMultiClickThreshhold(this.multiClickThreshold);
                    this.configureButton(jButton);
                    container.add(jButton);
                    ActionListener actionListener = this.createButtonActionListener(i2);
                    if (actionListener != null) {
                        jButton.addActionListener(actionListener);
                    }
                    component = jButton;
                }
                if (bl2 && bl3 && component instanceof JButton) {
                    jButtonArray[i2] = (JButton)component;
                }
                if (i2 != n2) continue;
                this.initialFocusComponent = component;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                jButton = (JButton)this.initialFocusComponent;
                jButton.addAncestorListener(new AncestorListener(){

                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        JButton jButton = (JButton)ancestorEvent.getComponent();
                        JRootPane jRootPane = SwingUtilities.getRootPane(jButton);
                        if (jRootPane != null) {
                            jRootPane.setDefaultButton(jButton);
                        }
                    }

                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }

                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    }
                });
            }
            ((ButtonAreaLayout)container.getLayout()).setSyncAllSizes(bl2 && bl3);
            if (bl2 && bl3) {
                int n4 = n3 <= 2 ? 8 : 4;
                for (int i3 = 0; i3 < n3; ++i3) {
                    JButton jButton = jButtonArray[i3];
                    jButton.setMargin(new Insets(2, n4, 2, n4));
                }
            }
        }
    }

    protected void burstStringInto(Container container, String string, int n2) {
        int n3 = string.length();
        if (n3 <= 0) {
            return;
        }
        if (n3 > n2) {
            int n4 = string.lastIndexOf(32, n2);
            if (n4 <= 0) {
                n4 = string.indexOf(32, n2);
            }
            if (n4 > 0 && n4 < n3) {
                this.burstStringInto(container, string.substring(0, n4), n2);
                this.burstStringInto(container, string.substring(n4 + 1), n2);
                return;
            }
        }
        JLabel jLabel = new JLabel(string, 2);
        jLabel.setName("OptionPane.label");
        this.configureMessageLabel(jLabel);
        container.add(jLabel);
    }

    private int getMnemonic(String string, Locale locale) {
        String string2 = (String)UIManager.get(string, locale);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthOptionPaneUI();
    }

    protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n2, boolean bl2) {
        if (object == null) {
            return;
        }
        if (object instanceof Component) {
            if (object instanceof JScrollPane || object instanceof JPanel) {
                gridBagConstraints.fill = 1;
                gridBagConstraints.weighty = 1.0;
            } else {
                gridBagConstraints.fill = 2;
            }
            gridBagConstraints.weightx = 1.0;
            container.add((Component)object, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            if (!bl2) {
                this.hasCustomComponents = true;
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                this.addMessageComponents(container, gridBagConstraints, objectArray[i2], n2, false);
            }
        } else if (object instanceof Icon) {
            JLabel jLabel = new JLabel((Icon)object, 0);
            this.configureMessageLabel(jLabel);
            this.addMessageComponents(container, gridBagConstraints, jLabel, n2, true);
        } else {
            String string = object.toString();
            int n3 = string.length();
            if (n3 <= 0) {
                return;
            }
            int n4 = -1;
            int n5 = 0;
            n4 = string.indexOf(newline);
            if (n4 >= 0) {
                n5 = newline.length();
            } else {
                n4 = string.indexOf("\r\n");
                if (n4 >= 0) {
                    n5 = 2;
                } else {
                    n4 = string.indexOf(10);
                    if (n4 >= 0) {
                        n5 = 1;
                    }
                }
            }
            if (n4 >= 0) {
                if (n4 == 0) {
                    JPanel jPanel = new JPanel(){

                        public Dimension getPreferredSize() {
                            Font font = this.getFont();
                            if (font != null) {
                                return new Dimension(1, font.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    };
                    jPanel.setName("OptionPane.break");
                    this.addMessageComponents(container, gridBagConstraints, jPanel, n2, true);
                } else {
                    this.addMessageComponents(container, gridBagConstraints, string.substring(0, n4), n2, false);
                }
                this.addMessageComponents(container, gridBagConstraints, string.substring(n4 + n5), n2, false);
            } else if (n3 > n2) {
                Box box = Box.createVerticalBox();
                box.setName("OptionPane.verticalBox");
                this.burstStringInto(box, string, n2);
                this.addMessageComponents(container, gridBagConstraints, box, n2, true);
            } else {
                JLabel jLabel = new JLabel(string, 10);
                jLabel.setName("OptionPane.label");
                this.configureMessageLabel(jLabel);
                this.addMessageComponents(container, gridBagConstraints, jLabel, n2, true);
            }
        }
    }

    class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public ButtonActionListener(int n2) {
            this.buttonIndex = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SynthOptionPaneUI.this.optionPane != null) {
                int n2 = SynthOptionPaneUI.this.optionPane.getOptionType();
                Object[] objectArray = SynthOptionPaneUI.this.optionPane.getOptions();
                if (SynthOptionPaneUI.this.inputComponent != null && (objectArray != null || n2 == -1 || (n2 == 0 || n2 == 1 || n2 == 2) && this.buttonIndex == 0)) {
                    SynthOptionPaneUI.this.resetInputValue();
                }
                if (objectArray == null) {
                    if (n2 == 2 && this.buttonIndex == 1) {
                        SynthOptionPaneUI.this.optionPane.setValue(new Integer(2));
                    } else {
                        SynthOptionPaneUI.this.optionPane.setValue(new Integer(this.buttonIndex));
                    }
                } else {
                    SynthOptionPaneUI.this.optionPane.setValue(objectArray[this.buttonIndex]);
                }
            }
        }
    }

    public static class ButtonAreaLayout
    implements LayoutManager {
        protected boolean syncAllSizes;
        protected int padding;
        private int orientation;
        private boolean reverseButtons;

        public int getOrientation() {
            return this.orientation;
        }

        public int getPadding() {
            return this.padding;
        }

        public boolean getSyncAllSizes() {
            return this.syncAllSizes;
        }

        public void setOrientation(int n2) {
            this.orientation = n2;
        }

        public void setPadding(int n2) {
            this.padding = n2;
        }

        public void setSyncAllSizes(boolean bl2) {
            this.syncAllSizes = bl2;
        }

        public ButtonAreaLayout(boolean bl2, int n2, int n3, boolean bl3) {
            this.syncAllSizes = bl2;
            this.padding = n2;
            this.orientation = n3;
            this.reverseButtons = bl3;
        }

        public void removeLayoutComponent(Component component) {
        }

        private int getOrientation(Container container) {
            if (container.getComponentOrientation().isLeftToRight()) {
                return this.getOrientation();
            }
            switch (this.getOrientation()) {
                case 2: {
                    return 4;
                }
                case 4: {
                    return 2;
                }
                case 0: {
                    return 0;
                }
            }
            return 2;
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n2;
                int n3 = componentArray.length;
                Insets insets = container.getInsets();
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    Dimension dimension = componentArray[n2].getPreferredSize();
                    n4 = Math.max(n4, dimension.width);
                    n5 = Math.max(n5, dimension.height);
                    n6 += dimension.width;
                }
                if (this.getSyncAllSizes()) {
                    n6 = n4 * n3;
                }
                n6 += (n3 - 1) * this.padding;
                switch (this.getOrientation(container)) {
                    case 2: {
                        n7 = insets.left;
                        break;
                    }
                    case 4: {
                        n7 = container.getWidth() - insets.right - n6;
                        break;
                    }
                    case 0: {
                        n7 = (container.getWidth() - n6) / 2;
                    }
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    int n8 = this.reverseButtons ? n3 - n2 - 1 : n2;
                    Dimension dimension = componentArray[n8].getPreferredSize();
                    if (this.getSyncAllSizes()) {
                        componentArray[n8].setBounds(n7, insets.top, n4, n5);
                    } else {
                        componentArray[n8].setBounds(n7, insets.top, dimension.width, dimension.height);
                    }
                    n7 += componentArray[n8].getWidth() + this.padding;
                }
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n2 = componentArray.length;
                int n3 = 0;
                Insets insets = container.getInsets();
                int n4 = insets.top + insets.bottom;
                int n5 = insets.left + insets.right;
                if (this.syncAllSizes) {
                    int n6 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Dimension dimension = componentArray[i2].getPreferredSize();
                        n3 = Math.max(n3, dimension.height);
                        n6 = Math.max(n6, dimension.width);
                    }
                    return new Dimension(n5 + n6 * n2 + (n2 - 1) * this.padding, n4 + n3);
                }
                int n7 = 0;
                for (int i3 = 0; i3 < n2; ++i3) {
                    Dimension dimension = componentArray[i3].getPreferredSize();
                    n3 = Math.max(n3, dimension.height);
                    n7 += dimension.width;
                }
                return new Dimension(n5 + (n7 += (n2 - 1) * this.padding), n4 + n3);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }
    }

    private static class ButtonFactory {
        private String text;
        private int mnemonic;
        private Icon icon;

        JButton createButton() {
            JButton jButton = new JButton(this.text);
            jButton.setIcon(this.icon);
            if (this.mnemonic != 0) {
                jButton.setMnemonic(this.mnemonic);
            }
            return jButton;
        }

        ButtonFactory(String string, int n2, Icon icon) {
            this.text = string;
            this.mnemonic = n2;
            this.icon = icon;
        }
    }

    private static class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane jOptionPane = (JOptionPane)actionEvent.getSource();
            jOptionPane.setValue(new Integer(-1));
        }
    }

    private class ListSelectionListener
    extends MouseAdapter {
        private ListSelectionListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                JList jList = (JList)mouseEvent.getSource();
                int n2 = jList.locationToIndex(mouseEvent.getPoint());
                SynthOptionPaneUI.this.optionPane.setInputValue(jList.getModel().getElementAt(n2));
            }
        }
    }

    private static class MultiplexingTextField
    extends JTextField {
        private KeyStroke[] strokes;

        MultiplexingTextField(int n2) {
            super(n2);
        }

        void setKeyStrokes(KeyStroke[] keyStrokeArray) {
            this.strokes = keyStrokeArray;
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
            boolean bl3 = super.processKeyBinding(keyStroke, keyEvent, n2, bl2);
            if (bl3 && n2 != 2) {
                for (int i2 = this.strokes.length - 1; i2 >= 0; --i2) {
                    if (!this.strokes[i2].equals(keyStroke)) continue;
                    return false;
                }
            }
            return bl3;
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == SynthOptionPaneUI.this.optionPane) {
                Object object;
                if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                    SynthOptionPaneUI.this.fetchStyle(SynthOptionPaneUI.this.optionPane);
                }
                if ("ancestor" == propertyChangeEvent.getPropertyName()) {
                    object = (JOptionPane)propertyChangeEvent.getSource();
                    boolean bl2 = propertyChangeEvent.getOldValue() == null;
                    switch (((JOptionPane)object).getMessageType()) {
                        case -1: {
                            if (!bl2) break;
                            SynthLookAndFeel.playSound(SynthOptionPaneUI.this.optionPane, "OptionPane.informationSound");
                            break;
                        }
                        case 3: {
                            if (!bl2) break;
                            SynthLookAndFeel.playSound(SynthOptionPaneUI.this.optionPane, "OptionPane.questionSound");
                            break;
                        }
                        case 1: {
                            if (!bl2) break;
                            SynthLookAndFeel.playSound(SynthOptionPaneUI.this.optionPane, "OptionPane.informationSound");
                            break;
                        }
                        case 2: {
                            if (!bl2) break;
                            SynthLookAndFeel.playSound(SynthOptionPaneUI.this.optionPane, "OptionPane.warningSound");
                            break;
                        }
                        case 0: {
                            if (!bl2) break;
                            SynthLookAndFeel.playSound(SynthOptionPaneUI.this.optionPane, "OptionPane.errorSound");
                            break;
                        }
                        default: {
                            System.err.println("Undefined JOptionPane type: " + ((JOptionPane)object).getMessageType());
                        }
                    }
                }
                if (((String)(object = propertyChangeEvent.getPropertyName())).equals("options") || ((String)object).equals("initialValue") || ((String)object).equals("icon") || ((String)object).equals("messageType") || ((String)object).equals("optionType") || ((String)object).equals("message") || ((String)object).equals("selectionValues") || ((String)object).equals("initialSelectionValue") || ((String)object).equals("wantsInput")) {
                    SynthOptionPaneUI.this.uninstallComponents();
                    SynthOptionPaneUI.this.installComponents();
                    SynthOptionPaneUI.this.optionPane.validate();
                } else if (((String)object).equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JOptionPane jOptionPane = (JOptionPane)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jOptionPane.applyComponentOrientation(componentOrientation);
                    }
                }
            }
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        private TextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SynthOptionPaneUI.this.optionPane.setInputValue(((JTextField)actionEvent.getSource()).getText());
        }
    }
}

