/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.exceptions.JARSigningException;
import com.sun.javaws.security.KeyStoreManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class SigningInfo {
    private static boolean hasMultipleSigners(Certificate[] certificateArray) {
        Certificate certificate = certificateArray[0];
        int n = 1;
        while (n < certificateArray.length) {
            Certificate certificate2 = certificateArray[n];
            if (!KeyStoreManager.isSigner(certificate, certificate2)) {
                return true;
            }
            certificate = certificate2;
            ++n;
        }
        return false;
    }

    private static boolean isSignedManifestEntry(Manifest manifest, String string) {
        Attributes attributes = manifest.getAttributes(string);
        if (attributes != null) {
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                if (!(string2 = string2.toUpperCase(Locale.ENGLISH)).endsWith("-DIGEST") && string2.indexOf("-DIGEST-") == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalChains(Certificate[] certificateArray, Certificate[] certificateArray2) {
        if (certificateArray.length != certificateArray2.length) {
            return false;
        }
        int n = 0;
        while (n < certificateArray.length) {
            if (!certificateArray[n].equals(certificateArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static Certificate[] checkSigning(URL uRL, String string, JarFile jarFile, DownloadProtocol.DownloadDelegate downloadDelegate, File file) throws JARSigningException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Certificate[] certificateArray = null;
        boolean bl = false;
        boolean bl2 = false;
        Object var8_8 = null;
        int n = jarFile.size();
        int n2 = 0;
        if (downloadDelegate != null) {
            downloadDelegate.validating(uRL, 0, n);
        }
        FilterOutputStream filterOutputStream = null;
        InputStream inputStream = null;
        try {
            object4 = new byte[32768];
            object3 = jarFile.entries();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                object = ((ZipEntry)object2).getName();
                if (!((String)object).startsWith("META-INF/") && !((String)object).endsWith("/") && ((ZipEntry)object2).getSize() != 0L) {
                    int n3;
                    Certificate[] certificateArray2;
                    inputStream = jarFile.getInputStream((ZipEntry)object2);
                    if (file != null && ((String)object).indexOf("/") == -1) {
                        certificateArray2 = new File(file, ((ZipEntry)object2).getName());
                        filterOutputStream = new BufferedOutputStream(new FileOutputStream((File)certificateArray2));
                    }
                    while ((n3 = inputStream.read((byte[])object4, 0, ((Object)object4).length)) != -1) {
                        if (filterOutputStream == null) continue;
                        ((BufferedOutputStream)filterOutputStream).write((byte[])object4, 0, n3);
                    }
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                        filterOutputStream = null;
                    }
                    inputStream.close();
                    inputStream = null;
                    certificateArray2 = ((JarEntry)object2).getCertificates();
                    if (certificateArray2 != null && certificateArray2.length == 0) {
                        certificateArray2 = null;
                    }
                    boolean bl3 = false;
                    if (certificateArray2 != null) {
                        bl3 = true;
                        if (certificateArray == null) {
                            if (SigningInfo.hasMultipleSigners(certificateArray2)) {
                                throw new JARSigningException(uRL, string, 0);
                            }
                            certificateArray = certificateArray2;
                        } else if (!SigningInfo.equalChains(certificateArray, certificateArray2)) {
                            throw new JARSigningException(uRL, string, 1);
                        }
                    }
                    bl = bl || bl3;
                    boolean bl4 = bl2 = bl2 || !bl3;
                }
                if (downloadDelegate == null) continue;
                downloadDelegate.validating(uRL, ++n2, n);
            }
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(uRL, string, 2, (Exception)securityException);
        }
        catch (IOException iOException) {
            throw new JARSigningException(uRL, string, 2, (Exception)iOException);
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
            }
        }
        if (bl && bl2) {
            throw new JARSigningException(uRL, string, 3);
        }
        if (certificateArray != null) {
            try {
                object4 = jarFile.getManifest();
                object3 = ((Manifest)object4).getEntries().entrySet();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    String string2 = (String)object.getKey();
                    if (!SigningInfo.isSignedManifestEntry((Manifest)object4, string2) || jarFile.getEntry(string2) != null) continue;
                    throw new JARSigningException(uRL, string, 4, string2);
                }
            }
            catch (IOException iOException) {
                throw new JARSigningException(uRL, string, 2, (Exception)iOException);
            }
        }
        return certificateArray;
    }
}

