/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.liveconnect;

import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import sun.plugin.liveconnect.JavaScriptProtectionDomain;
import sun.plugin.liveconnect.OriginNotAllowedException;
import sun.plugin.liveconnect.PrivilegedCallMethodAction;
import sun.plugin.liveconnect.PrivilegedConstructObjectAction;
import sun.plugin.liveconnect.PrivilegedGetFieldAction;
import sun.plugin.liveconnect.PrivilegedSetFieldAction;
import sun.plugin.services.PlatformService;
import sun.plugin.util.Trace;

public class SecureInvocation {
    private static ProtectionDomain getTrustedProtectionDomain() {
        Trace.msgLiveConnectPrintln("liveconnect.UniversalJavaPermission.enabled");
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return new JavaScriptProtectionDomain(permissions);
    }

    private static void checkLiveConnectCaller(Class clazz, String string, boolean bl) throws OriginNotAllowedException, MalformedURLException {
        if (bl) {
            Trace.msgLiveConnectPrintln("liveconnect.UniversalBrowserRead.enabled");
            return;
        }
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            Trace.msgLiveConnectPrintln("liveconnect.java.system");
            return;
        }
        URL uRL = codeSource.getLocation();
        URL uRL2 = null;
        if (string != null) {
            try {
                uRL2 = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return;
            }
        }
        if (uRL != null && uRL2 != null && uRL.getProtocol().equalsIgnoreCase(uRL2.getProtocol()) && uRL.getHost().equalsIgnoreCase(uRL2.getHost()) && uRL.getPort() == uRL2.getPort()) {
            Trace.msgLiveConnectPrintln("liveconnect.same.origin");
            return;
        }
        throw new OriginNotAllowedException("JavaScript is not from the same origin as the Java code, caller=" + uRL2 + ", callee=" + uRL);
    }

    private static ProtectionDomain getDefaultProtectionDomain(String string) throws MalformedURLException {
        Trace.msgLiveConnectPrintln("liveconnect.default.policy", new Object[]{string});
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Policy policy = Policy.getPolicy();
        CodeSource codeSource = new CodeSource(uRL, null);
        final PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        if (uRL == null || uRL.getProtocol().equals("file")) {
            permissionCollection.add(new FilePermission("<<ALL FILES>>", "read"));
            permissionCollection.add(new SocketPermission("localhost", "connect,accept"));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String string = InetAddress.getLocalHost().getHostName();
                        permissionCollection.add(new SocketPermission(string, "connect,accept"));
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        } else {
            final String string2 = uRL.getHost();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    permissionCollection.add(new SocketPermission(string2, "connect,accept"));
                    return null;
                }
            });
        }
        return new JavaScriptProtectionDomain(permissionCollection);
    }

    private static ProtectionDomain getProtectionDomain(Class clazz, String string, boolean bl, boolean bl2) throws OriginNotAllowedException, MalformedURLException {
        boolean bl3 = false;
        SecureInvocation.checkLiveConnectCaller(clazz, string, bl);
        if (bl2) {
            return SecureInvocation.getTrustedProtectionDomain();
        }
        return SecureInvocation.getDefaultProtectionDomain(string);
    }

    public static Object ConstructObject(final Class clazz, final Constructor constructor, final Object[] objectArray, final String string, final boolean bl, final boolean bl2) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    SecureInvocation.checkLiveConnectCaller(clazz, string, bl);
                    ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{!bl2 ? SecureInvocation.getDefaultProtectionDomain(string) : SecureInvocation.getTrustedProtectionDomain()};
                    AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
                    return AccessController.doPrivileged(new PrivilegedConstructObjectAction(constructor, objectArray), accessControlContext);
                }
                catch (Exception exception) {
                    Trace.liveConnectPrintException(exception);
                    throw exception;
                }
            }
        });
    }

    public static Object GetField(final Class clazz, final Object object, final Field field, final String string, final boolean bl, final boolean bl2) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    SecureInvocation.checkLiveConnectCaller(clazz, string, bl);
                    ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{!bl2 ? SecureInvocation.getDefaultProtectionDomain(string) : SecureInvocation.getTrustedProtectionDomain()};
                    AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
                    return AccessController.doPrivileged(new PrivilegedGetFieldAction(field, object), accessControlContext);
                }
                catch (Exception exception) {
                    Trace.liveConnectPrintException(exception);
                    throw exception;
                }
            }
        });
    }

    public static void SetField(final Class clazz, final Object object, final Field field, final Object object2, final String string, final boolean bl, final boolean bl2) throws Exception {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    SecureInvocation.checkLiveConnectCaller(clazz, string, bl);
                    ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{!bl2 ? SecureInvocation.getDefaultProtectionDomain(string) : SecureInvocation.getTrustedProtectionDomain()};
                    AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
                    AccessController.doPrivileged(new PrivilegedSetFieldAction(field, object, object2), accessControlContext);
                    return null;
                }
                catch (Exception exception) {
                    Trace.liveConnectPrintException(exception);
                    throw exception;
                }
            }
        });
    }

    public static Object CallMethod(int n, Class clazz, Object object, Method method, Object[] objectArray, String string, boolean bl, boolean bl2) throws Exception {
        CallMethodThread callMethodThread = new CallMethodThread(n, clazz, object, method, objectArray, string, bl, bl2);
        callMethodThread.start();
        PlatformService.getService().waitEvent(n);
        return callMethodThread.getResult();
    }

    private static Object CallMethod(final Class clazz, final Object object, final Method method, final Object[] objectArray, final String string, final boolean bl, final boolean bl2) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    SecureInvocation.checkLiveConnectCaller(clazz, string, bl);
                    ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{!bl2 ? SecureInvocation.getDefaultProtectionDomain(string) : SecureInvocation.getTrustedProtectionDomain()};
                    AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
                    return AccessController.doPrivileged(new PrivilegedCallMethodAction(method, object, objectArray), accessControlContext);
                }
                catch (Exception exception) {
                    Trace.liveConnectPrintException(exception);
                    throw exception;
                }
            }
        });
    }

    static class CallMethodThread
    extends Thread {
        private Exception exception = null;
        private Object result = null;
        private int handle;
        private Class clazz;
        private Object obj;
        private Method method;
        private Object[] args;
        private String origin;
        private boolean isUniversalBrowserRead;
        private boolean isUniversalJavaPermission;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.result = SecureInvocation.CallMethod(this.clazz, this.obj, this.method, this.args, this.origin, this.isUniversalBrowserRead, this.isUniversalJavaPermission);
            }
            catch (Exception exception) {
                this.exception = exception;
            }
            finally {
                PlatformService.getService().signalEvent(this.handle);
            }
        }

        public Object getResult() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        public CallMethodThread(int n, Class clazz, Object object, Method method, Object[] objectArray, String string, boolean bl, boolean bl2) {
            this.handle = n;
            this.clazz = clazz;
            this.obj = object;
            this.method = method;
            this.args = objectArray;
            this.origin = string;
            this.isUniversalBrowserRead = bl;
            this.isUniversalJavaPermission = bl2;
        }
    }
}

