//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMERRORDIALOG_H
#define PMERRORDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kdialogbase.h>

class QStringList;
class KConfig;
class QTextEdit;

/**
 * Dialog that is shown if some errors or warnings occured during
 * parsing or execution of commands.
 */
class PMErrorDialog : public KDialogBase
{
   Q_OBJECT
public:
   /**
    * Creates a modal PMErrorDialog with parent and name.
    *
    * messages is the message list
    *
    * errorFlags is a bitwise combination of @ref PMErrorFlags constants
    * If errorFlags contains PMEFatal, the 'Proceed' button will not be shown
    *
    * PMErrorDialog::exec( ) returns QDialog::Accepted if the command
    * should be continued.
    */
   PMErrorDialog( const QStringList& messages, int errorFlags,
                  QWidget* parent = 0, const char* name = 0 );

   static void saveConfig( KConfig* cfg );
   static void restoreConfig( KConfig* cfg );

protected:
   virtual void resizeEvent( QResizeEvent* ev );
   
private:
   void displayMessages( const QStringList& messages );
   
   static QSize s_size;
   QTextEdit* m_pTextView;
};

#endif
