/***************************************************************************
                            ReadOnlyPart.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef READONLYPART_H
#define READONLYPART_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/Part.h>

/**

 Base class for any "viewer" part.

 This class takes care of network transparency for you,
 in the simplest way (synchronously).
 To use the built-in network transparency, you only need to implement
 @ref -openFile, not @ref -openURL.
 To prevent network transparency, or to implement it another way
 (e.g. asynchronously), override -openURL.

 KParts Application can use the signals to show feedback while the URL is being loaded.

 ReadOnlyPart handles the window caption by setting it to the current URL
 (set in @ref  #--openURL, and each time the part is activated).
 If you want another caption, set it in @ref -openFile and
 (if the part might ever be used with a part manager) in @ref -guiActivateEvent
 
 @short 
 Base class for any "viewer" part.
*/
@class GUIActivateEvent; 
@class KURL; 
@class PartActivateEvent; 
@class PartSelectEvent; 

@interface ReadOnlyPart : Part 

/** 
 Destructor
   
*/
- (void) dealloc;

/** 
 Call this to turn off the progress info dialog used by
 the internal KIO job. Use this if you provide another way
 of displaying progress info (e.g. a statusbar), using the
 signals emitted by this class, and/or those emitted by
 the Job given by @ref started.
   
*/
- showProgressInfo: (BOOL)show;

/** 
  Returns the currently in part used URL.

*/
- (KURL*) url;

/** 
 Called when closing the current url (e.g. document), for instance
 when switching to another url (note that @ref  #--openURL calls it
 automatically in this case).
 If the current URL is not fully loaded yet, aborts loading.
 Deletes the temporary file used when the url is remote.

*/
- (BOOL) closeURL;

/** 
 Only reimplement openURL if you don't want synchronous network transparency
 Otherwise, reimplement @ref -openFile only .

 If you reimplement it, don't forget to set the caption, usually with
 emit setWindowCaption( url.-prettyURL );
   
*/
- (BOOL) openURL: (KURL*)url;
@end

/** Override these methods in subclasses of ReadOnlyPart to customise event handling behaviour */
@protocol ReadOnlyPartEventHandling

/** 
 Convenience method which is called when the Part received a @ref PartActivateEvent .
 Reimplement this if you don't want to reimplement @ref event and test for the event yourself
 or even install an event filter.
     
*/
- partActivateEvent:(PartActivateEvent*) event;

/** 
 Convenience method which is called when the Part received a
 @ref PartSelectEvent .
 Reimplement this if you don't want to reimplement @ref event and
 test for the event yourself or even install an event filter.
     
*/
- partSelectEvent:(PartSelectEvent*) event;
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) event;

/** 
 Reimplemented from Part, so that the window caption is set to
 the current url (decoded) when the part is activated
 This is the usual behaviour in 99% of the apps
 Reimplement if you don't like it - test for -[event activated] !

 Technical note : this is done with GUIActivateEvent and not with
 PartActivateEvent because it's handled by the mainwindow
 (which gets the even after the PartActivateEvent events have been sent)
   
*/
- guiActivateEvent:(GUIActivateEvent*) event;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
