/***************************************************************************
                            KSelectAction.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSELECTACTION_H
#define KSELECTACTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KAction.h>

/**

  Action for selecting one of several items.

  This action shows up a submenu with a list of items.
  One of them can be checked. If the user clicks on an item
  this item will automatically be checked,
  the formerly checked item becomes unchecked.
  There can be only one item checked at a time.

 @short Action for selecting one of several items.
*/
@class QIconSet; 
@class QPopupMenu; 

@class QKeySequence; 

@class KShortcut; 

@interface KSelectAction : KAction 

/** 
 Constructs a select action with text and potential keyboard
 accelerator but nothing else. Use this only if you really
 know what you are doing.

*/
- initWithText: (NSString *)text cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text ;

/** 

*/
- initWithText: (NSString *)text cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/** 

*/
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmap: (QIconSet*)pix ;

/** 

*/
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmapFor: (NSString *)pix ;

/** 

*/
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/** 

*/
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/** 

*/
- initWithObject: (QObject *)parent name: (NSString *)name;
- init;

/** 
 Destructor
     
*/
- (void) dealloc;

/** 
  "Plug" or insert this action into a given widget.

  This will typically be a menu or a toolbar.
  From this point on, you will never need to directly
  manipulate the item in the menu or toolbar.
  You do all enabling/disabling/manipulation directly with your KSelectAction object.

*/
- (int) plug: (QWidget *)widget index: (int)index;
- (int) plug: (QWidget *)widget ;

/** 
 When this action is plugged into a toolbar, it creates a combobox.

*/
- (BOOL) isEditable;

/** 

*/
- (NSArray *) items;
- changeIntItem: (int)index text: (NSString *)text;
- (NSString *) currentText;
- (int) currentItem;

/** 
 When this action is plugged into a toolbar, it creates a combobox.
 This returns the maximum width set by setComboWidth
     
*/
- (int) comboWidth;
- (QPopupMenu*) popupMenu;

/** 
  Sets the currently checked item.

*/
- setCurrentItem: (int)index;

/** 
 Sets the items to be displayed in this action
 You need to call this.
     
*/
- setItems: (NSArray *)lst;

/** 
 Clears up all the items in this action
     
*/
- clear;

/** 
 When this action is plugged into a toolbar, it creates a combobox.
 This makes the combo editable or read-only.
     
*/
- setEditable: (BOOL)arg1;

/** 
 When this action is plugged into a toolbar, it creates a combobox.
 This gives a _maximum_ size to the combobox.
 The minimum size is automatically given by the contents (the items).
     
*/
- setComboWidth: (int)width;
- changeIntItem: (int)identifier index: (int)index text: (NSString *)text;
- setCurrentItem: (int)identifier index: (int)index;
- setComboWidth: (int)identifier width: (int)width;
- setItems: (int)identifier lst: (NSArray *)lst;
- clear: (int)identifier;
- slotActivatedWithId: (int)identifier;
- slotActivated: (NSString *)text;
- slotActivated;
@end

/** Override these methods in subclasses of KSelectAction to customise event handling behaviour */
@protocol KSelectActionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
