/***************************************************************************
                            KPopupTitle.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Title widget for use in {@link KPopupMenu}.

 You usually don't have to create this manually since
 {@link KPopupMenu#insertTitle} will do it for you, but it is allowed if
 you wish to customize it's look.

 See {@link KPopupTitleSignals} for signals emitted by KPopupTitle.

 

 @author Daniel M. Duley <mosfet@kde.org>

 @short KPopupMenu title widget.
 
*/
public class KPopupTitle extends QWidget  {
	protected KPopupTitle(Class dummy){super((Class) null);}

	private native void newKPopupTitle( QWidget parent, String name);

/** 
 Constructs a title widget with the user specified gradient, pixmap,
 and colors.
     
*/
	public KPopupTitle( QWidget parent, String name) {
		super((Class) null);
		newKPopupTitle( parent, name);
	}
	private native void newKPopupTitle();
	public KPopupTitle() {
		super((Class) null);
		newKPopupTitle();
	}
	private native void newKPopupTitle( int gradient, QColor color, QColor textColor, QWidget parent, String name);

/** 
 Constructs a title widget with the specified gradient and colors.
     
*/
	public KPopupTitle( int gradient, QColor color, QColor textColor, QWidget parent, String name) {
		super((Class) null);
		newKPopupTitle( gradient, color, textColor, parent, name);
	}
	private native void newKPopupTitle( int gradient, QColor color, QColor textColor);
	public KPopupTitle( int gradient, QColor color, QColor textColor) {
		super((Class) null);
		newKPopupTitle( gradient, color, textColor);
	}
	private native void newKPopupTitle( KPixmap background, QColor color, QColor textColor, QWidget parent, String name);

/** 
 Constructs a title widget with the specified pixmap and colors.
     
*/
	public KPopupTitle( KPixmap background, QColor color, QColor textColor, QWidget parent, String name) {
		super((Class) null);
		newKPopupTitle( background, color, textColor, parent, name);
	}
	private native void newKPopupTitle( KPixmap background, QColor color, QColor textColor);
	public KPopupTitle( KPixmap background, QColor color, QColor textColor) {
		super((Class) null);
		newKPopupTitle( background, color, textColor);
	}

/** 
 Sets the title string and optional icon for the title widget.

 You will want to call this before inserting into a menu.
     
*/
	public native void setTitle( String text, QPixmap icon);
	public native void setTitle( String text);

/** 
 Returns the current title.
     
*/
	public native String title();

/** 
 Returns the current icon.
     
*/
	public native QPixmap icon();
	public native QSize sizeHint();
	public native void setText( String text);
	public native void setIcon( QPixmap pix);
	protected native void paintEvent( QPaintEvent ev);
	protected native void virtual_hook( int identifier, int data);
}
