/***************************************************************************
                            KConfigBackEnd.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Abstract base class for KDE configuration file loading/saving.

 This class forms the base for all classes that implement some
 manner of loading/saving to configuration files.  It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. As of right now, the only back end available
 is one to read/write to INI-style files, but in the future, other
 formats may be available, such as XML or a database.

 @author Preston Brown <pbrown@kde.org>, 
         Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: KConfigBackEnd.java,v 1.7 2002/11/26 04:17:31 rdale Exp $

 @short KDE Configuration file loading/saving abstract base class.
*/
public class  KConfigBackEnd implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KConfigBackEnd(Class dummy){}


/** 
 Destructs the configuration backend.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Parses all configuration files for a configuration object.  This
 method must be reimplemented by the derived classes.

*/
	public native boolean parseConfigFiles();

/** 
 Writes configuration data to file(s).  This method must be
 reimplemented by the derived classes.

*/
	public native void sync( boolean bMerge);
	public native void sync();

/** 
 Changes the filenames associated with this back end.  You should
 probably reparse your config info after doing this.

*/
	public native void changeFileName( String _fileName, String _resType, boolean _useKDEGlobals);

/** 
 Returns the state of the app-config object.

*/
	public native int getConfigState();

/** 
 Returns the filename as passed to the constructor.

*/
	public native String fileName();

/** 
 Returns the resource type as passed to the constructor.

*/
	public native String resource();

/** 
 Set the locale string that defines the current language.

*/
	public native void setLocaleString( String _localeString);

/** 
 Set the file mode for newly created files.

*/
	public native void setFileWriteMode( int mode);
}
