/***************************************************************************
                          dubdoc.cpp  -  description
                             -------------------
    begin                : Tue Oct 23 01:44:51 EEST 2001
    copyright            : (C) 2001 by Eray Ozkural (exa)
    email                : erayo@cs.bilkent.edu.tr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qwidget.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>

// application specific includes
#include "dubdoc.h"
#include "dub.h"
#include "dubview.h"
#include "dubdoc.moc"

DubDoc::DubDoc(QWidget *parent, const char *name) : QObject(parent, name)
{
  pViewList.setAutoDelete(true);
}

DubDoc::~DubDoc()
{
}

void DubDoc::addView(DubView *view)
{
  pViewList.append(view);
}

void DubDoc::removeView(DubView *view)
{
  pViewList.remove(view);
}
void DubDoc::setURL(const KURL &url)
{
  doc_url=url;
}

const KURL& DubDoc::URL() const
{
  return doc_url;
}

void DubDoc::slotUpdateAllViews(DubView *sender)
{
  DubView *w;
  for(w=pViewList.first(); w!=0; w=pViewList.next()) {
    if(w!=sender)
      w->repaint();
  }

}

bool DubDoc::saveModified()
{
  bool completed=true;

  if(modified)
  {
    DubApp *win=(DubApp *) parent();
    int want_save = KMessageBox::warningYesNoCancel(win,
                                         i18n("The current file has been modified.\n"
                                              "Do you want to save it?"),
                                         i18n("Warning"));
    switch(want_save)
    {
      case KMessageBox::Yes:
           if (doc_url.fileName() == i18n("Untitled"))
           {
             win->slotFileSaveAs();
           }
           else
           {
             saveDocument(URL());
       	   };

       	   deleteContents();
           completed=true;
           break;

      case KMessageBox::No:
           setModified(false);
           deleteContents();
           completed=true;
           break;

      case KMessageBox::Cancel:
           completed=false;
           break;

      default:
           completed=false;
           break;
    }
  }

  return completed;
}

void DubDoc::closeDocument()
{
  deleteContents();
}

bool DubDoc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  modified=false;
  doc_url.setFileName(i18n("Untitled"));

  return true;
}

bool DubDoc::openDocument(const KURL& url, const char *format /*=0*/)
{
  QString tmpfile;
  KIO::NetAccess::download( url, tmpfile );
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
  /////////////////////////////////////////////////

  KIO::NetAccess::removeTempFile( tmpfile );

  modified=false;
  return true;
}

bool DubDoc::saveDocument(const KURL& url, const char *format /*=0*/)
{
  /////////////////////////////////////////////////
  // TODO: Add your document saving code here
  /////////////////////////////////////////////////

  modified=false;
  return true;
}

void DubDoc::deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////

}
