#ifdef HAVE_CONFIG_H
#include <rasqal_config.h>
#endif

#ifdef WIN32
#include <win32_rasqal_config.h>
#endif

#line 10 "rdql_lexer.c"

#line 12 "rdql_lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE rdql_lexer_restart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via rdql_lexer_restart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void rdql_lexer_restart (FILE *input_file ,yyscan_t yyscanner );
void rdql_lexer__switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE rdql_lexer__create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void rdql_lexer__delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void rdql_lexer__flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void rdql_lexer_push_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void rdql_lexer_pop_buffer_state (yyscan_t yyscanner );

static void rdql_lexer_ensure_buffer_stack (yyscan_t yyscanner );
static void rdql_lexer__load_buffer_state (yyscan_t yyscanner );
static void rdql_lexer__init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER rdql_lexer__flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE rdql_lexer__scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE rdql_lexer__scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE rdql_lexer__scan_bytes (yyconst char *bytes,int len ,yyscan_t yyscanner );

void *rdql_lexer_alloc (yy_size_t ,yyscan_t yyscanner );
void *rdql_lexer_realloc (void *,yy_size_t ,yyscan_t yyscanner );
void rdql_lexer_free (void * ,yyscan_t yyscanner );

#define yy_new_buffer rdql_lexer__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        rdql_lexer_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            rdql_lexer__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        rdql_lexer_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            rdql_lexer__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 52
#define YY_END_OF_BUFFER 53
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[208] =
    {   0,
        0,    0,    0,    0,    0,    0,   53,   51,    4,    3,
        3,   37,   51,   50,   35,   51,   51,   13,   14,   33,
       31,   12,   32,   51,   34,   38,   38,   51,   51,   28,
       15,   45,   45,   45,   45,   45,   45,   45,   45,   45,
       45,   45,   45,   45,   45,   45,   45,   45,   51,   36,
       24,   22,   23,   23,   24,   46,   45,    4,    3,   26,
       21,    0,   42,    0,   17,    0,   41,    0,    0,    2,
        0,   38,   40,   38,    0,    0,   27,   29,    0,   27,
       25,   20,   30,   45,   47,   45,   18,   45,   45,   19,
       45,   45,   45,   45,   45,   45,   45,   45,   45,   45,

       45,   45,   45,   45,   45,   16,   22,   23,    0,    0,
        0,    0,    0,    0,    1,    1,   40,    0,    0,   40,
       39,    0,    0,    0,    0,    0,   47,    9,   11,   45,
       45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
       45,   45,   42,    0,   41,    0,    0,   40,    0,   40,
       40,   49,   48,    0,   48,    0,   47,   47,    7,   45,
       45,   45,   45,   45,   44,   45,   45,   43,   45,   45,
       42,    0,    0,   41,    0,    0,   40,   40,    0,    0,
        0,    0,   45,   45,   10,    8,   45,   45,    0,    0,
       42,    0,    0,   41,    5,    6,    0,   42,    0,   41,

       42,   42,   42,   41,   41,   41,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    1,    8,    9,   10,   11,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   21,    1,   22,
       23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
       33,   34,   35,   36,   36,   37,   38,   39,   40,   36,
       41,   42,   43,   44,   45,   36,   46,   47,   36,   36,
        1,   48,    1,   49,   50,    1,   51,   28,   52,   53,

       54,   55,   56,   57,   58,   36,   36,   59,   60,   61,
       62,   36,   63,   64,   65,   66,   67,   36,   68,   47,
       36,   36,    1,   69,    1,   70,    1,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,

       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71
    } ;

static yyconst flex_int32_t yy_meta[72] =
    {   0,
        1,    1,    2,    2,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    3,    1,    1,    4,    4,
        5,    6,    1,    7,    1,    1,    8,    8,    8,    8,
        8,    8,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,   10,   11,   12,
        8,    8,    8,    8,    8,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    1,    1,
       10
    } ;

static yyconst flex_int16_t yy_base[237] =
    {   0,
        0,    0,   71,    0,  142,    0,  840, 1002,  829, 1002,
      820,  191,  209, 1002, 1002,  813,  206, 1002, 1002, 1002,
     1002, 1002, 1002,  198,  206,  215,  219,  278,  197,  798,
     1002,  201,  785,  202,  205,  206,  220,  210,  208,    0,
      207,  209,  329,  330,  332,  212,  331,  333,  733,  731,
     1002,  798, 1002,  793,    0, 1002,    0,  790, 1002, 1002,
     1002,  350,  222,    0, 1002,  347,  329,    0,  345, 1002,
      255, 1002,  348,  352,  368,    0, 1002, 1002,  411,  770,
     1002, 1002, 1002,  756,    0,  234,  744,  223,  341,  741,
      338,  340,  228,  339,    0,  352,  342,  345,  379,  371,

      383,  382,  386,  387,  356, 1002,  759, 1002,    0,  711,
        0,  710,  424,  443, 1002,  755,  431,  438,  436,  444,
        0,  733,  499,  569,  735,  731,  449,  732,  731,  410,
      440,  445,  438,  446,  414,  418,  468,  461,  406,  465,
      469,  454,  702,  728,  698,  724,  453,  509,  464,  512,
     1002, 1002, 1002,  640, 1002,  527,  475,  517,  722,  505,
      524,  517,  528,  691,  721,  514,  692,  715,  693,  694,
      680,    0,  702,  512,    0,  477, 1002, 1002,    0,    0,
      536,  700,  519,  696,  475,  472,  697,  700,    0,  471,
        0,    0,  353,    0,  256,  254,  246,  538,  242,  706,

     1002,  712,  714, 1002,  719,  721, 1002,  763,  775,  785,
      795,  807,  816,  824,  834,  839,  844,  846,  855,  861,
      871,  881,  888,  896,  903,  911,  916,  923,  928,  935,
      947,  952,  964,  969,  979,  989
    } ;

static yyconst flex_int16_t yy_def[237] =
    {   0,
      207,    1,  207,    3,  207,    5,  207,  207,  207,  207,
      207,  207,  208,  207,  207,  207,  209,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  210,  210,  210,  210,  210,  210,  210,  210,  211,
      210,  210,  210,  210,  210,  210,  210,  210,  207,  207,
      207,  207,  207,  207,  211,  207,  211,  207,  207,  207,
      207,  208,  207,  208,  207,  209,  207,  209,  207,  207,
      212,  207,  207,  207,  207,  213,  207,  207,  214,  215,
      207,  207,  207,  210,  216,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  211,  210,  210,  210,  210,  210,

      210,  210,  210,  210,  210,  207,  207,  207,  217,  207,
      218,  207,  207,  212,  207,  207,  207,  207,  207,  207,
      213,  219,  214,  207,  215,  220,  221,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  222,  223,  224,  225,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  226,  221,  221,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      222,  227,  228,  224,  229,  230,  207,  207,  154,  154,
      226,  226,  210,  210,  210,  210,  210,  210,  231,  228,
      232,  233,  230,  234,  210,  210,  231,  235,  233,  236,

      207,  235,  235,  207,  236,  236,    0,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207
    } ;

static yyconst flex_int16_t yy_nxt[1074] =
    {   0,
        8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
       18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
        8,   28,   29,   30,   31,    8,   32,   33,   33,   33,
       34,   35,   33,   33,   33,   33,   33,   33,   36,   33,
       33,   33,   37,   33,   38,   39,   33,   33,    8,   40,
       41,   33,   33,   42,   43,   33,   33,   33,   33,   33,
       44,   33,   33,   33,   45,   46,   47,   48,   49,   50,
       33,   51,   52,   53,   54,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   55,   55,   55,

       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   51,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   51,
       51,   55,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   57,   57,
       57,   57,   57,   57,   57,   57,   57,   57,   57,   57,
       57,   57,   57,   57,   57,   57,   57,   57,   57,   57,
       56,   57,   57,   57,   57,   57,   57,   57,   57,   57,

       57,   57,   57,   57,   57,   57,   57,   57,   57,   57,
       56,   56,   57,   60,   63,   67,   69,   69,   70,   81,
       72,   85,   85,   71,   72,   85,   85,   85,   85,   85,
       85,   73,   85,   74,   74,   73,   90,   74,   74,   86,
       85,   94,   87,   85,   88,   75,   89,  109,   85,   75,
       91,   72,   93,   68,   85,   72,   64,  115,  116,   92,
       61,   76,  133,  128,  129,  204,   82,   96,   75,  201,
      110,   87,   75,   72,   85,  103,   85,   72,   77,   77,
       77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   77,   77,   77,   77,

       78,   77,   77,   77,   79,   79,   79,   79,   79,   79,
       79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
       79,   79,   79,   79,   79,   80,   77,   77,   79,   79,
       79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
       79,   79,   79,   79,   79,   79,   77,   77,   80,   85,
       85,   85,   85,   85,  111,   63,   67,   72,   85,   85,
       85,   85,   85,   69,   69,   85,  117,  117,   73,  134,
       74,   74,   85,  194,  131,  113,   85,  112,  118,   97,
      130,  119,   75,  119,  132,  101,  120,  120,   72,  105,
       98,   85,   99,  102,   68,  104,  100,   64,  113,   85,

      135,  118,   85,   85,  128,   75,   85,   85,  129,  142,
       72,  122,  122,  122,  122,  122,  122,  122,  122,  122,
      122,  122,  122,  122,  122,  122,   85,  122,  122,  137,
       85,  124,  122,  122,   85,  122,  122,  147,   85,  147,
      136,  138,  148,  148,  141,  115,  116,  159,  139,  117,
      117,  149,  140,  149,  120,  120,  150,  150,   85,  122,
       85,  118,  120,  120,  157,   85,   85,  157,  157,  167,
      160,  148,  148,  151,   85,  151,  162,  159,  164,  122,
      122,   85,  150,  150,  118,   85,  161,  163,   85,   85,
      157,  191,   85,  157,  157,   85,  151,  194,  151,  122,

      122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
      122,  122,  122,  122,  166,  122,  122,  170,  168,  124,
      122,  122,  152,  122,  122,   85,  165,  148,  148,  169,
      150,  150,  157,  183,   85,  157,  157,   85,  177,   85,
      177,  178,  181,  178,   85,  181,  181,  122,   85,  185,
      155,  181,  184,  202,  181,  181,  202,  202,  186,  155,
      112,  177,  195,  177,  178,  187,  178,  122,  122,  122,
      122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
      122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
      122,  122,  153,  122,  122,  154,  154,  154,  154,  154,

      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  122,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  122,  122,  154,
      122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
      122,  122,  122,  122,  122,  179,  122,  122,  179,  179,
      122,  122,  122,  153,  122,  122,  180,  180,  180,  180,
      180,  180,  180,  180,  180,  180,  180,  180,  180,  180,
      180,  180,  180,  180,  180,  180,  180,  180,  122,  180,
      180,  180,  180,  180,  180,  180,  180,  180,  180,  180,

      180,  180,  180,  180,  180,  180,  180,  180,  122,  122,
      180,   85,   85,   85,   85,  181,   85,   85,  181,  181,
       85,  205,  191,  155,  205,  205,  196,  202,  110,  202,
      202,  202,  202,  202,  205,   85,  205,  205,  205,  205,
      205,   85,   85,  188,  168,  175,  112,  186,  185,  172,
      110,   85,   85,  196,  155,  126,  152,  115,  146,  144,
      107,   85,  195,   62,   85,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   66,   85,   66,   66,   66,
       66,   66,   66,   66,   66,   66,   66,   84,   84,   84,
      126,   58,   84,   84,   84,  108,   84,   95,   95,  107,

       82,  106,   95,   95,   95,   85,   95,  114,  114,  114,
      114,  114,  114,  114,  114,  114,  114,  114,  114,  121,
       83,   65,   59,  121,  123,  123,  123,  123,  123,  123,
       58,  123,  123,  123,  123,  123,  125,  125,  125,  207,
      207,  125,  125,  125,  207,  125,  127,  127,  127,  207,
      127,  143,  143,  145,  145,  122,  122,  122,  122,  122,
      122,  122,  122,  122,  122,  122,  122,  156,  156,  156,
      156,  207,  156,  158,  158,  207,  207,  207,  158,  158,
      158,  207,  158,  171,  171,  207,  207,  207,  171,  171,
      207,  171,  171,  173,  207,  173,  173,  173,  174,  174,

      207,  207,  207,  174,  174,  207,  174,  174,  176,  207,
      176,  176,  176,  182,  182,  207,  207,  182,  182,  182,
      182,  207,  182,  189,  189,  190,  190,  190,  207,  207,
      190,  190,  190,  207,  190,  192,  192,  193,  193,  193,
      207,  207,  193,  193,  193,  207,  193,  197,  197,  197,
      197,  197,  197,  207,  197,  197,  197,  197,  197,  198,
      198,  198,  207,  198,  199,  199,  199,  199,  199,  199,
      207,  199,  199,  199,  199,  199,  200,  200,  200,  207,
      200,  203,  203,  207,  207,  207,  203,  203,  203,  207,
      203,  206,  206,  207,  207,  207,  206,  206,  206,  207,

      206,    7,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207
    } ;

static yyconst flex_int16_t yy_chk[1074] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,

        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,

        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,   12,   13,   17,   24,   24,   25,   29,
       26,   32,   34,   25,   27,   35,   36,   41,   39,   42,
       38,   26,   46,   26,   26,   27,   36,   27,   27,   32,
       37,   39,   34,   88,   35,   26,   35,   63,   93,   27,
       37,   26,   38,   17,   86,   27,   13,   71,   71,   37,
       12,   26,   93,   86,   88,  199,   29,   41,   26,  197,
       63,   42,   27,   26,  196,   46,  195,   27,   28,   28,
       28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
       28,   28,   28,   28,   28,   28,   28,   28,   28,   28,

       28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
       28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
       28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
       28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
       28,   28,   28,   28,   28,   28,   28,   28,   28,   43,
       44,   47,   45,   48,   67,   62,   66,   74,   91,   94,
       92,   89,   97,   69,   69,   98,   73,   73,   74,   94,
       74,   74,   96,  193,   91,   69,  105,   67,   73,   43,
       89,   75,   74,   75,   92,   45,   75,   75,   74,   48,
       43,  100,   43,   45,   66,   47,   44,   62,   69,   99,

       97,   73,  102,  101,   96,   74,  103,  104,   98,  105,
       74,   79,   79,   79,   79,   79,   79,   79,   79,   79,
       79,   79,   79,   79,   79,   79,  139,   79,   79,  100,
      130,   79,   79,   79,  135,   79,   79,  113,  136,  113,
       99,  101,  113,  113,  104,  114,  114,  130,  102,  117,
      117,  118,  103,  118,  119,  119,  118,  118,  133,   79,
      131,  117,  120,  120,  127,  132,  134,  127,  127,  139,
      131,  147,  147,  120,  142,  120,  133,  136,  135,   79,
       79,  138,  149,  149,  117,  140,  132,  134,  137,  141,
      157,  190,  186,  157,  157,  185,  120,  176,  120,  123,

      123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
      123,  123,  123,  123,  138,  123,  123,  142,  140,  123,
      123,  123,  123,  123,  123,  160,  137,  148,  148,  141,
      150,  150,  158,  160,  166,  158,  158,  162,  148,  183,
      148,  150,  156,  150,  161,  156,  156,  123,  163,  162,
      156,  181,  161,  198,  181,  181,  198,  198,  163,  181,
      174,  148,  183,  148,  150,  166,  150,  123,  123,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,

      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,

      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  164,  167,  169,  170,  182,  184,  187,  182,  182,
      188,  200,  173,  182,  200,  200,  184,  202,  171,  203,
      202,  202,  203,  203,  205,  168,  206,  205,  205,  206,
      206,  165,  159,  167,  164,  146,  145,  170,  169,  144,
      143,  129,  128,  188,  126,  125,  122,  116,  112,  110,
      107,   90,  187,  208,   87,  208,  208,  208,  208,  208,
      208,  208,  208,  208,  208,  209,   84,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  210,  210,  210,
       80,   58,  210,  210,  210,   54,  210,  211,  211,   52,

       50,   49,  211,  211,  211,   33,  211,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  213,
       30,   16,   11,  213,  214,  214,  214,  214,  214,  214,
        9,  214,  214,  214,  214,  214,  215,  215,  215,    7,
        0,  215,  215,  215,    0,  215,  216,  216,  216,    0,
      216,  217,  217,  218,  218,  219,  219,  219,  219,  219,
      219,  219,  219,  219,  219,  219,  219,  220,  220,  220,
      220,    0,  220,  221,  221,    0,    0,    0,  221,  221,
      221,    0,  221,  222,  222,    0,    0,    0,  222,  222,
        0,  222,  222,  223,    0,  223,  223,  223,  224,  224,

        0,    0,    0,  224,  224,    0,  224,  224,  225,    0,
      225,  225,  225,  226,  226,    0,    0,  226,  226,  226,
      226,    0,  226,  227,  227,  228,  228,  228,    0,    0,
      228,  228,  228,    0,  228,  229,  229,  230,  230,  230,
        0,    0,  230,  230,  230,    0,  230,  231,  231,  231,
      231,  231,  231,    0,  231,  231,  231,  231,  231,  232,
      232,  232,    0,  232,  233,  233,  233,  233,  233,  233,
        0,  233,  233,  233,  233,  233,  234,  234,  234,    0,
      234,  235,  235,    0,    0,    0,  235,  235,  235,    0,
      235,  236,  236,    0,    0,    0,  236,  236,  236,    0,

      236,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
      207,  207,  207
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "./rdql_lexer.l"
/* -*- Mode: c; c-basic-offset: 2 -*-
 *
 * rdql_lexer.l - Rasqal RDQL lexer - making tokens for rdql grammar generator
 *
 * Copyright (C) 2003-2008, David Beckett http://www.dajobe.org/
 * Copyright (C) 2003-2005, University of Bristol, UK http://www.bristol.ac.uk/
 * 
 * This package is Free Software and part of Redland http://librdf.org/
 * 
 * It is licensed under the following three licenses as alternatives:
 *   1. GNU Lesser General Public License (LGPL) V2.1 or any newer version
 *   2. GNU General Public License (GPL) V2 or any newer version
 *   3. Apache License, V2.0 or any newer version
 * 
 * You may not use this file except in compliance with at least one of
 * the above three licenses.
 * 
 * See LICENSE.html or LICENSE.txt at the top of this package for the
 * complete terms and further detail along with the license texts for
 * the licenses in COPYING.LIB, COPYING and LICENSE-2.0.txt respectively.
 * 
 * To generate the C files from this source, rather than use the
 * shipped rdql_lexer.c/.h needs a patched version of flex 2.5.31 such
 * as the one available in Debian GNU/Linux.   Details below
 * near the %option descriptions.
 *
 */
/* recognise 8-bits */
/* all symbols prefixed by this */
/* This is not needed, flex is invoked -ordql_lexer.c */
/* Emit a C header file for prototypes
 * Only available in flex 2.5.13 or newer.
 * It was renamed to header-file in flex 2.5.19
 */
/* Do not emit #include <unistd.h>
 * Only available in flex 2.5.7 or newer.
 * Broken in flex 2.5.31 without patches.
 */
#define YY_NO_UNISTD_H 1
/* Never interactive */
/*  No isatty() check */
/* Batch scanner */
/* Never use yyunput */
/* Supply our own alloc/realloc/free functions */
/* Re-entrant scanner */

/* definitions */
#line 74 "./rdql_lexer.l"

/* NOTE: These headers are NOT included here. They are inserted by fix-flex
 * since otherwise it appears far too late in the generated C
 */

/*
#ifdef HAVE_CONFIG_H
#include <rasqal_config.h>
#endif

#ifdef WIN32
#include <win32_rasqal_config.h>
#endif
*/

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#ifdef HAVE_SETJMP_H
#include <setjmp.h>
#endif

#include <rasqal.h>
#include <rasqal_internal.h>

#include <rdql_parser.h>

#include <rdql_common.h>



static int rdql_skip_c_comment(rasqal_query *rq);

static unsigned char* rdql_copy_name(rasqal_query *rq, const unsigned char *text, size_t len);
static unsigned char* rdql_copy_qname(rasqal_query *rq, const unsigned char *text, size_t len);
static int rdql_copy_regex_token(rasqal_query *rq, YYSTYPE* lval, unsigned char delim);
static int rdql_copy_string_token(rasqal_query *rq, YYSTYPE* lval, const unsigned char *text, size_t len, int delim);

#ifdef RASQAL_DEBUG
const char * rdql_token_print(rasqal_world* world, int token, YYSTYPE *lval);
#endif

int rdql_lexer_lex (YYSTYPE *rdql_parser_lval, yyscan_t yyscanner);
#define YY_DECL int rdql_lexer_lex (YYSTYPE *rdql_parser_lval, yyscan_t yyscanner)

#ifdef __cplusplus
#define INPUT_FN yyinput
#else
#define INPUT_FN input
#endif

/* Remove the re-fill function since it should never be called */
#define YY_INPUT(buf,result,max_size) { return YY_NULL; }


/* Missing rdql_lexer.c/h prototypes */
int rdql_lexer_get_column(yyscan_t yyscanner);
void rdql_lexer_set_column(int  column_no , yyscan_t yyscanner);

static void rdql_lexer_cleanup(yyscan_t yyscanner);

#ifdef HAVE_SETJMP
static jmp_buf rdql_lexer_fatal_error_longjmp_env;

/* fatal error handler declaration */
#define YY_FATAL_ERROR(msg) do {		\
    rdql_lexer_fatal_error(msg, yyscanner);   \
    longjmp(rdql_lexer_fatal_error_longjmp_env, 1);        \
} while(0)
#else
#define YY_FATAL_ERROR(msg) do {		\
    rdql_lexer_fatal_error(msg, yyscanner);   \
    abort();                                    \
} while(0)
#endif
 
static void RASQAL_NORETURN rdql_lexer_fatal_error(yyconst char *msg, yyscan_t yyscanner);

/* See
 * http://www.w3.org/TR/xml11/#NT-NameStartChar and 
 * http://www.w3.org/TR/xml11/#NT-NameChar 
 */
/* The initial char conditions are to ensure this doesn't grab < or <= */
#line 890 "rdql_lexer.c"

#define INITIAL 0
#define PATTERN 1
#define ID 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#ifndef YY_NO_UNISTD_H
#include <unistd.h>
#endif
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    }; /* end struct yyguts_t */

static int yy_init_globals (yyscan_t yyscanner );

int rdql_lexer_lex_init (yyscan_t* scanner);

int rdql_lexer_lex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int rdql_lexer_lex_destroy (yyscan_t yyscanner );

int rdql_lexer_get_debug (yyscan_t yyscanner );

void rdql_lexer_set_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE rdql_lexer_get_extra (yyscan_t yyscanner );

void rdql_lexer_set_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *rdql_lexer_get_in (yyscan_t yyscanner );

void rdql_lexer_set_in  (FILE * in_str ,yyscan_t yyscanner );

FILE *rdql_lexer_get_out (yyscan_t yyscanner );

void rdql_lexer_set_out  (FILE * out_str ,yyscan_t yyscanner );

int rdql_lexer_get_leng (yyscan_t yyscanner );

char *rdql_lexer_get_text (yyscan_t yyscanner );

int rdql_lexer_get_lineno (yyscan_t yyscanner );

void rdql_lexer_set_lineno (int line_number ,yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int rdql_lexer_wrap (yyscan_t yyscanner );
#else
extern int rdql_lexer_wrap (yyscan_t yyscanner );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int rdql_lexer_lex (yyscan_t yyscanner);

#define YY_DECL int rdql_lexer_lex (yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

#line 166 "./rdql_lexer.l"

  /* rules */



  int c;
  rasqal_query *rq = (rasqal_query*)yyextra;
  rasqal_rdql_query_language *rqe = (rasqal_rdql_query_language*)rq->context;

#ifdef HAVE_SETJMP
  if(setjmp(rdql_lexer_fatal_error_longjmp_env))
    return 1;
#endif
  


#line 1135 "rdql_lexer.c"

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			rdql_lexer_ensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				rdql_lexer__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		rdql_lexer__load_buffer_state(yyscanner );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 208 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 207 );
		yy_cp = yyg->yy_last_accepting_cpos;
		yy_current_state = yyg->yy_last_accepting_state;

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 182 "./rdql_lexer.l"
{ /* C++ comment */
        rqe->lineno++;
}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 186 "./rdql_lexer.l"
{ int lines = rdql_skip_c_comment(rq);
          if(lines < 0)
            yyterminate();
          rqe->lineno += lines;
        }
	YY_BREAK
case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 192 "./rdql_lexer.l"
{ rqe->lineno++; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 194 "./rdql_lexer.l"
{ /* eat up other whitespace */
	;
}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 198 "./rdql_lexer.l"
{ return SELECT; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 199 "./rdql_lexer.l"
{ return SOURCE; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 200 "./rdql_lexer.l"
{ return FROM; } 
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 201 "./rdql_lexer.l"
{ return WHERE; } 
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 202 "./rdql_lexer.l"
{ return AND; } 
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 203 "./rdql_lexer.l"
{ return USING; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 204 "./rdql_lexer.l"
{ return FOR; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 206 "./rdql_lexer.l"
{ return ','; } 
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 207 "./rdql_lexer.l"
{ return '('; } 
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 208 "./rdql_lexer.l"
{ return ')'; } 
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 209 "./rdql_lexer.l"
{ BEGIN(ID); return '?'; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 211 "./rdql_lexer.l"
{ return SC_OR; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 212 "./rdql_lexer.l"
{ return SC_AND; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 214 "./rdql_lexer.l"
{ return STR_EQ; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 215 "./rdql_lexer.l"
{ return STR_NE; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 217 "./rdql_lexer.l"
{ BEGIN(PATTERN); return STR_MATCH; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 218 "./rdql_lexer.l"
{ BEGIN(PATTERN); return STR_NMATCH; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 220 "./rdql_lexer.l"
{
	;
}
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 224 "./rdql_lexer.l"
{ rqe->lineno++; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 227 "./rdql_lexer.l"
{ /* first non whitespace */
             if(!rdql_copy_regex_token(rq, rdql_parser_lval, *yytext)) {
               BEGIN(INITIAL);
               return PATTERN_LITERAL;
             }
             BEGIN(INITIAL);
	     yyterminate();
         };
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 237 "./rdql_lexer.l"
{ return EQ; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 238 "./rdql_lexer.l"
{ return NEQ; }
	YY_BREAK
case 27:
/* rule 27 can match eol */
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 239 "./rdql_lexer.l"
{ return LT; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 240 "./rdql_lexer.l"
{ return GT; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 241 "./rdql_lexer.l"
{ return LE; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 242 "./rdql_lexer.l"
{ return GE; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 244 "./rdql_lexer.l"
{ return '+'; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 245 "./rdql_lexer.l"
{ return '-'; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 246 "./rdql_lexer.l"
{ return '*'; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 247 "./rdql_lexer.l"
{ return '/'; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 248 "./rdql_lexer.l"
{ return '%'; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 249 "./rdql_lexer.l"
{ return '~'; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 250 "./rdql_lexer.l"
{ return '!'; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 252 "./rdql_lexer.l"
{ c = yytext[yyleng - 1];
                  if(c == 'l' || c == 'L')
                    yytext[yyleng - 1]='\0';
                  rdql_parser_lval->literal = rasqal_new_integer_literal(rq->world, RASQAL_LITERAL_INTEGER, atoi(yytext));
 		  return INTEGER_LITERAL; 
}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 259 "./rdql_lexer.l"
{ int i;
                      int n;

                      if(yytext[yyleng + 1] == 'x') 
                        n = sscanf(yytext + 2, "%x", &i);
                      else
                        n = sscanf(yytext + 2, "%X", &i);
                      if(n != 1) {
                        rdql_syntax_error(rq, "RDQL syntax error - Illegal hex constant %c%c%c",
                                          yytext[0], yytext[1], yytext[2]);
                        yyterminate();
                      }
                      rdql_parser_lval->literal = rasqal_new_integer_literal(rq->world, RASQAL_LITERAL_INTEGER, i);
                      return INTEGER_LITERAL; 
}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 275 "./rdql_lexer.l"
{ 
                        rdql_parser_lval->literal = rasqal_new_typed_literal(rq->world, RASQAL_LITERAL_DOUBLE, RASQAL_GOOD_CAST(const unsigned char*, yytext));
                        if(!rdql_parser_lval->literal)
                          yyterminate();
                        return FLOATING_POINT_LITERAL;
}
	YY_BREAK
case 41:
/* rule 41 can match eol */
YY_RULE_SETUP
#line 282 "./rdql_lexer.l"
{ /*' */
                        if(!rdql_copy_string_token(rq, rdql_parser_lval,
                          RASQAL_GOOD_CAST(const unsigned char*, yytext) + 1, yyleng - 1, '\''))
                          return STRING_LITERAL;
		        yyterminate();
}
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 289 "./rdql_lexer.l"
{ /* " */
                        if(!rdql_copy_string_token(rq, rdql_parser_lval,
                          RASQAL_GOOD_CAST(const unsigned char*, yytext) + 1, yyleng - 1, '"'))
                          return STRING_LITERAL; 
		        yyterminate();
}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 296 "./rdql_lexer.l"
{ rdql_parser_lval->literal = rasqal_new_boolean_literal(rq->world, *yytext == 't');
                  return BOOLEAN_LITERAL; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 299 "./rdql_lexer.l"
{ rdql_parser_lval->literal = NULL;
          return NULL_LITERAL; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 302 "./rdql_lexer.l"
{ rdql_parser_lval->name = rdql_copy_name(rq, RASQAL_GOOD_CAST(const unsigned char*, yytext), yyleng);
		  if(!rdql_parser_lval->name)
                    yyterminate();
                          BEGIN(INITIAL);
                          return IDENTIFIER; }
	YY_BREAK
case 46:
/* rule 46 can match eol */
YY_RULE_SETUP
#line 307 "./rdql_lexer.l"
{	BEGIN(INITIAL);
		rdql_syntax_error(rq, "RDQL syntax error - missing variable name after ?");
                yyterminate();
		}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 312 "./rdql_lexer.l"
{ rdql_parser_lval->name = rdql_copy_qname(rq, RASQAL_GOOD_CAST(const unsigned char*, yytext), yyleng);
	  if(!rdql_parser_lval->name)
            yyterminate();
                          return QNAME_LITERAL; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 317 "./rdql_lexer.l"
{ rdql_parser_lval->name = rdql_copy_qname(rq, RASQAL_GOOD_CAST(const unsigned char*, yytext) + 1, yyleng - 2);
		  if(!rdql_parser_lval->name)
	            yyterminate();
                  rdql_syntax_warning(rq, "Obsolete RDQL <qname> syntax found in \"%s\"", RASQAL_GOOD_CAST(const unsigned char*, yytext));
                  return QNAME_LITERAL; }
	YY_BREAK
case 49:
/* rule 49 can match eol */
YY_RULE_SETUP
#line 323 "./rdql_lexer.l"
{ if(yyleng == 2) 
                  rdql_parser_lval->uri = raptor_uri_copy(rq->base_uri);
                else {
                  yytext[yyleng - 1] = '\0';
                  rdql_parser_lval->uri = raptor_new_uri_relative_to_base(rq->world->raptor_world_ptr, rq->base_uri, RASQAL_GOOD_CAST(const unsigned char*, yytext) + 1);
                 }
                 return URI_LITERAL; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 331 "./rdql_lexer.l"
{ while((c = INPUT_FN(yyscanner)) != '\n' && c)
                    ;
                }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 335 "./rdql_lexer.l"
{ if(!*yytext)
                    return EOF;

                  rdql_syntax_error(rq, "RDQL syntax error at '%s'", yytext);
                  yyterminate();
		}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 342 "./rdql_lexer.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 1565 "rdql_lexer.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(PATTERN):
case YY_STATE_EOF(ID):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * rdql_lexer_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_last_accepting_cpos;
				yy_current_state = yyg->yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( rdql_lexer_wrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of rdql_lexer_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = yyg->yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					rdql_lexer_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			rdql_lexer_restart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) rdql_lexer_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 208 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	register int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	register char *yy_cp = yyg->yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 208 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 207);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					rdql_lexer_restart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( rdql_lexer_wrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void rdql_lexer_restart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        rdql_lexer_ensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            rdql_lexer__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	rdql_lexer__init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	rdql_lexer__load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void rdql_lexer__switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		rdql_lexer_pop_buffer_state();
	 *		rdql_lexer_push_buffer_state(new_buffer);
     */
	rdql_lexer_ensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	rdql_lexer__load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (rdql_lexer_wrap()) processing, but the only time this flag
	 * is looked at is after rdql_lexer_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void rdql_lexer__load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE rdql_lexer__create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) rdql_lexer_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in rdql_lexer__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) rdql_lexer_alloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in rdql_lexer__create_buffer()" );

	b->yy_is_our_buffer = 1;

	rdql_lexer__init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with rdql_lexer__create_buffer()
 * @param yyscanner The scanner object.
 */
    void rdql_lexer__delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		rdql_lexer_free((void *) b->yy_ch_buf ,yyscanner );

	rdql_lexer_free((void *) b ,yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a rdql_lexer_restart() or at EOF.
 */
    static void rdql_lexer__init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	rdql_lexer__flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then rdql_lexer__init_buffer was _probably_
     * called from rdql_lexer_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void rdql_lexer__flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		rdql_lexer__load_buffer_state(yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void rdql_lexer_push_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	rdql_lexer_ensure_buffer_stack(yyscanner);

	/* This block is copied from rdql_lexer__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from rdql_lexer__switch_to_buffer. */
	rdql_lexer__load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void rdql_lexer_pop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	rdql_lexer__delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		rdql_lexer__load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void rdql_lexer_ensure_buffer_stack (yyscan_t yyscanner)
{
	int num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)rdql_lexer_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in rdql_lexer_ensure_buffer_stack()" );
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)rdql_lexer_realloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in rdql_lexer_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE rdql_lexer__scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) rdql_lexer_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in rdql_lexer__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	rdql_lexer__switch_to_buffer(b ,yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to rdql_lexer_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       rdql_lexer__scan_bytes() instead.
 */
YY_BUFFER_STATE rdql_lexer__scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return rdql_lexer__scan_bytes(yystr,strlen(yystr) ,yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to rdql_lexer_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE rdql_lexer__scan_bytes  (yyconst char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) rdql_lexer_alloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in rdql_lexer__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = rdql_lexer__scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in rdql_lexer__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif


/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE rdql_lexer_get_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int rdql_lexer_get_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int rdql_lexer_get_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *rdql_lexer_get_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *rdql_lexer_get_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int rdql_lexer_get_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *rdql_lexer_get_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void rdql_lexer_set_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void rdql_lexer_set_lineno (int  line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR("rdql_lexer_set_lineno called with no buffer"); 
    
    yylineno = line_number;
}

/** Set the current column.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void rdql_lexer_set_column (int  column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR("rdql_lexer_set_column called with no buffer"); 
    
    yycolumn = column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see rdql_lexer__switch_to_buffer
 */
void rdql_lexer_set_in (FILE *  in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = in_str ;
}

void rdql_lexer_set_out (FILE *  out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = out_str ;
}

int rdql_lexer_get_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void rdql_lexer_set_debug (int  bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = bdebug ;
}

/* Accessor methods for yylval and yylloc */

/* User-visible API */

/* rdql_lexer_lex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int rdql_lexer_lex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) rdql_lexer_alloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* rdql_lexer_lex_init_extra has the same functionality as rdql_lexer_lex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to rdql_lexer_alloc in
 * the yyextra field.
 */

int rdql_lexer_lex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    rdql_lexer_set_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) rdql_lexer_alloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    rdql_lexer_set_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from rdql_lexer_lex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * rdql_lexer_lex_init()
     */
    return 0;
}

/* rdql_lexer_lex_destroy is for both reentrant and non-reentrant scanners. */
int rdql_lexer_lex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		rdql_lexer__delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		rdql_lexer_pop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	rdql_lexer_free(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        rdql_lexer_free(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * rdql_lexer_lex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    /* clean up leaks if any before freeing yyscanner */
    rdql_lexer_cleanup(yyscanner);
    rdql_lexer_free ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 342 "./rdql_lexer.l"


  /* user code */

int
rdql_lexer_wrap (yyscan_t yyscanner) {
  return 1;
}


static unsigned char *
rdql_copy_name(rasqal_query *rq, const unsigned char *text, size_t len) {
  size_t dest_len = 0;
  unsigned char *s;

  s = rasqal_escaped_name_to_utf8_string(RASQAL_GOOD_CAST(unsigned char*, text),
                                         len, &dest_len, rdql_syntax_error, rq);
  if(!s)
    return s;

  if(!raptor_xml_name_check(s, dest_len, 11))
    rdql_syntax_warning(rq, "Invalid RDQL name \"%s\"", s);

  return s;
}


static unsigned char *
rdql_copy_qname(rasqal_query *rq, const unsigned char *text, size_t len) {
  unsigned char *p;
  size_t dest_len = 0;
  unsigned char *s;
  
  s = rasqal_escaped_name_to_utf8_string(RASQAL_GOOD_CAST(unsigned char*, text),
                                         len, &dest_len, rdql_syntax_error, rq);
  if(!s)
    return s;

  p = RASQAL_GOOD_CAST(unsigned char*, strchr(RASQAL_GOOD_CAST(const char*, s), ':'));
  if(!raptor_xml_name_check(s, p-s, 11))
    rdql_syntax_warning(rq, "Invalid RDQL name \"%s\"", s);
  if(!raptor_xml_name_check(p + 1, dest_len-((p + 1)-s), 11))
    rdql_syntax_warning(rq, "Invalid RDQL name \"%s\"", p + 1);

  return s;
}


static int
rdql_copy_regex_token(rasqal_query* rq, YYSTYPE* lval, unsigned char delim)
{
  rasqal_rdql_query_language *rqe;
  yyscan_t yyscanner;
  unsigned int ind = 0;
  size_t buffer_len = 0;
  unsigned char *buffer = NULL;
  size_t flags_len = 0;
  unsigned char *flags = NULL;
  int c;

  rqe = (rasqal_rdql_query_language*)rq->context;
  yyscanner = rqe->scanner;

  if(delim == 'm') {
    /* Handle pattern literal m/foo/ */
    c = INPUT_FN(yyscanner);
    if(c == EOF) {
      rdql_syntax_error(rq, "RDQL syntax error - EOF in regex");
      return 1;
    }
    delim = (unsigned char)c;
  }

  while((c = INPUT_FN(yyscanner)) && c != EOF && c != delim) {
    /* May add 2 chars - \' */
    if(ind + 2 > buffer_len) {
      unsigned char *new_buffer;
      size_t new_buffer_len = buffer_len <<1;

      if(new_buffer_len < 10)
        new_buffer_len = 10;
      new_buffer = RASQAL_CALLOC(unsigned char*, 1, new_buffer_len + 1);
      if(buffer_len) {
        memcpy(new_buffer, buffer, buffer_len);
        RASQAL_FREE(char*, buffer);
      }
      buffer=new_buffer;
      buffer_len = new_buffer_len;
    }
    buffer[ind++] = c;
    if(c == '\\') {
      c = INPUT_FN(yyscanner);
      buffer[ind++] = c;
    }
  }

  if(!buffer) {
    buffer_len = 0;
    buffer = RASQAL_CALLOC(unsigned char*, 1, buffer_len + 1);
  }
  buffer[ind] = '\0';

  if(c == EOF) {
    rdql_syntax_error(rq, "RDQL syntax error - EOF in regex");
    return 1;
  }

  /* flags */
  ind = 0;
  while((c = INPUT_FN(yyscanner)) && c != EOF && isalpha(c)) {
    if(ind + 1 > flags_len) {
      unsigned char *new_flags;
      size_t new_flags_len = flags_len + 5;

      if(new_flags_len<5)
        new_flags_len = 5;
      new_flags = RASQAL_CALLOC(unsigned char*, 1, new_flags_len + 1);
      if(flags_len) {
        memcpy(new_flags, flags, flags_len);
        RASQAL_FREE(char*, flags);
      }
      flags = new_flags;
      flags_len = new_flags_len;
    }
    flags[ind++] = c;
  }
  if(flags)
    flags[ind] = '\0';

  lval->literal = rasqal_new_pattern_literal(rq->world, buffer,
                                             RASQAL_GOOD_CAST(const char*, flags));
  return 0;
}


static int
rdql_copy_string_token(rasqal_query* rq, YYSTYPE* lval,
                       const unsigned char *text, size_t len, int delim)
{
  unsigned int i;
  const unsigned char *s;
  unsigned char *d;
  unsigned char *string;
  char *language = NULL;
  unsigned char *dt = NULL;
  raptor_uri *dt_uri = NULL;
  unsigned char *dt_qname = NULL;

  string = RASQAL_MALLOC(unsigned char*, len + 1);

  for(s = text, d = string, i = 0; i < len; s++, i++) {
    unsigned char c = *s;

    if(c == '\\' ) {
      s++; i++;
      c = *s;
      if(c == 'n')
        *d++ = '\n';
      else if(c == 'r')
        *d++ = '\r';
      else if(c == 't')
        *d++ = '\t';
      else if(c == '\\' || c == delim)
        *d++ = c;
      else if(c == 'u' || c == 'U') {
        int ulen = (c == 'u') ? 4 : 8;
        unsigned long unichar = 0;
        int n;
        
        s++; i++;
        if(i + ulen > len) {
          printf("\\%c over end of line", c);
          RASQAL_FREE(char*, string);
          return 1;
        }
        
        n = sscanf(RASQAL_GOOD_CAST(const char*, s), ((ulen == 4) ? "%04lx" : "%08lx"), &unichar);
        if(n != 1) {
          rdql_syntax_error(rq, "RDQL syntax error - Illegal Unicode escape '%c%s...'", c, s);
          RASQAL_FREE(char*, string);
          return 1;
        }

        s += ulen - 1;
        i += ulen - 1;
        
        if(unichar > 0x10ffff) {
          rdql_syntax_error(rq, "RDQL syntax error - Illegal Unicode character with code point #x%lX.", unichar);
          RASQAL_FREE(char*, string);
          return 1;
        }
          
        d += raptor_unicode_utf8_string_put_char(unichar, d, len-(d-string));
      } else {
        /* Ignore \x where x isn't the one of: \n \r \t \\ (delim) \u \U */
        rdql_syntax_warning(rq, "Unknown RDQL string escape \\%c in \"%s\"",
                            c, text);
        *d++ = c;
      }
    } else if(c == delim) {
      *d++ = '\0';

      /* skip delim */
      s++; i++;

      c = *s++; i++;
      if(c == '@') {
        language = RASQAL_GOOD_CAST(char*, d);
        while(i <= len) {
          c = *s++; i++;
          if(!isalpha(c) && !isdigit(c) && c != '-')
            break;
          *d++ = c;
        }
        *d++ = '\0';
      }
      if(c == '^') {
        /* skip second char of ^^ */
        s++; i++;

        dt = d;
        while(i++ <= len)
          *d++ = *s++;
        /* *d = '\0' below */
      } else if(language)
        *d = '\0';
      
      break;
   } else
    *d++ = c;
  } /* end of for */

  *d = '\0';

  if(language) {
    char *new_language;
    size_t new_language_len = strlen(RASQAL_GOOD_CAST(const char*, language));
    new_language = RASQAL_MALLOC(char*, new_language_len + 1);
    memcpy(new_language, language, new_language_len + 1);
    language = new_language;
  }
  
  if(dt) {
    /* dt can be a URI or qname */
    if(*dt == '<') {
      dt[strlen(RASQAL_GOOD_CAST(const char*, dt)) - 1] = '\0';
      dt_uri = raptor_new_uri(rq->world->raptor_world_ptr, dt + 1);
    } else {
      size_t dt_qname_len = strlen(RASQAL_GOOD_CAST(const char*, dt));
      
      if(!raptor_xml_name_check(dt, dt_qname_len, 11))
        rdql_syntax_warning(rq, "Invalid RDQL name \"%s\"", dt);
      
      /* the qname is expanded later */
      dt_qname = RASQAL_MALLOC(unsigned char*, dt_qname_len + 1);
      memcpy(dt_qname, dt, dt_qname_len + 1);
    }
  }

#if RASQAL_DEBUG >3
  fprintf(stderr, "string = '%s', language = '%s'\n", 
          string, (language ? language : ""));
  fprintf(stderr, "dt uri = '%s',qname = '%s'\n",
          (dt_uri ? RASQAL_GOOD_CAST(const char*, raptor_uri_as_string(dt_uri)) : ""),
          (dt_qname ? RASQAL_GOOD_CAST(const char*, dt_qname) : ""));
#endif

  lval->literal = rasqal_new_string_literal(rq->world, string, language,
                                            dt_uri, dt_qname);

  return 0;
}


static int
rdql_skip_c_comment(rasqal_query *rq) 
{
  rasqal_rdql_query_language *rqe;
  yyscan_t yyscanner;
  int lines = 0;
  int c;
  
  rqe = (rasqal_rdql_query_language*)rq->context;
  yyscanner=rqe->scanner;

  while(1) {
    while ((c = INPUT_FN(yyscanner)) != '*' && c!= EOF) {
      if(c == '\r' || c == '\n')
        lines++;
    }
    if( c == '*') {
      while ((c = INPUT_FN(yyscanner)) == '*') {
        if(c == '\r' || c == '\n')
          lines++;
      }

      if(c == '/')
        break;
    }
    if(c == EOF) {
      rdql_syntax_error(rq, "RDQL syntax error - EOF in comment");
      lines = -1;
      break;
    }
  }
  return lines;
}


/*
 * rdql_lexer_fatal_error:
 *
 * INTERNAL - replacement for the generated error handler.
 * Uses rasqal_query_fatal_error() when possible.
 */
static void RASQAL_NORETURN
rdql_lexer_fatal_error(yyconst char *msg, yyscan_t yyscanner)
{
  rasqal_query *rq = NULL;

  if(yyscanner)
    rq=(rasqal_query *)rdql_lexer_get_extra(yyscanner);

  if(rq) {
    /* avoid "format not a string literal and no format arguments" warning with %s */
    rq->failed=1;
    rasqal_log_error_simple(rq->world, RAPTOR_LOG_LEVEL_FATAL,
                            &rq->locator, "%s", msg); 
  } else
    (void)fprintf(stderr, "%s\n", msg);

  abort();
}


/* Define LEXER_ALLOC_TRACKING to enable allocated memory tracking
 * - fixes lexer memory leak when ensure_buffer_stack fails
 */

#ifdef LEXER_ALLOC_TRACKING
typedef struct {
  /* Number of void* slots allocated */
  int lexer_allocs_size;
  /* Allocted void* slots follow in memory after this header */
} lexer_alloc_tracker_header;

/* Initial alloc tracker slot array size - 2 seems to be enough for almost all cases */
static const int initial_lexer_allocs_size=2;
#endif


/*
 * rdql_lexer_cleanup:
 * @yyscanner:
 *
 * INTERNAL - Clean up unfreed lexer allocs if LEXER_ALLOC_TRACKING is enabled.
 */
static void rdql_lexer_cleanup(yyscan_t yyscanner)
{
#ifdef LEXER_ALLOC_TRACKING
  rasqal_query *rq;
  lexer_alloc_tracker_header *tracker;
  void **lexer_allocs;
  int i;

  if(!yyscanner)
    return;

  rq = (rasqal_query *)rdql_lexer_get_extra(yyscanner);
  if(!rq)
    return;

  tracker = (lexer_alloc_tracker_header *)rq->lexer_user_data;
  if(!tracker)
    return;
  lexer_allocs = (void**)&tracker[1];

  for(i = 0; i < tracker->lexer_allocs_size; ++i) {
    if(lexer_allocs[i])
      free(lexer_allocs[i]);
    lexer_allocs[i] = NULL;
  }
  free(rq->lexer_user_data);
  rq->lexer_user_data = NULL;
#endif
}


/*
 * rdql_lexer_alloc:
 * @size
 * @yyscanner
 *
 * INTERNAL - alloc replacement.
 * Tracks allocated cells if LEXER_ALLOC_TRACKING is enabled.
 */
void *rdql_lexer_alloc(yy_size_t size, yyscan_t yyscanner)
{
#ifdef LEXER_ALLOC_TRACKING
  rasqal_query *rq;
  lexer_alloc_tracker_header *tracker;
  void **lexer_allocs;
  int i;
  void *ptr;

  /* yyscanner not initialized -> probably initializing yyscanner itself
   * -> just malloc without tracking
   */
  if(!yyscanner)
    return malloc(size);

  rq = (rasqal_query *)rdql_lexer_get_extra(yyscanner);
  if(!rq)
    YY_FATAL_ERROR("lexer_alloc: yyscanner extra not initialized");

  /* try to allocate tracker if it does not exist */
  tracker = (lexer_alloc_tracker_header *)rq->lexer_user_data;
  if(!tracker) {
    /* allocate tracker header + array of void* slots */
    tracker = (lexer_alloc_tracker_header*)calloc(1, sizeof(lexer_alloc_tracker_header)+initial_lexer_allocs_size * sizeof(void*));
    if(!tracker)
      YY_FATAL_ERROR("lexer_alloc: cannot allocate tracker");
    tracker->lexer_allocs_size = initial_lexer_allocs_size;
    rq->lexer_user_data = (void *)tracker;
  }
  lexer_allocs = (void**)&tracker[1];

  /* allocate memory */
  ptr = malloc(size);
  
  /* find a free slot for ptr */
  for(i = 0; i < tracker->lexer_allocs_size; ++i) {
    if(!lexer_allocs[i]) {
      lexer_allocs[i] = ptr;
      break;
    }
  }

  /* no free slots -> grow tracker slot array */
  if(i >= tracker->lexer_allocs_size) {
    int j;
    void **dest;

    tracker = (lexer_alloc_tracker_header*)calloc(1, sizeof(lexer_alloc_tracker_header) + i * 2 * sizeof(void*));
    if(!tracker) {
      if(ptr)
        free(ptr);
      YY_FATAL_ERROR("lexer_alloc: cannot grow tracker");
    }
    tracker->lexer_allocs_size = i*2;
    
    /* copy data from old tracker */
    dest = (void**)&tracker[1];
    for(j = 0; j < i; ++j) {
      dest[j] = lexer_allocs[j];
    }
    
    /* set new item to first free slot */
    dest[j] = ptr;

    /* free old tracker and replace with new one */
    free(rq->lexer_user_data);
    rq->lexer_user_data = tracker;
  }

  return ptr;
#else
  return malloc(size);
#endif
}


/*
 * rdql_lexer_realloc:
 *
 * INTERNAL - realloc replacement
 * Tracks allocated cells if LEXER_ALLOC_TRACKING is enabled.
 */
void *rdql_lexer_realloc(void *ptr, yy_size_t size, yyscan_t yyscanner)
{
#ifdef LEXER_ALLOC_TRACKING
  rasqal_query *rq;
  lexer_alloc_tracker_header *tracker;
  void **lexer_allocs;
  int i;
  void *newptr;

  if(!yyscanner)
    YY_FATAL_ERROR("lexer_realloc: yyscanner not initialized");

  rq = (rasqal_query *)rdql_lexer_get_extra(yyscanner);
  if(!rq)
    YY_FATAL_ERROR("lexer_realloc: yyscanner extra not initialized");

  tracker = (lexer_alloc_tracker_header *)rq->lexer_user_data;
  if(!tracker)
    YY_FATAL_ERROR("lexer_realloc: no alloc tracker");
  lexer_allocs = (void**)&tracker[1];

  /* find the old slot for ptr */
  for(i = 0; i < tracker->lexer_allocs_size; ++i) {
    if(lexer_allocs[i] == ptr)
      break;
  }

  /* no old slot -> error */  
  if(i >= tracker->lexer_allocs_size)
    YY_FATAL_ERROR("lexer_realloc: cell not in tracker");

  /* realloc */
  newptr = realloc(RASQAL_GOOD_CAST(char*, ptr), size);

  /* replace entry in tracker */
  lexer_allocs[i] = newptr;

  return newptr;
#else
  return realloc(RASQAL_GOOD_CAST(char*, ptr), size);
#endif
}


/*
 * rdql_lexer_free:
 *
 * INTERNAL - free replacement.
 * Checks for NULL pointer to be freed unlike the default lexer free function.
 * Tracks allocated cells if LEXER_ALLOC_TRACKING is enabled.
 */
void rdql_lexer_free(void *ptr, yyscan_t yyscanner)
{
#ifdef LEXER_ALLOC_TRACKING
  rasqal_query *rq;
  lexer_alloc_tracker_header *tracker;
  void **lexer_allocs;
  int i;

  /* do not free NULL */
  if(!ptr)
    return;

  /* free ptr even if we would encounter an error */
  free(ptr);

  /* yyscanner is allocated with rdql_lexer_alloc() but it's never stored in the tracker
   * - we need yyscanner to access the tracker */
  if(!yyscanner || ptr == yyscanner)
    return;

  rq = (rasqal_query *)rdql_lexer_get_extra(yyscanner);
  if(!rq)
    return;

  tracker = (lexer_alloc_tracker_header *)rq->lexer_user_data;
  if(!tracker)
    return;
  lexer_allocs = (void**)&tracker[1];

  /* find the slot for ptr */
  for(i = 0; i < tracker->lexer_allocs_size; ++i) {
    if(lexer_allocs[i] == ptr)
      break;
  }

  /* no slot -> error */  
  if(i >= tracker->lexer_allocs_size)
    YY_FATAL_ERROR("lexer_free: cell not in tracker");

  /* remove entry from tracker */
  lexer_allocs[i] = NULL;
#else
  if(ptr)
    free(ptr);
#endif
}


#ifdef RASQAL_DEBUG

const char *
rdql_token_print(rasqal_world* world, int token, YYSTYPE *lval)
{
  static char buffer[2048];

  if(!token)
    return "<<EOF>>";
  
  switch(token) {
    case SELECT:
      return "SELECT";

    case SOURCE:
      return "SOURCE";

    case FROM:
      return "FROM";

    case WHERE:
      return "WHERE";

    case AND:
      return "AND";

    case FOR:
      return "FOR";

    case ',':
      return ",";

    case '(':
      return "(";

    case ')':
      return "(";

    case '?':
      return "?";

    case USING:
      return "USING";

    case SC_AND:
      return "SC_AND";

    case SC_OR:
      return "SC_OR";

    case STR_NMATCH:
      return "STR_NMATCH";

    case STR_MATCH:
      return "STR_MATCH";

    case STR_NE:
      return "STR_NE";

    case STR_EQ:
      return "STR_EQ";

    case GE:
      return "GE";

    case LE:
      return "LE";

    case GT:
      return "GT";

    case LT:
      return "LT";

    case NEQ:
      return "NEQ";

    case EQ:
      return "EQ";

    case '%':
      return "%";

    case '/':
      return "/";

    case '*':
      return "*";

    case '-':
      return "-";

    case '+':
      return "+";

    case '!':
      return "!";

    case '~':
      return "~";

    case INTEGER_LITERAL:
      sprintf(buffer, "INTEGER_LITERAL(%d)", lval->literal->value.integer);
      return buffer;

    case FLOATING_POINT_LITERAL:
      sprintf(buffer, "FLOATING_POINT_LITERAL(%g)", lval->floating);
      return buffer;

    case STRING_LITERAL:
      if(lval->literal->language) {
        if(lval->literal->datatype)
          sprintf(buffer, "STRING_LITERAL(\"%s\"@%s^^%s)",
                  lval->literal->string, lval->literal->language,
                  raptor_uri_as_string(lval->literal->datatype));
        else
          sprintf(buffer, "STRING_LITERAL(\"%s\"@%s)",
                  lval->literal->string, lval->literal->language);
      } else {
        if(lval->literal->datatype)
          sprintf(buffer, "STRING_LITERAL(\"%s\"^^%s)", 
                  lval->literal->string,
                  raptor_uri_as_string(lval->literal->datatype));
        else
          sprintf(buffer, "STRING_LITERAL(\"%s\")", lval->literal->string);
      }
      return buffer;

    case PATTERN_LITERAL:
      sprintf(buffer, "PATTERN_LITERAL(%s,%s)", lval->literal->string,
              (lval->literal->flags ? RASQAL_GOOD_CAST(char*, lval->literal->flags) : "-"));
      return buffer;

    case BOOLEAN_LITERAL:
      return (lval->literal->value.integer ? "BOOLEAN_LITERAL(true)" : "BOOLEAN_LITERAL(false)");

    case NULL_LITERAL:
      return "NULL_LITERAL";

    case URI_LITERAL:
      sprintf(buffer, "URI_LITERAL(%s)", raptor_uri_as_string(lval->uri));
      return buffer;

    case QNAME_LITERAL:
      sprintf(buffer, "QNAME_LITERAL(%s)", lval->name);
      return buffer;

    case IDENTIFIER:
      sprintf(buffer, "IDENTIFIER(%s)", lval->name);
      return buffer;

   default:
     RASQAL_DEBUG2("UNKNOWN token %d - add a new case\n", token);
     abort();
  }
}
#endif



#ifdef STANDALONE
static void
rdql_token_free(rasqal_world* world, int token, YYSTYPE *lval)
{
  if(!token)
    return;
  
  switch(token) {
    case STRING_LITERAL:
    case PATTERN_LITERAL:
      rasqal_free_literal(lval->literal);
      break;
    case URI_LITERAL:
      raptor_free_uri(lval->uri);
      break;
    case IDENTIFIER:
      RASQAL_FREE(char*, lval->name);
      break;
    case QNAME_LITERAL:
      if(lval->name)
        RASQAL_FREE(char*, lval->name);
      break;
    default:
      break;
  }
}


#define FILE_READ_BUF_SIZE 2048

int
main(int argc, char *argv[]) 
{
  const char *program = rasqal_basename(argv[0]);
  char *query_string = NULL;
  rasqal_query rq;
  rasqal_rdql_query_language rdql;
  yyscan_t scanner;
  int token = EOF;
  YYSTYPE lval;
  const unsigned char *uri_string;
  const char *filename = NULL;
  char *buf = NULL;
  size_t len;
  rasqal_world *world;
  FILE *fh;

  world = rasqal_new_world();
  if(!world || rasqal_world_open(world))
    exit(1);

  filename = getenv("RDQL_QUERY_FILE");
  if(!filename) {
    if(argc != 2) {
      fprintf(stderr, "%s: Too many arguments.\n", program);
      fprintf(stderr, "RDQL lexer test for Rasqal %s\n", 
              rasqal_version_string);
      fprintf(stderr, "USAGE: %s RDQL-QUERY-FILE\n", program);
      exit(1);
    }
    
    filename = argv[1];
  }
  
  query_string = RASQAL_CALLOC(char*, FILE_READ_BUF_SIZE, 1);
  fh = fopen(filename, "r");
  if(fh) {
    fread(query_string, FILE_READ_BUF_SIZE, 1, fh);
    fclose(fh);
  } else {
    fprintf(stderr, "%s: Cannot open file %s - %s\n", program, filename,
            strerror(errno));
    exit(1);
  }

  memset(&rq, 0, sizeof(rq));
  rq.world = world;
  memset(&rdql, 0, sizeof(rdql));

  rdql_lexer_lex_init(&rdql.scanner);
  scanner = rdql.scanner;

#if 0
  /* set
   *   %option debug 
   * above first before enabling this
   */
  rdql_lexer_set_debug(1, scanner);
#endif
  
  len = strlen(RASQAL_GOOD_CAST(const char*, query_string));
  buf = RASQAL_MALLOC(char*, len + 3);
  memcpy(buf, query_string, len);
  buf[len] = ' ';
  buf[len + 1] = buf[len + 2] = '\0'; /* YY_END_OF_BUFFER_CHAR; */
  (void)rdql_lexer__scan_buffer(buf, len + 3, scanner);

  rdql_lexer_set_extra(&rq, scanner);

  /* Initialise enough of the rasqal_query and locator to get error messages */
  rq.context = &rdql;
  rdql.lineno = 1;
  rq.locator.file = filename;
  rq.locator.column = -1;

  uri_string = raptor_uri_filename_to_uri_string(filename);
  rq.base_uri = raptor_new_uri(world->raptor_world_ptr, uri_string);
  raptor_free_memory((void*)uri_string);

  while(1) {
    memset(&lval, 0, sizeof(lval));
    if(rdql_lexer_get_text(scanner) != NULL)
      printf("yyinput '%s'\n", rdql_lexer_get_text(scanner));
    token = rdql_lexer_lex(&lval,scanner);
#ifdef RASQAL_DEBUG
    printf("token %s\n", rdql_token_print(world, token, &lval));
#else
    printf("token %d\n", token);
#endif
    rdql_token_free(world, token, &lval);
    if(!token || token == EOF)
      break;
  }

  if(buf)
    RASQAL_FREE(char*, buf);
  
  rdql_lexer_lex_destroy(scanner);

  raptor_free_uri(rq.base_uri);

  RASQAL_FREE(char*, query_string);

  rasqal_free_world(world);

  if(rq.failed)
    return 1;
 
  return 0;
}
#endif

