/*
   Copyright 2009 Last.fm Ltd. 
      - Primarily authored by Max Howell, Jono Cole and Doug Mansell

   This file is part of liblastfm.

   liblastfm is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   liblastfm is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with liblastfm.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Album.h"
#include "Artist.h"
#include "User.h"
#include "../core/UrlBuilder.h"
#include "../core/XmlQuery.h"
#include "../ws/ws.h"
#include <QFile>
#include <QStringList>
#include <QTimer>


QNetworkReply*
lastfm::Album::getInfo() const
{
    QMap<QString, QString> map;
    map["method"] = "album.getInfo";
    map["artist"] = m_artist;
    map["album"] = m_title;
    return lastfm::ws::get(map);
}


QNetworkReply*
lastfm::Album::getTags() const
{
    QMap<QString, QString> map;
    map["method"] = "album.getTags";
    map["artist"] = m_artist;
    map["album"] = m_title;
    return lastfm::ws::get(map);
}


QNetworkReply*
lastfm::Album::share( const User& recipient, const QString& message )
{
    QMap<QString, QString> map;
    map["method"] = "album.share";
    map["artist"] = m_artist;
    map["album"] = m_title;
    map["recipient"] = recipient;
    if (message.size()) map["message"] = message;
    return lastfm::ws::post(map);
}


QUrl
lastfm::Album::www() const
{
    return lastfm::UrlBuilder( "music" ).slash( m_artist ).slash( m_title ).url();
}


QNetworkReply*
lastfm::Album::addTags( const QStringList& tags ) const
{
    if (tags.isEmpty())
        return 0;

    QMap<QString, QString> map;
    map["method"] = "album.addTags";
    map["artist"] = m_artist;
    map["album"] = m_title;
    map["tags"] = tags.join( QChar(',') );
    return lastfm::ws::post(map);
}
