/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.repository.explore;

import info.aduna.text.ToStringComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openrdf.model.Resource;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExploreRepositoryController
implements Controller {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String view;

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView result = new ModelAndView();
        result.setViewName(this.view);
        HashMap<String, List<Resource>> model = new HashMap<String, List<Resource>>();
        try {
            List<Resource> classes = this.getClasses(request);
            Collections.sort(classes, ToStringComparator.getInstance());
            model.put("classes", classes);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
        catch (MalformedQueryException e) {
            e.printStackTrace();
        }
        result.addAllObjects(model);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Resource> getClasses(HttpServletRequest request) throws RepositoryException, QueryEvaluationException, MalformedQueryException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        HttpSession session = request.getSession();
        HTTPRepository repo = (HTTPRepository)session.getAttribute("openrdf-repository");
        RepositoryConnection conn = null;
        try {
            conn = repo.getConnection();
            String query = "SELECT DISTINCT C FROM {} rdf:type {C}";
            TupleQueryResult classes = conn.prepareTupleQuery(QueryLanguage.SERQL, query).evaluate();
            try {
                while (classes.hasNext()) {
                    BindingSet bindingSet = (BindingSet)classes.next();
                    Resource resource = (Resource)bindingSet.getValue("C");
                    result.add(resource);
                }
            }
            finally {
                classes.close();
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (RepositoryException e) {
                    this.logger.error("Unable to close connection", (Throwable)e);
                }
            }
        }
        return result;
    }
}

