/* THIS FILE WAS AUTOMATICALLY GENERATED BY SCAN_STRINGS */
/************************* DO NOT EDIT *******************/
#ifndef _TextField_h
#define _TextField_h

/*
 *  $Id: TextField.h,v 1.1.1.1.4.1 2000/02/23 16:21:52 till Exp $
 *
 *  The TextField Widget
 *  --------------------
 
 *  Copyright (C) 1997  by Till Straumann   <strauman@sun6hft.ee.tu-berlin.de>

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Library Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Library Public License for more details.

 *  You should have received a copy of the GNU General Library Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Log: TextField.h,v $
 *  Revision 1.1.1.1.4.1  2000/02/23 16:21:52  till
 *   - merged albert graef's changes from p3 to p4
 *
 *  Revision 1.11  1999/10/28 18:06:49  cvs
 *   - added userData resource #ifndef XAW3D
 *   - fixed setValues: any change of `sensitive' needs an expose event.
 *
 *  Revision 1.10  1999/10/22 23:35:13  cvs
 *   - fixed typo
 *
 *  Revision 1.9  1999/10/22 23:32:42  cvs
 *   - added the showNChars resource.
 *
 *  Revision 1.8  1999/10/21 15:28:16  cvs
 *   - added support for a label to TextField.
 *
 *  Revision 1.7  1999/10/18 03:51:46  cvs
 *   - fixed TextField bug: when restoring to a string_in_place buffer,
 *     XtVaSetValues(tfw,XtNstring..) must be called with the buffer pointer
 *     (and not the backup).
 *   - fixed/updated doc in TextField.h
 *   - FocusForm paranoia: SetValues checks for being FocusForm subclass.
 *
 *  Revision 1.12  1999/10/16 02:15:50  cvs
 *   - added userData resource to SimpleAccMenu
 *
 *  Revision 1.6  1999/10/05 03:49:20  cvs
 *   - if use_string_in_place, setValues cannot know whether the string has
 *     changed.
 *     For now, it searches the arglist for XtNstring as a criteria
 *
 *  Revision 1.5  1999/02/05 17:41:53  till
 *   - added modifiedCallback reason (callData parameter).
 *
 *  Revision 1.4  1999/02/05 12:54:04  till
 *   - TextFieldValue2String() / TextFieldString2Value() take a Widget typed
 *     argument again (TextFieldWidget makes no sense in the outside world).
 *
 *  Revision 1.3  1999/02/05 12:37:04  till
 *   - cplusplus / function prototypes support
 *   - added blinker, autoBlink, Commit (to includes also)
 *   - added Backup / Restore (to includes also)
 *   - updated the doc (in TextField.h)
 *   - minor changes to scan_strings.l
 *
 *  Revision 1.2  1998/04/19 11:00:25  till
 *  started cvs logging
 *

 */

/****************************************************************
 *
 * TextField widget
 *
 ****************************************************************/

#ifdef  XAW3D
#include <X11/Xaw3d/ThreeD.h>
#else
#include <X11/Xaw/Simple.h>
#endif

#ifdef TEXT_COMPAT /* compatibility with the Xaw text widget */
#include <X11/Xaw/Text.h> /* we need XawTextPosition and XawTextResizeMode */
#endif

/*
 Resources:

 Name		     	Class			RepType		Default Value		Comment
 ----		     	-----			-------		-------------		-------
 font		     	Font            Font		XtDefaultFont
 foreground	     	Foreground		Pixel		XtDefaultForeground
 insensitiveForeground	InsensitiveForeground	Pixel			XtDefaultForeground
																fg when there can't be
 																typed into the widget.

 internalHeight		Height			Dimension	2				Space around the widget.
 internalWidth		Width			Dimension	2				There's additional space
																reserved for the scroll
																marks.

 insertPosition		TextPosition	TfTextPosition	0			Pos. of the text cursor.
																TfTextPosition type maps to
																XawTextPosition in TEXT_COMPAT
																mode.

 displayCaret		Output			Boolean		True			Whether to display the text cursor.

**** if in TEXT_COMPAT
 resize				Resize			ResizeMode	XawtextResizeNever	Whether widget tries to resize itself.
																Note that the resizing behavior depends
																on the `showNChars' resource also.
**** else
 resize				Resize			Boolean		False			Whether widget tries to resize itself.
																Note that the resizing behavior depends
																on the `showNChars' resource also.
**** else
**** endif


 string				Label			String		""				The editable string.
 showNChars			ShowNChars		Int			0				If > 0, at initialize time, the widget calculates
																its size order to show `showNChars'
																characters using the current font (this is
																approximate, if using a proportional font).
																This resource also affects the resizing policy
																if the `resize' resource is set True:
																 - If (`resize' && showNChars > 0) the widget
																   tries to resize itself to the size of
																   showNChars*charsize_of_font (+ label
																   width, internal width etc.).
																 - If (`resize' && showNChars == 0 ) the
																   editable area is resized to the length
																   of the string it holds.
 useStringInPlace	UseStringInPlace	Boolean	False			Don't use internal buffer
																but use the address passed
																in the 'string' resource.
																If in `useStringInPlace' mode, of course,
																the widget has no means to `know' whether
																the app changed the string buffer contents.
																It is up to the application to notify the
																widget that it modified the string by setting
																the `string' resource, passing the buffer
																address (altough it's already known by the
																widget), i.e:
																	XtVaSetValues(textField,
																		XtNuseStringInPlace,True,
																		XtNstring,buffer,0);
																	// buffer contents are changed
																	strcpy(buffer, "blah blah blah");
																	// let the widget know that string changed
																	XtVaSetValues(textField,
																		XtNstring,buffer,0);

 length				Length			Short		0				Length of buffer. Must be
																set accordingly if 
																useStringInPlace is True.
																The internal buffer
																defaults to 15 chars if
																this resource is set to 0.
 justify			Justify			Justify		XtJustifyLeft

 readOnly			ReadOnly		Boolean		False			Only look at the string;
																selection and scrolling is
																still possible.

 scrollChars		ScrollChars		Short		4				Start scrolling if the
																text cursor gets closer
																than 'scrollChars' to
																either end of the
																visible area.

 callback			Callback		Callback	NULL			Called by the 'notify()'
																action.

 modifiedByUser		ModifiedByUser	Boolean		False			This resource is set 'True' by widget code
																whenever the user modifies
																the string. It is up to the application to reset
																this resource to 'False' e.g. after
																acknowledgeing the changes made by the user.
																The app may later check this resource
																again for new changes.
																The actions cited under 'modifiedCallback' check
																this resource before changing the string. If it
																is 'False', the widget saves the old string
																(see 'Backup()' and 'Restore()' actions) and
																sets the resource 'True'.
																Read about the 'autoBlink' resource and the
																'Commit()' action for further information.
 modifiedCallback	Callback		Callback	NULL			called upon any user
																modification of the
																string ie. successful
																- InsertChar()
																- Delete()
																- DeleteToClipboard()
																- InsertSelection()
																actions. The callbacks are also invoked as a
																result of the string having been changed by
																the application or restored by the 'Restored'
																action. The callback reason is supplied in the
																'callData' argument. This argument must be
																casted to 'TfwModificationType'.
																

 blink				Blink			Boolean		False			While this resource is set 'True' the string
																is flashed. The timings are set by the next two
																resources.
 blinkOnTime		BlinkTime		Int			700				'On' time (ms) of the blinker.
 blinkOffTime		BlinkTime		Int			700				'Off' time (ms) of the blinker.
 autoBlink			AutoBlink		Boolean		False			The autoBlink feature is intended to be used
																together with the Commit() action. It provides
																a means to give the user visual feedback that
																she has modified the string.
																As soon as the string is changed by any of the
																actions cited above (see modifiedCallback), the
																string starts blinking (blink is set True) and
																stops only after 'Commit()'ing.
 autoBlinkWaitTime	BlinkTime		Int			2000			First 'on' time period after auto blinking
																starts.

 leftLabel			LeftLabel		Boolean		True			Paint the (optional) label to the left
																(or right, if `False') of the text entry
																area.
 label				Label			String		NULL			Label for the text entry area. No space is
																reserved for the label area if this resource
																is set to NULL. An empty ("") label may be
																supplied if the label space is to be reserved
																/ drawn.
 labelFont			LabelFont		Font		XtDefaultFont	Label font.
 labelSep			LabelSep		Int			2				Space between the label and the text entry
																area. NOTE: this resource is an _Int_, so
																negative values may be used (small negative
																values may be useful to bring the label
																closer to the entry area).
 labelWidth			LabelWidth		Dimension	0				Width reserved for the label. If the current
																width is smaller than labelWidth, the widget
																sets this to the width of the label string.
																Therefore, if you want to change the label
																and you want it to reserve enough space,
																set this resource to 0 when changing the label.
 labelJustify		LabelJustify	Justify		XtJustifyRight  Justification of the label.
**** if not XAW3D (ThreeD class already has a userData resource)
 userData			UserData		Pointer		NULL			arbitrary user data
**** endif
																
 valueAddress		Value			Pointer		NULL
 valueSize			Value			Int			0
 valueType			Value			String		XtRCFormat
 inputFormat		ValueFormat		String		NULL
 outputFormat		ValueFormat		String		NULL

 The last five resources provide a mechanism to connect a textField widget to a variable of
 arbitrary type, that can automatically be updated.
 The public procedures TextFieldString2Value() and TextFieldValue2String() invoke an Xt-type converter
 that converts the text string to 'valueType' at 'valueAddress' or vice versa.

 The `valueType' resource provides a simple way to use _any_ Xt type converter, i.e. a
 TextField may be used to allocate a Pixel value ("color"), the user typing the color name
 to the text field (note that proper translations must be set up for the `Commit' or `Notify' actions
 to be invoked in order for making this example work):

    widget textField;

	// create the widget
	textField=XtVaCreateManatedWidget("textField",
					textFieldWidgetClass, parent,
					XtNvalueType, XtRPixel,
					XtNvalueSize, sizeof(Pixel),
					0);

	XtAddCallback(textField,XtNcallback,getPixelCB,NULL);

    ......

    static void getPixelCB(Widget w, XtPointer closure, XtPointer call_data)
	{
		Pixel someColor;
	
		// set address
		XtVaSetValues(w, XtNvalueAddress, (XtPointer)&someColor, 0);

		// convert and get the color 
		if (TextFieldString2Value(w)) {
			// success
			do_something_with(someColor);
		} else {
			// failure
			notify_user_that_color_alloc_failed();
		}
	}

 The `valueAddress/Size/Type' resources can save many lines of tedious code if you can use an
 existing converter.

 There exists the special representation type 'CFormat' that can be converted using the C-format strings
 a la sprintf()/sscanf(). If the variable is of type 'CFormat', the formatting strings to be used by the
 converter can be set via the 'inputFormat' and 'outputFormat' resources.

 As an example let's assume, there's an integer variable, which should be connected to the widget. The
 integer value should be displayed in hex-representation, but user input should be allowed in the
 usual 'val' (decimal), 0'val' (octal), 0x'val'(hex) style.
 In this case, the resources are set as shown:
	valueAddress &val
	valueSize    sizeof(int)
	valueType    CFormat
	inputFormat  %i
	outputFormat %x
 The value can now be read invoking TextFieldString2Value(wid) and written back by TextFieldValue2String().
 These convenience procedures return 'True' if the conversion was successful. This conversion can be done
 in a callback procedure thus providing automatic updating of application variables.
*/

/* Default translations:

		<Enter>:	CursorState(Active)\n\
		<Leave>:	CursorState(Inactive)\n\
	None	<Btn1Down>:	MoveCursor()\
				HighlightStart()\n\
		<Btn1Motion>:	MoveCursor()\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
		<Btn1Up>:	MoveCursor()\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
		<Btn2Up>  :     MoveCursor()\
				InsertSelection(PRIMARY)\n\
	Shift	<Key>Right:	MoveCursor()\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
 	Shift	<Key>Home :	MoveCursor(Home)\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
 	Shift	<Key>End  :	MoveCursor(End)\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
 	Shift	<Key>Left :	MoveCursor(-1)\
				HighlightExtend()\
				MakeSelection(PRIMARY)\n\
 	Shift	<Key>Delete:	Delete(Selection,End)    \n\
 	Shift	<Key>BackSpace:	Delete(Selection,Home)  \n\
 	Alt	<Key>Delete:	Delete(Selection,All)    \n\
 	Alt	<Key>BackSpace:	Delete(Selection,All)  \n\
		<Key>Right:	MoveCursor()	\
				HighlightStart()\n\
 		<Key>Home :	MoveCursor(Home)\
				HighlightStart()\n\
 		<Key>End  :	MoveCursor(End) \
				HighlightStart()\n\
 		<Key>Left :	MoveCursor(-1)  \
				HighlightStart()\n\
 		<Key>Delete:	Delete(Selection,1)    \n\
 		<Key>BackSpace:	Delete(Selection,-1)  \n\
		<Key>SunCopy:	MakeSelection(CLIPBOARD)\n\
		<Key>SunPaste:	InsertSelection(CLIPBOARD)\n\
		<Key>SunCut:	DeleteToClipboard()\n\
		<Key>Escape:	Restore()\n\
		<Key>:		InsertChar()\
*/

/* Actions:
 The TextFieldWidget processes the following actions:

  (Note that only the first character of any argument is used, although more can be given for sake of
   easier reading)

 Action Name		Arguments			Comment

 MoveCursor([Home|End|<n>])	 			Move the text cursor

							If the action occured due to a Button or Motion
							event, then the cursor is moved to the pointer
							position. If the Button was pressed on one of the
							scroll marks, the cursor is moved one character.

							If any other event invoked the action the argument
							is parsed, and the cursor positioned to the left
							(Home), the right (End), or <n> chars relative to
							the actual position (<n> may be negative). No 
							argument defaults to MoveCursor(1).

 InsertChar([<string>[ ',' ( 'True' | 'False')]])
							Insert one character at the cursor position
							(KeyPress Event only). If any argument is present
							<string> is inserted instead (any event).
							The second argument indicates if the string
							should be parsed for \ escaped sequences
							(\n, \023 etc); defaults to 'True'.

 Delete([Home|End|All|<n>|Selection[,Home|End|All|<n>]])
							Delete from cursor pos. to left (H), to right (E)
							or relative (<n>). (A) deletes all, (S) the high-
							lighted area. In this case, an optional second
							argument indicates what to delete if nothing is
							highlighted. No argument defaults to Delete(1)
							
 HighlightStart()			Mark the beginning of the highlighted area.
							This is to be the pointer position (Button Event) or
							the cursor position (any other event).
							Note: No selection ownership is asserted yet.
							----
							
 HighlightExtend()			Extend the highlighted area i.e. move the beginning
							or the end of this area, whichever is closer to
							the pointer position (Button Event) or the text
							cursor (any other event). If no highlighted area
							exists the beginning is marked.
							Since Xt translations don't allow multiclicks and
							motion events to coexist, a multiclick feature is
							implemented in this action. A double click
							highlights the word (delimited by spaces) at
							the pointer position, a triple click selects the
							whole string.
							Note: No selection ownership is asserted yet.
							----

 Highlight(Word|All|End|Home)
							Set the highlighted area to the whole string (A),
							to the space delimited word at the event position (W),
							or from the event position to the left (H) / right (E).
							The event position is the pointer position (Button or
							Motion event) or the text cursor position (any other
							event).
							Note: No selection ownership is asserted yet.
							----
 
 MakeSelection([Primary|Secondary|Clipboard])
							Assert the ownership of the specified X-Selection.
							The selection can then be requested by other clients.
							No parameter defaults to MakeSelection(P).

 DeleteToClipboard()		Assert the ownership of the CLIPBOARD selection. Then
							wait for another client (eg. 'xclipboard') to copy the
							selected part of the string. If this is done successfully
							the selected part is deleted.

 InsertSelection([Primary|Secondary|Clipboard])
							Request the specified selection value from another client,
							and insert it at the cursor position.
							No argument defaults to InsertSelection(P)

 Notify([<string>])			Call the callbacks on the 'callback' resource's callback
							list. A pointer to the <string> is passed as the
							'call_data' argument to the callback procs.

 Commit()					Like Notify(), but the widget automatically switches off the
							autoBlinker (if active) and sets 'modifiedByUser' to 'False' after executing
							the callback list. Note: no default translation maps to this action.
							As a result of executing this action, the backup string is discarded.

 Backup()					Save the string to a backup copy. This is automatically done by the
							actions cited under 'modifiedCallback' above, if 'modifiedByUser' is
							'False'. The backup may be restored by 'Restore()'.
							Note: the backup is discarded by setting 'modifiedByUser' to 'False',
							or by the application changing the string.

 Restore()					Restore the string to the value it had when 'modifiedByUser' last
							was 'False'.

 CursorState(Active|Inactive|Toggle)
							Set the state of the cursor to active (A), inactive (I)
							or toggle it (T). This affects only how the cursor is
							drawn and can be used when implementing focus traversal.
*/

/* THIS FILE WAS AUTOMATICALLY GENERATED BY SCAN_STRINGS */
/************************* DO NOT EDIT *******************/

#ifdef __STDC__
extern const char	TextFieldResStrings[];
extern const char	TextFieldClStrings[];
extern const char	TextFieldTypeStrings[];
#else
extern char	TextFieldResStrings[];
extern char	TextFieldClStrings[];
extern char	TextFieldTypeStrings[];
#endif

#ifndef XtNinsertPosition
#define XtNinsertPosition ((char *)(&TextFieldResStrings[0]))
#endif
#ifndef XtNlength
#define XtNlength ((char *)(&TextFieldResStrings[15]))
#endif
#ifndef XtNinsensitiveForeground
#define XtNinsensitiveForeground ((char *)(&TextFieldResStrings[22]))
#endif
#ifndef XtNreadOnly
#define XtNreadOnly ((char *)(&TextFieldResStrings[44]))
#endif
#ifndef XtNscrollChars
#define XtNscrollChars ((char *)(&TextFieldResStrings[53]))
#endif
#ifndef XtNmodifiedCallback
#define XtNmodifiedCallback ((char *)(&TextFieldResStrings[65]))
#endif
#ifndef XtNvalueAddress
#define XtNvalueAddress ((char *)(&TextFieldResStrings[82]))
#endif
#ifndef XtNvalueSize
#define XtNvalueSize ((char *)(&TextFieldResStrings[95]))
#endif
#ifndef XtNvalueType
#define XtNvalueType ((char *)(&TextFieldResStrings[105]))
#endif
#ifndef XtNinputFormat
#define XtNinputFormat ((char *)(&TextFieldResStrings[115]))
#endif
#ifndef XtNoutputFormat
#define XtNoutputFormat ((char *)(&TextFieldResStrings[127]))
#endif
#ifndef XtNuseStringInPlace
#define XtNuseStringInPlace ((char *)(&TextFieldResStrings[140]))
#endif
#ifndef XtNdisplayCaret
#define XtNdisplayCaret ((char *)(&TextFieldResStrings[157]))
#endif
#ifndef XtNmodifiedByUser
#define XtNmodifiedByUser ((char *)(&TextFieldResStrings[170]))
#endif
#ifndef XtNblink
#define XtNblink ((char *)(&TextFieldResStrings[185]))
#endif
#ifndef XtNautoBlink
#define XtNautoBlink ((char *)(&TextFieldResStrings[191]))
#endif
#ifndef XtNautoBlinkWaitTime
#define XtNautoBlinkWaitTime ((char *)(&TextFieldResStrings[201]))
#endif
#ifndef XtNblinkOnTime
#define XtNblinkOnTime ((char *)(&TextFieldResStrings[219]))
#endif
#ifndef XtNblinkOffTime
#define XtNblinkOffTime ((char *)(&TextFieldResStrings[231]))
#endif
#ifndef XtNleftLabel
#define XtNleftLabel ((char *)(&TextFieldResStrings[244]))
#endif
#ifndef XtNlabelFont
#define XtNlabelFont ((char *)(&TextFieldResStrings[254]))
#endif
#ifndef XtNlabel
#define XtNlabel ((char *)(&TextFieldResStrings[264]))
#endif
#ifndef XtNlabelWidth
#define XtNlabelWidth ((char *)(&TextFieldResStrings[270]))
#endif
#ifndef XtNlabelJustify
#define XtNlabelJustify ((char *)(&TextFieldResStrings[281]))
#endif
#ifndef XtNlabelSep
#define XtNlabelSep ((char *)(&TextFieldResStrings[294]))
#endif
#ifndef XtNshowNChars
#define XtNshowNChars ((char *)(&TextFieldResStrings[303]))
#endif
#ifndef XtNuserData
#define XtNuserData ((char *)(&TextFieldResStrings[314]))
#endif

#ifndef XtCTextPosition
#define XtCTextPosition ((char *)(&TextFieldClStrings[0]))
#endif
#ifndef XtCLength
#define XtCLength ((char *)(&TextFieldClStrings[13]))
#endif
#ifndef XtCInsensitiveForeground
#define XtCInsensitiveForeground ((char *)(&TextFieldClStrings[20]))
#endif
#ifndef XtCReadOnly
#define XtCReadOnly ((char *)(&TextFieldClStrings[42]))
#endif
#ifndef XtCScrollChars
#define XtCScrollChars ((char *)(&TextFieldClStrings[51]))
#endif
#ifndef XtCValueFormat
#define XtCValueFormat ((char *)(&TextFieldClStrings[63]))
#endif
#ifndef XtCUseStringInPlace
#define XtCUseStringInPlace ((char *)(&TextFieldClStrings[75]))
#endif
#ifndef XtCOutput
#define XtCOutput ((char *)(&TextFieldClStrings[92]))
#endif
#ifndef XtCModifiedByUser
#define XtCModifiedByUser ((char *)(&TextFieldClStrings[99]))
#endif
#ifndef XtCBlink
#define XtCBlink ((char *)(&TextFieldClStrings[114]))
#endif
#ifndef XtCAutoBlink
#define XtCAutoBlink ((char *)(&TextFieldClStrings[120]))
#endif
#ifndef XtCBlinkTime
#define XtCBlinkTime ((char *)(&TextFieldClStrings[130]))
#endif
#ifndef XtCLeftLabel
#define XtCLeftLabel ((char *)(&TextFieldClStrings[140]))
#endif
#ifndef XtCLabelWidth
#define XtCLabelWidth ((char *)(&TextFieldClStrings[150]))
#endif
#ifndef XtCLabelSep
#define XtCLabelSep ((char *)(&TextFieldClStrings[161]))
#endif
#ifndef XtCLabelJustify
#define XtCLabelJustify ((char *)(&TextFieldClStrings[170]))
#endif
#ifndef XtCShowNChars
#define XtCShowNChars ((char *)(&TextFieldClStrings[183]))
#endif
#ifndef XtCUserData
#define XtCUserData ((char *)(&TextFieldClStrings[194]))
#endif

#ifndef XtRCFormat
#define XtRCFormat ((char *)(&TextFieldTypeStrings[0]))
#endif

/* declare specific TextFieldWidget class and instance datatypes */

typedef struct _TextFieldClassRec*	TextFieldWidgetClass;
typedef struct _TextFieldRec*		TextFieldWidget;

/* declare a type for 'insertPosition'; this allows us to
 * be independent from Xaw/Text.h as well as to include it.
 */

#ifdef TEXT_COMPAT
typedef XawTextPosition TfTextPosition;
#else
typedef long			TfTextPosition;
#endif

/* reason for the 'modifiedCallback'; an argument of this type is supplied
 * when the 'modifiedCallback' list is executed.
 */
typedef enum {
	tfwNone = -1,			/* internal use */
	tfwCommitted,			/* the commit action was invoked or the app set
							 * modifiedByUser 'False' without changing the string
							 */
	tfwStringChanged, 		/* XtNstring resource was changed and string differs */
	tfwStringRestored,		/* string was restored */
	tfwModified				/* modified by the user */
} TfwModificationType;

/* declare the class constant */

extern WidgetClass textFieldWidgetClass;

/* public procedures */

#ifdef __cplusplus
extern "C" {
#endif

/* convert the text string to the type indicated
 * by the valueType resource (valueSize must be set correctly)
 * and store the converted value at address valueAddress
 *
 * RETURNS: `True' upon successful conversion.
 */

Boolean TextFieldString2Value(
#if NeedFunctionPrototypes
Widget textFieldWidget
#endif
);

Boolean TextFieldValue2String(
#if NeedFunctionPrototypes
Widget textFieldWidget
#endif
);

#ifdef __cplusplus
}
#endif

#endif /* _TextField_h */
