/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class PopupButton
extends JButton {
    private Dimension preferredSize;
    private Dimension referenceSize;
    private JPopupMenu popupMenu;
    private JRadioButtonMenuItem selectedItem;
    private PopupButtonListener listener;
    private PopupButtonModel model;
    private ImageIcon[] icons;
    private String[] labels;

    public PopupButton(String[] labels, ImageIcon[] icons) {
        super(labels[0], icons[0]);
        this.labels = labels;
        this.icons = icons;
        if (labels.length > 1) {
            this.model = new PopupButtonModel();
            this.listener = new PopupButtonListener();
            this.addMouseMotionListener(this.listener);
            this.setModel(this.model);
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.isShiftDown() && (e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
                        PopupButton.this.showPopupMenu();
                    }
                }
            });
        }
    }

    public Dimension getMinimumSize() {
        Dimension size = this.computePreferredSize();
        if (size != null) {
            return size;
        }
        return super.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        Dimension size = this.computePreferredSize();
        if (size != null) {
            return size;
        }
        return super.getPreferredSize();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.labels.length > 1 && this.model.isRollover() && !this.model.isPressed()) {
            Rectangle popupBounds = this.getPopupBounds();
            g.setColor(Color.WHITE);
            g.fillRect(popupBounds.x + 1, popupBounds.y + 1, popupBounds.width - 2, popupBounds.height - 2);
            g.setColor(this.model.isPressed() && this.model.isArmed() || this.model.isSelected() ? Color.GRAY : Color.LIGHT_GRAY);
            g.drawLine(popupBounds.x, popupBounds.y + 1, popupBounds.x, popupBounds.y + popupBounds.height - 2);
            this.drawPopupArrow(g, popupBounds.x + 4, popupBounds.y + popupBounds.height / 2 - 1);
        }
    }

    public void showPopupMenu() {
        JPopupMenu popup = this.getPopupMenu();
        popup.show(this, 0, this.getSize().height - 1);
    }

    private Rectangle getButtonBounds() {
        return new Rectangle(0, 0, this.getSize().width, this.getSize().height);
    }

    private Rectangle getPopupBounds() {
        Rectangle buttonBounds = this.getButtonBounds();
        return new Rectangle(buttonBounds.x + buttonBounds.width - 15, buttonBounds.y, 15, buttonBounds.height);
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            ActionListener menuItemListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)e.getSource();
                    if (PopupButton.this.selectedItem != menuItem) {
                        PopupButton.this.selectedItem.setSelected(false);
                    }
                    menuItem.setSelected(true);
                    PopupButton.this.selectedItem = menuItem;
                    PopupButton.this.setText(menuItem.getText());
                    if (PopupButton.this.icons.length > 1) {
                        PopupButton.this.setIcon(PopupButton.this.icons[PopupButton.this.getPopupMenu().getComponentIndex(menuItem)]);
                    }
                    PopupButton.this.firePopupAction();
                }
            };
            JPopupMenu popup = new JPopupMenu();
            for (int i = 0; i < this.labels.length; ++i) {
                JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.labels[i], i == 0);
                if (i == 0) {
                    this.selectedItem = menuItem;
                }
                menuItem.addActionListener(menuItemListener);
                popup.add(menuItem);
            }
            this.popupMenu = popup;
        }
        return this.popupMenu;
    }

    private Dimension computePreferredSize() {
        if (this.labels.length > 1 && this.referenceSize != super.getPreferredSize()) {
            JButton referenceButton = new JButton(this.labels[0], this.icons[0]);
            referenceButton.setFont(this.getFont());
            referenceButton.setBorder(this.getBorder());
            referenceButton.setMargin(this.getMargin());
            referenceButton.setContentAreaFilled(this.isContentAreaFilled());
            referenceButton.setVerticalTextPosition(this.getVerticalTextPosition());
            referenceButton.setHorizontalTextPosition(this.getHorizontalTextPosition());
            this.preferredSize = new Dimension(referenceButton.getPreferredSize());
            if (this.labels.length > 1) {
                for (int i = 1; i < this.labels.length; ++i) {
                    referenceButton.setText(this.labels[i]);
                    if (this.icons.length > 1) {
                        referenceButton.setIcon(this.icons[i]);
                    }
                    this.preferredSize.width = Math.max(this.preferredSize.width, referenceButton.getPreferredSize().width);
                    this.preferredSize.height = Math.max(this.preferredSize.height, referenceButton.getPreferredSize().height);
                }
            }
            this.referenceSize = super.getPreferredSize();
        }
        return this.preferredSize;
    }

    private void drawPopupArrow(Graphics g, int x, int y) {
        g.setColor(this.listener.isOverPopupArea() ? Color.DARK_GRAY : Color.GRAY);
        if (this.model.isPopupAreaPressed()) {
            ++x;
            ++y;
        }
        g.drawLine(x + 0, y + 0, x + 6, y + 0);
        g.drawLine(x + 1, y + 1, x + 5, y + 1);
        g.drawLine(x + 2, y + 2, x + 4, y + 2);
        g.drawLine(x + 3, y + 3, x + 3, y + 3);
    }

    private void firePopupAction() {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
    }

    private class PopupButtonModel
    extends DefaultButtonModel {
        private boolean popupAreaPressed;

        private PopupButtonModel() {
        }

        public void setPopupAreaPressed(boolean b) {
            this.popupAreaPressed = b;
        }

        public boolean isPopupAreaPressed() {
            return this.popupAreaPressed;
        }

        public void setPressed(boolean b) {
            if (!b) {
                boolean popupAction = this.isPopupAreaPressed() && this.isArmed() && PopupButton.this.listener.isOverPopupArea();
                this.setPopupAreaPressed(b);
                super.setPressed(b);
                if (popupAction) {
                    PopupButton.this.showPopupMenu();
                }
            } else if (PopupButton.this.listener.isOverPopupArea()) {
                this.setPopupAreaPressed(b);
            } else {
                super.setPressed(b);
            }
        }
    }

    private class PopupButtonListener
    extends MouseMotionAdapter {
        private boolean overPopupArea;

        private PopupButtonListener() {
        }

        public boolean isOverPopupArea() {
            return this.overPopupArea;
        }

        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }

        public void mouseMoved(MouseEvent e) {
            boolean newOverPopupArea = PopupButton.this.getPopupBounds().contains(e.getPoint());
            if (this.overPopupArea != newOverPopupArea) {
                this.overPopupArea = newOverPopupArea;
                PopupButton.this.repaint();
            }
        }
    }
}

