/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLLabel
extends JEditorPane
implements HyperlinkListener {
    public HTMLLabel() {
        this.setEditorKit(new HTMLEditorKit());
        this.setEditable(false);
        this.setOpaque(false);
        this.setNavigationFilter(new NavigationFilter(){

            public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                super.moveDot(fb, 0, bias);
            }

            public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                super.setDot(fb, 0, bias);
            }

            public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
                return 0;
            }
        });
        this.setFont(UIManager.getFont("Label.font"));
        this.addHyperlinkListener(this);
    }

    public HTMLLabel(String text) {
        this();
        this.setText(text);
    }

    public void setText(String value) {
        Font font = this.getFont();
        Color textColor = this.getForeground();
        value = value.replaceAll("\\n\\r|\\r\\n|\\n|\\r", "<br>");
        value = value.replaceAll("<code>", "<code style=\"font-size: " + font.getSize() + "pt;\">");
        String colorText = "rgb(" + textColor.getRed() + "," + textColor.getGreen() + "," + textColor.getBlue() + ")";
        super.setText("<html><body text=\"" + colorText + "\" style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + value + "</body></html>");
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.showURL(e.getURL());
        } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void showURL(URL url) {
    }
}

