/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.appui.about;

import com.sun.tools.visualvm.core.ui.DesktopUtils;
import com.sun.tools.visualvm.modules.appui.about.AboutDialog;
import com.sun.tools.visualvm.modules.appui.about.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;

public class AboutDialogPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(AboutDialogPanel.class.getName());
    private HTMLTextArea licenseArea;

    AboutDialogPanel() {
        this.initComponents();
        final Runnable repainter = new Runnable(){

            public void run() {
                AboutDialogPanel.this.repaint();
            }
        };
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && AboutDialogPanel.this.isShowing()) {
                    SwingUtilities.invokeLater(repainter);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwingUtilities.invokeLater(repainter);
                        }
                    });
                }
            }
        });
    }

    void updateAppearance() {
        String message = AboutDialog.getInstance().getMessage();
        String htmlMessage = AboutDialog.getInstance().getHTMLMessage();
        this.licenseArea.setVisible(message != null);
        if (message != null) {
            if (htmlMessage != null && DesktopUtils.isBrowseAvailable()) {
                this.licenseArea.setText(htmlMessage);
            } else {
                this.licenseArea.setText(message);
            }
        }
    }

    private void initComponents() {
        ImagePanel splashImageContainer = new ImagePanel(AboutDialog.getInstance().getAboutImage());
        splashImageContainer.setBackground(new Color(243, 112, 33));
        JSeparator separator = new JSeparator(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.licenseArea = new HTMLTextArea(){

            protected void showURL(URL url) {
                if (DesktopUtils.isBrowseAvailable()) {
                    try {
                        DesktopUtils.browse((URI)url.toURI());
                    }
                    catch (Exception e) {
                        LOGGER.throwing(AboutDialogPanel.class.getName(), "initComponents", e);
                    }
                }
            }
        };
        this.licenseArea.setOpaque(true);
        this.licenseArea.setBackground(new Color(255, 255, 255, 90));
        this.licenseArea.setForeground(Color.BLACK);
        this.licenseArea.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 15));
        this.licenseArea.setCaret((Caret)new NullCaret());
        this.licenseArea.setShowPopup(false);
        this.licenseArea.setFocusable(false);
        JPanel licenseContainer = new JPanel(new BorderLayout());
        licenseContainer.setOpaque(false);
        JPanel leftSpace = new JPanel(null){

            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                GradientPaint titleGradient = new GradientPaint(150.0f, 0.0f, new Color(255, 255, 255, 0), this.getWidth(), 0.0f, new Color(255, 255, 255, 90));
                g2.setPaint(titleGradient);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        leftSpace.setOpaque(false);
        leftSpace.setMinimumSize(new Dimension(200, 1));
        leftSpace.setPreferredSize(new Dimension(200, 1));
        leftSpace.setMaximumSize(new Dimension(200, 1));
        licenseContainer.add((Component)leftSpace, "West");
        licenseContainer.add((Component)this.licenseArea, "Center");
        splashImageContainer.setLayout(new BorderLayout());
        splashImageContainer.add((Component)licenseContainer, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)splashImageContainer, "Center");
        this.add((Component)separator, "South");
    }

    private static final class NullCaret
    implements Caret {
        private NullCaret() {
        }

        public void install(JTextComponent c) {
        }

        public void deinstall(JTextComponent c) {
        }

        public void paint(Graphics g) {
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public boolean isVisible() {
            return false;
        }

        public void setVisible(boolean v) {
        }

        public boolean isSelectionVisible() {
            return false;
        }

        public void setSelectionVisible(boolean v) {
        }

        public void setMagicCaretPosition(Point p) {
        }

        public Point getMagicCaretPosition() {
            return new Point(0, 0);
        }

        public void setBlinkRate(int rate) {
        }

        public int getBlinkRate() {
            return 0;
        }

        public int getDot() {
            return 0;
        }

        public int getMark() {
            return 0;
        }

        public void setDot(int dot) {
        }

        public void moveDot(int dot) {
        }
    }
}

