/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application;

import com.sun.tools.visualvm.application.ApplicationSupport;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasupport.Stateful;
import com.sun.tools.visualvm.host.Host;
import java.io.File;

public abstract class Application
extends DataSource
implements Stateful {
    public static final Application CURRENT_APPLICATION = ApplicationSupport.getInstance().createCurrentApplication();
    public static final int UNKNOWN_PID = -1;
    private String id;
    private int pid;
    private Host host;
    private int state = 1;

    public Application(Host host, String id) {
        if (host == null) {
            throw new IllegalArgumentException("Host cannot be null");
        }
        if (id == null && this.pid == -1) {
            throw new IllegalArgumentException("Either id or pid must be provided for the application");
        }
        this.host = host;
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public int getPid() {
        return -1;
    }

    public final Host getHost() {
        return this.host;
    }

    public final boolean isLocalApplication() {
        return Host.LOCALHOST.equals((Object)this.getHost());
    }

    public final synchronized int getState() {
        return this.state;
    }

    protected final synchronized void setState(final int newState) {
        final int oldState = this.state;
        this.state = newState;
        if (DataSource.EVENT_QUEUE.isRequestProcessorThread()) {
            this.getChangeSupport().firePropertyChange("prop_state", oldState, newState);
        } else {
            DataSource.EVENT_QUEUE.post(new Runnable(){

                public void run() {
                    Application.this.getChangeSupport().firePropertyChange("prop_state", oldState, newState);
                }
            });
        }
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Application)) {
            return false;
        }
        Application app = (Application)((Object)obj);
        return this.getId().equals(app.getId());
    }

    public String toString() {
        return "Application [id: " + this.getId() + ", pid: " + this.getPid() + ", host: " + this.getHost().getHostName() + "]";
    }

    protected Storage createStorage() {
        File directory = new File(Storage.getTemporaryStorageDirectoryString() + File.separator + this.getId());
        return new Storage(directory);
    }
}

