/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class HeapFragmentWalkerUI
extends JPanel {
    private static final String NAVIGATE_BACK_NAME = NbBundle.getMessage(HeapFragmentWalkerUI.class, (String)"HeapFragmentWalkerUI_NavigateBackName");
    private static final String NAVIGATE_BACK_DESCR = NbBundle.getMessage(HeapFragmentWalkerUI.class, (String)"HeapFragmentWalkerUI_NavigateBackDescr");
    private static final String NAVIGATE_FORWARD_NAME = NbBundle.getMessage(HeapFragmentWalkerUI.class, (String)"HeapFragmentWalkerUI_NavigateForwardName");
    private static final String NAVIGATE_FORWARD_DESCR = NbBundle.getMessage(HeapFragmentWalkerUI.class, (String)"HeapFragmentWalkerUI_NavigateForwardDescr");
    private static ImageIcon ICON_BACK = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/back.png"));
    private static ImageIcon ICON_FORWARD = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/forward.png"));
    private AbstractAction backAction;
    private AbstractAction forwardAction;
    private AbstractButton analysisControllerPresenter;
    private AbstractButton classesControllerPresenter;
    private AbstractButton instancesControllerPresenter;
    private AbstractButton summaryControllerPresenter;
    private CardLayout controllerUIsLayout;
    private HeapFragmentWalker heapFragmentWalker;
    private JPanel analysisControllerPanel;
    private JPanel classesControllerPanel;
    private JPanel controllerUIsPanel;
    private JPanel instancesControllerPanel;
    private JPanel summaryControllerPanel;
    private JToolBar toolBar;
    private boolean analysisEnabled;
    private int subControllersIndex;

    public HeapFragmentWalkerUI(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        ProfilerIDESettings pis = ProfilerIDESettings.getInstance();
        this.analysisEnabled = pis.getHeapWalkerAnalysisEnabled();
        this.initComponents();
        this.updateNavigationActions();
    }

    public boolean isAnalysisViewActive() {
        return this.analysisControllerPanel.isShowing();
    }

    public boolean isClassesViewActive() {
        return this.classesControllerPanel.isShowing();
    }

    public boolean isInstancesViewActive() {
        return this.instancesControllerPanel.isShowing();
    }

    public boolean isSummaryViewActive() {
        return this.summaryControllerPanel.isShowing();
    }

    public void showAnalysisView() {
        this.showAnalysisView(true);
    }

    public void showClassesView() {
        this.showClassesView(true);
    }

    public void showHistoryAnalysisView() {
        this.showAnalysisView(false);
    }

    public void showHistoryClassesView() {
        this.showClassesView(false);
    }

    public void showHistoryInstancesView() {
        this.showInstancesView(false);
    }

    public void showHistorySummaryView() {
        this.showSummaryView(false);
    }

    public void showInstancesView() {
        this.showInstancesView(true);
    }

    public void showSummaryView() {
        this.showSummaryView(true);
    }

    public void updateNavigationActions() {
        this.backAction.setEnabled(this.heapFragmentWalker.isNavigationBackAvailable());
        this.forwardAction.setEnabled(this.heapFragmentWalker.isNavigationForwardAvailable());
    }

    private JToolBar createToolBar() {
        JToolBar tb = new JToolBar(){

            public Component add(Component comp) {
                if (comp instanceof AbstractButton) {
                    UIUtils.fixButtonUI((AbstractButton)((AbstractButton)comp));
                }
                return super.add(comp);
            }

            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                return new Dimension(dim.width, dim.height + 4);
            }
        };
        tb.setFloatable(false);
        tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        return tb;
    }

    private void initComponents() {
        this.summaryControllerPanel = this.heapFragmentWalker.getSummaryController().getPanel();
        this.classesControllerPanel = this.heapFragmentWalker.getClassesController().getPanel();
        this.instancesControllerPanel = this.heapFragmentWalker.getInstancesController().getPanel();
        if (this.analysisEnabled) {
            this.analysisControllerPanel = this.heapFragmentWalker.getAnalysisController().getPanel();
        }
        this.summaryControllerPresenter = this.heapFragmentWalker.getSummaryController().getPresenter();
        this.classesControllerPresenter = this.heapFragmentWalker.getClassesController().getPresenter();
        this.instancesControllerPresenter = this.heapFragmentWalker.getInstancesController().getPresenter();
        if (this.analysisEnabled) {
            this.analysisControllerPresenter = this.heapFragmentWalker.getAnalysisController().getPresenter();
        }
        this.backAction = new AbstractAction(NAVIGATE_BACK_NAME, ICON_BACK){

            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.heapFragmentWalker.navigateBack();
            }
        };
        this.backAction.putValue("ShortDescription", NAVIGATE_BACK_DESCR);
        this.forwardAction = new AbstractAction(NAVIGATE_FORWARD_NAME, ICON_FORWARD){

            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.heapFragmentWalker.navigateForward();
            }
        };
        this.forwardAction.putValue("ShortDescription", NAVIGATE_FORWARD_DESCR);
        this.setLayout(new BorderLayout());
        this.toolBar = this.createToolBar();
        this.toolBar.add(this.backAction);
        this.toolBar.add(this.forwardAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.summaryControllerPresenter);
        this.toolBar.add(this.classesControllerPresenter);
        this.toolBar.add(this.instancesControllerPresenter);
        if (this.analysisEnabled) {
            this.toolBar.add(this.analysisControllerPresenter);
        }
        JPanel toolBarFiller = new JPanel(new FlowLayout(3, 0, 0));
        toolBarFiller.setOpaque(false);
        this.toolBar.add(toolBarFiller);
        this.subControllersIndex = this.toolBar.getComponentCount();
        this.controllerUIsLayout = new CardLayout();
        this.controllerUIsPanel = new JPanel(this.controllerUIsLayout);
        this.controllerUIsPanel.add((Component)this.summaryControllerPanel, this.summaryControllerPresenter.getText());
        this.controllerUIsPanel.add((Component)this.classesControllerPanel, this.classesControllerPresenter.getText());
        this.controllerUIsPanel.add((Component)this.instancesControllerPanel, this.instancesControllerPresenter.getText());
        if (this.analysisEnabled) {
            this.controllerUIsPanel.add((Component)this.analysisControllerPanel, this.analysisControllerPresenter.getText());
        }
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.controllerUIsPanel, "Center");
        this.summaryControllerPresenter.setSelected(true);
        this.classesControllerPresenter.setSelected(false);
        this.instancesControllerPresenter.setSelected(false);
        if (this.analysisEnabled) {
            this.analysisControllerPresenter.setSelected(false);
        }
        this.summaryControllerPresenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.showSummaryView();
            }
        });
        this.classesControllerPresenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.showClassesView();
            }
        });
        this.instancesControllerPresenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.showInstancesView();
            }
        });
        if (this.analysisEnabled) {
            this.analysisControllerPresenter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HeapFragmentWalkerUI.this.showAnalysisView();
                }
            });
        }
        this.updateClientPresenters(this.heapFragmentWalker.getSummaryController().getClientPresenters());
        this.summaryControllerPresenter.setSelected(true);
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.moveToPreviousView();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.moveToNextView();
            }
        });
    }

    private void moveToNextView() {
        if (this.isSummaryViewActive()) {
            this.showClassesView();
        } else if (this.isClassesViewActive()) {
            this.showInstancesView();
        } else if (this.isInstancesViewActive()) {
            if (this.analysisEnabled) {
                this.showAnalysisView();
            } else {
                this.showSummaryView();
            }
        } else if (this.isAnalysisViewActive()) {
            this.showSummaryView();
        }
    }

    private void moveToPreviousView() {
        if (this.isSummaryViewActive()) {
            if (this.analysisEnabled) {
                this.showAnalysisView();
            } else {
                this.showInstancesView();
            }
        } else if (this.isClassesViewActive()) {
            this.showSummaryView();
        } else if (this.isInstancesViewActive()) {
            this.showClassesView();
        } else if (this.isAnalysisViewActive()) {
            this.showInstancesView();
        }
    }

    private void showAnalysisView(boolean addToHistory) {
        if (!this.isAnalysisViewActive()) {
            if (addToHistory) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.analysisControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getAnalysisController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showClassesView(boolean addToHistory) {
        if (!this.isClassesViewActive()) {
            if (addToHistory) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.classesControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getClassesController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showInstancesView(boolean addToHistory) {
        if (!this.isInstancesViewActive()) {
            if (addToHistory) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.instancesControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getInstancesController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showSummaryView(boolean addToHistory) {
        if (!this.isSummaryViewActive()) {
            if (addToHistory) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.summaryControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getSummaryController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void unifyComponentsSize(Component c1, Component c2) {
        Dimension preferredSize = new Dimension(Math.max(c1.getPreferredSize().width, c2.getPreferredSize().width), Math.max(c1.getPreferredSize().height, c2.getPreferredSize().height));
        c1.setPreferredSize(preferredSize);
        c2.setPreferredSize(preferredSize);
    }

    private void updateClientPresenters(AbstractButton[] clientPresenters) {
        while (this.toolBar.getComponentCount() > this.subControllersIndex) {
            this.toolBar.remove(this.subControllersIndex);
        }
        for (int i = 0; i < clientPresenters.length; ++i) {
            this.toolBar.add(clientPresenters[i]);
        }
    }

    private void updatePresenters() {
        this.summaryControllerPresenter.setSelected(this.summaryControllerPanel.isShowing());
        this.classesControllerPresenter.setSelected(this.classesControllerPanel.isShowing());
        this.instancesControllerPresenter.setSelected(this.instancesControllerPanel.isShowing());
        if (this.analysisEnabled) {
            this.analysisControllerPresenter.setSelected(this.analysisControllerPanel.isShowing());
        }
    }
}

