/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.netbeans.beaninfo.editors.FileEditor;
import org.netbeans.beaninfo.editors.StringCustomEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FileArrayEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
PropertyChangeListener {
    private int mode = 2;
    private boolean directories = true;
    private boolean files = true;
    private boolean fileHiding = false;
    private javax.swing.filechooser.FileFilter fileFilter;
    private File currentDirectory;
    private File baseDirectory;
    private JFileChooser chooser;
    private boolean editable = true;

    public void attachEnv(PropertyEnv propertyEnv) {
        Object object;
        Object object2;
        Object object3;
        this.directories = true;
        this.files = true;
        this.fileFilter = null;
        this.fileHiding = false;
        Object object4 = propertyEnv.getFeatureDescriptor().getValue("directories");
        if (object4 instanceof Boolean) {
            this.directories = (Boolean)object4;
        }
        if ((object3 = propertyEnv.getFeatureDescriptor().getValue("files")) instanceof Boolean) {
            this.files = (Boolean)object3;
        }
        if ((object2 = propertyEnv.getFeatureDescriptor().getValue("filter")) instanceof FilenameFilter) {
            this.fileFilter = new FileEditor.DelegatingFilenameFilter((FilenameFilter)object2);
        } else if (object2 instanceof javax.swing.filechooser.FileFilter) {
            this.fileFilter = (javax.swing.filechooser.FileFilter)object2;
        } else if (object2 instanceof FileFilter) {
            this.fileFilter = new FileEditor.DelegatingFileFilter((FileFilter)object2);
        }
        Object object5 = propertyEnv.getFeatureDescriptor().getValue("currentDir");
        if (object5 instanceof File) {
            this.currentDirectory = (File)object5;
            if (!this.currentDirectory.isDirectory()) {
                Logger.getAnonymousLogger().warning("java.io.File will not accept currentDir=" + this.baseDirectory);
                this.currentDirectory = null;
            }
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue("baseDir")) instanceof File) {
            this.baseDirectory = (File)object;
            if (!this.baseDirectory.isDirectory() || !this.baseDirectory.isAbsolute()) {
                Logger.getAnonymousLogger().warning("java.io.File will not accept baseDir=" + this.baseDirectory);
                this.baseDirectory = null;
            }
        }
        this.mode = this.files ? (this.directories ? 2 : 0) : (this.directories ? 1 : 2);
        Object object6 = propertyEnv.getFeatureDescriptor().getValue("file_hiding");
        if (object6 instanceof Boolean) {
            this.fileHiding = (Boolean)object6;
        }
        if (propertyEnv.getFeatureDescriptor() instanceof Node.Property) {
            Node.Property property = (Node.Property)propertyEnv.getFeatureDescriptor();
            this.editable = property.canWrite();
        }
    }

    public String getAsText() {
        File[] fileArray = (File[])this.getValue();
        if (fileArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuilder.append(fileArray[i].getPath());
        }
        if (fileArray.length == 0) {
            stringBuilder.append('.');
        }
        return stringBuilder.append(']').toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null");
        }
        if ("".equals(string)) {
            this.setValue(null);
            return;
        }
    }

    public Component getCustomEditor() {
        if (!this.editable) {
            return new StringCustomEditor(this.getAsText(), false);
        }
        if (this.chooser == null) {
            File[] fileArray;
            this.chooser = FileEditor.createHackedFileChooser();
            this.chooser.setMultiSelectionEnabled(true);
            Object object = this.getValue();
            File file = null;
            if (object instanceof File[] && (fileArray = (File[])object).length > 0 && (file = fileArray[0]) != null && !file.isAbsolute() && this.baseDirectory != null) {
                file = new File(this.baseDirectory, file.getPath());
            }
            if (this.currentDirectory != null) {
                this.chooser.setCurrentDirectory(this.currentDirectory);
            } else if (file != null && file.getParentFile() != null) {
                this.chooser.setCurrentDirectory(file.getParentFile());
                this.chooser.setSelectedFile(file);
            } else if (FileEditor.lastCurrentDir != null) {
                this.chooser.setCurrentDirectory(FileEditor.lastCurrentDir);
            }
            this.chooser.setFileSelectionMode(this.mode);
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            switch (this.mode) {
                case 2: {
                    this.chooser.setDialogTitle(FileArrayEditor.getString("CTL_DialogTitleFilesAndDirs"));
                    break;
                }
                case 0: {
                    this.chooser.setDialogTitle(FileArrayEditor.getString("CTL_DialogTitleFiles"));
                    break;
                }
                case 1: {
                    this.chooser.setDialogTitle(FileArrayEditor.getString("CTL_DialogTitleDirs"));
                }
            }
            this.chooser.setFileHidingEnabled(this.fileHiding);
            this.chooser.setControlButtonsAreShown(false);
            this.chooser.addPropertyChangeListener(this);
            HelpCtx.setHelpIDString((JComponent)this.chooser, (String)this.getHelpCtx().getHelpID());
        }
        return this.chooser;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getJavaInitializationString() {
        File[] fileArray = (File[])this.getValue();
        if (fileArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder("new java.io.File[] { ");
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.baseDirectory != null && !fileArray[i].isAbsolute()) {
                stringBuilder.append("new java.io.File(").append(FileEditor.stringify(this.baseDirectory.getPath())).append(", ").append(FileEditor.stringify(fileArray[i].getPath())).append("), ");
                continue;
            }
            stringBuilder.append("new java.io.File(").append(FileEditor.stringify(fileArray[i].getAbsolutePath())).append("), ");
        }
        return stringBuilder.append(" }").toString();
    }

    private HelpCtx getHelpCtx() {
        return new HelpCtx(FileEditor.class);
    }

    private static String getString(String string) {
        return NbBundle.getBundle(FileArrayEditor.class).getString(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        Object object;
        JFileChooser jFileChooser;
        if (propertyChangeEvent.getSource() instanceof JFileChooser) {
            jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            if (this.mode == 1) {
                if ("directoryChanged".equals(propertyChangeEvent.getPropertyName()) && jFileChooser.getSelectedFile() == null && (object = jFileChooser.getCurrentDirectory()) != null) {
                    this.setValue(new File[]{new File(((File)object).getAbsolutePath())});
                    return;
                }
            }
        }
        if (!"SelectedFilesChangedProperty".equals(propertyChangeEvent.getPropertyName()) && !"SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (!(propertyChangeEvent.getSource() instanceof JFileChooser)) {
            return;
        }
        jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
        object = jFileChooser.getSelectedFiles();
        if (object == null) {
            return;
        }
        if (((File[])object).length == 0 && jFileChooser.getSelectedFile() != null) {
            object = new File[]{jFileChooser.getSelectedFile()};
        }
        for (n = 0; n < ((File[])object).length; ++n) {
            if (!this.files && ((File)object[n]).isFile()) {
                return;
            }
            if (this.directories || !((File)object[n]).isDirectory()) continue;
            return;
        }
        if (this.baseDirectory != null) {
            for (n = 0; n < ((Object)object).length; ++n) {
                String string = FileEditor.getChildRelativePath(this.baseDirectory, (File)object[n]);
                if (string == null) continue;
                object[n] = new File(string);
            }
        }
        File[] fileArray = new File[((File[])object).length];
        for (int i = 0; i < ((Object)object).length; ++i) {
            fileArray[i] = new File(((File)object[i]).getAbsolutePath());
        }
        this.setValue(fileArray);
        FileEditor.lastCurrentDir = jFileChooser.getCurrentDirectory();
    }
}

