/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.host.views.overview;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.core.ui.components.NotSupportedDisplayer;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.host.model.HostOverview;
import com.sun.tools.visualvm.host.model.HostOverviewFactory;
import com.sun.tools.visualvm.host.views.overview.ChartsSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HostOverviewView
extends DataSourceView
implements DataRemovedListener<Host> {
    private static final String IMAGE_PATH = "com/sun/tools/visualvm/host/views/resources/overview.png";
    private Timer timer;
    private HostOverview hostOverview;

    public HostOverviewView(Host host) {
        super((DataSource)host, NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Overview"), new ImageIcon(Utilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 0, false);
    }

    protected void willBeAdded() {
        this.hostOverview = HostOverviewFactory.getSystemOverviewFor((Host)((Host)this.getDataSource()));
    }

    protected void removed() {
        this.timer.stop();
    }

    public void dataRemoved(Host dataSource) {
        this.timer.stop();
    }

    protected DataViewComponent createComponent() {
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport((Host)this.getDataSource()).getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        final CpuLoadViewSupport cpuLoadViewSupport = new CpuLoadViewSupport(this.hostOverview);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_CPU"), true), 1);
        dvc.addDetailsView(cpuLoadViewSupport.getDetailsView(), 1);
        final PhysicalMemoryViewSupport physicalMemoryViewSupport = new PhysicalMemoryViewSupport();
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Memory"), true), 2);
        dvc.addDetailsView(physicalMemoryViewSupport.getDetailsView(), 2);
        final SwapMemoryViewSupport swapMemoryViewSupport = new SwapMemoryViewSupport();
        dvc.addDetailsView(swapMemoryViewSupport.getDetailsView(), 2);
        this.timer = new Timer(2000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                final long time = System.currentTimeMillis();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        cpuLoadViewSupport.refresh(HostOverviewView.this.hostOverview, time);
                        physicalMemoryViewSupport.refresh(HostOverviewView.this.hostOverview, time);
                        swapMemoryViewSupport.refresh(HostOverviewView.this.hostOverview, time);
                    }
                });
            }
        });
        this.timer.setInitialDelay(800);
        this.timer.start();
        ((Host)this.getDataSource()).notifyWhenRemoved((DataRemovedListener)this);
        return dvc;
    }

    private static class SwapMemoryViewSupport
    extends JPanel {
        private ChartsSupport.Chart memorySwapMetricsChart;
        private HTMLLabel usedSwapMemoryLabel;
        private HTMLLabel totalSwapMemoryLabel;
        private static final NumberFormat formatter = NumberFormat.getNumberInstance();
        private static final int refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;
        private static final String USED_SWAP = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Used_swap");
        private static final String TOTAL_SWAP = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Total_swap");

        public SwapMemoryViewSupport() {
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Swap_memory"), null, 20, (JComponent)this, null);
        }

        public void refresh(HostOverview hostOverview, long time) {
            long memorySwapMax = hostOverview.getTotalSwapSpaceSize();
            long memorySwapUsed = memorySwapMax - hostOverview.getFreeSwapSpaceSize();
            this.memorySwapMetricsChart.getModel().addItemValues(time, new long[]{memorySwapUsed});
            this.usedSwapMemoryLabel.setText("<nobr><b>" + USED_SWAP + ":</b> " + formatter.format(memorySwapUsed) + " </nobr>");
            this.totalSwapMemoryLabel.setText("<nobr><b>" + TOTAL_SWAP + ":</b> " + formatter.format(memorySwapMax) + " </nobr>");
            this.memorySwapMetricsChart.setToolTipText("<html><nobr><b>" + USED_SWAP + ":</b> " + formatter.format(memorySwapUsed) + " </nobr>" + "<br>" + "<nobr><b>" + TOTAL_SWAP + ":</b> " + formatter.format(memorySwapMax) + " </nobr></html>");
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.usedSwapMemoryLabel = new HTMLLabel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, refLabelHeight);
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.usedSwapMemoryLabel.setText("<nobr><b>" + USED_SWAP + ":</b></nobr>");
            this.usedSwapMemoryLabel.setOpaque(false);
            this.totalSwapMemoryLabel = new HTMLLabel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, refLabelHeight);
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.totalSwapMemoryLabel.setText("<nobr><b>" + TOTAL_SWAP + ":</b></nobr>");
            this.totalSwapMemoryLabel.setOpaque(false);
            final JPanel memorySwapMetricsDataPanel = new JPanel(new GridLayout(1, 2));
            memorySwapMetricsDataPanel.setOpaque(false);
            memorySwapMetricsDataPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            memorySwapMetricsDataPanel.add((Component)this.usedSwapMemoryLabel);
            memorySwapMetricsDataPanel.add((Component)this.totalSwapMemoryLabel);
            this.memorySwapMetricsChart = new ChartsSupport.SwapMemoryMetricsChart();
            this.memorySwapMetricsChart.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), this.memorySwapMetricsChart.getBorder()));
            JPanel memorySwapMetricsLegendContainer = new JPanel(new FlowLayout(4));
            memorySwapMetricsLegendContainer.setOpaque(false);
            memorySwapMetricsLegendContainer.add(this.memorySwapMetricsChart.getBigLegendPanel());
            final JPanel memorySwapMetricsPanel = new JPanel(new BorderLayout());
            memorySwapMetricsPanel.setOpaque(true);
            memorySwapMetricsPanel.setBackground(Color.WHITE);
            memorySwapMetricsPanel.add((Component)memorySwapMetricsDataPanel, "North");
            memorySwapMetricsPanel.add((Component)((Object)this.memorySwapMetricsChart), "Center");
            memorySwapMetricsPanel.add((Component)memorySwapMetricsLegendContainer, "South");
            final boolean[] memorySwapMetricsPanelResizing = new boolean[]{false};
            memorySwapMetricsPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            memorySwapMetricsPanel.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    boolean shouldBeVisible;
                    if (memorySwapMetricsPanelResizing[0]) {
                        memorySwapMetricsPanelResizing[0] = false;
                        return;
                    }
                    boolean bl = shouldBeVisible = memorySwapMetricsPanel.getSize().height > 275;
                    if (shouldBeVisible == memorySwapMetricsDataPanel.isVisible()) {
                        return;
                    }
                    memorySwapMetricsPanelResizing[0] = true;
                    memorySwapMetricsDataPanel.setVisible(shouldBeVisible);
                }
            });
            this.add((Component)memorySwapMetricsPanel, "Center");
        }
    }

    private static class PhysicalMemoryViewSupport
    extends JPanel {
        private ChartsSupport.Chart memoryMetricsChart;
        private HTMLLabel usedMemoryLabel;
        private HTMLLabel totalMemoryLabel;
        private static final NumberFormat formatter = NumberFormat.getNumberInstance();
        private static final int refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;
        private static String USED_MEMORY = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Used_memory");
        private static String TOTAL_MEMORY = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Total_memory");

        public PhysicalMemoryViewSupport() {
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Physical_memory"), null, 10, (JComponent)this, null);
        }

        public void refresh(HostOverview hostOverview, long time) {
            long memoryMax = hostOverview.getTotalPhysicalMemorySize();
            long memoryUsed = memoryMax - hostOverview.getFreePhysicalMemorySize();
            this.memoryMetricsChart.getModel().addItemValues(time, new long[]{memoryUsed});
            this.usedMemoryLabel.setText("<nobr><b>" + USED_MEMORY + ":</b> " + formatter.format(memoryUsed) + " </nobr>");
            this.totalMemoryLabel.setText("<nobr><b>" + TOTAL_MEMORY + ":</b> " + formatter.format(memoryMax) + " </nobr>");
            this.memoryMetricsChart.setToolTipText("<html><nobr><b>" + USED_MEMORY + ":</b> " + formatter.format(memoryUsed) + " </nobr>" + "<br>" + "<nobr><b>" + TOTAL_MEMORY + ":</b> " + formatter.format(memoryMax) + " </nobr></html>");
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.usedMemoryLabel = new HTMLLabel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, refLabelHeight);
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.usedMemoryLabel.setText("<nobr><b>" + USED_MEMORY + ":</b></nobr>");
            this.usedMemoryLabel.setOpaque(false);
            this.totalMemoryLabel = new HTMLLabel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, refLabelHeight);
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.totalMemoryLabel.setText("<nobr><b>" + TOTAL_MEMORY + ":</b></nobr>");
            this.totalMemoryLabel.setOpaque(false);
            final JPanel memoryMetricsDataPanel = new JPanel(new GridLayout(1, 2));
            memoryMetricsDataPanel.setOpaque(false);
            memoryMetricsDataPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            memoryMetricsDataPanel.add((Component)this.usedMemoryLabel);
            memoryMetricsDataPanel.add((Component)this.totalMemoryLabel);
            this.memoryMetricsChart = new ChartsSupport.PhysicalMemoryMetricsChart();
            this.memoryMetricsChart.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), this.memoryMetricsChart.getBorder()));
            JPanel memoryMetricsLegendContainer = new JPanel(new FlowLayout(4));
            memoryMetricsLegendContainer.setOpaque(false);
            memoryMetricsLegendContainer.add(this.memoryMetricsChart.getBigLegendPanel());
            final JPanel memoryMetricsPanel = new JPanel(new BorderLayout());
            memoryMetricsPanel.setOpaque(true);
            memoryMetricsPanel.setBackground(Color.WHITE);
            memoryMetricsPanel.add((Component)memoryMetricsDataPanel, "North");
            memoryMetricsPanel.add((Component)((Object)this.memoryMetricsChart), "Center");
            memoryMetricsPanel.add((Component)memoryMetricsLegendContainer, "South");
            final boolean[] memoryMetricsPanelResizing = new boolean[]{false};
            memoryMetricsPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            memoryMetricsPanel.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    boolean shouldBeVisible;
                    if (memoryMetricsPanelResizing[0]) {
                        memoryMetricsPanelResizing[0] = false;
                        return;
                    }
                    boolean bl = shouldBeVisible = memoryMetricsPanel.getSize().height > 275;
                    if (shouldBeVisible == memoryMetricsDataPanel.isVisible()) {
                        return;
                    }
                    memoryMetricsPanelResizing[0] = true;
                    memoryMetricsDataPanel.setVisible(shouldBeVisible);
                }
            });
            this.add((Component)memoryMetricsPanel, "Center");
        }
    }

    private static class CpuLoadViewSupport
    extends JPanel {
        private boolean cpuMonitoringSupported;
        private ChartsSupport.Chart cpuMetricsChart;
        private HTMLLabel loadLabel;
        private static final NumberFormat formatter = NumberFormat.getNumberInstance();
        private static final int refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;
        private static final String LOAD_AVERAGE = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Load_average");

        public CpuLoadViewSupport(HostOverview hostOverview) {
            this.cpuMonitoringSupported = hostOverview.getSystemLoadAverage() >= 0.0;
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_CPU_load"), null, 10, (JComponent)this, null);
        }

        public void refresh(HostOverview hostOverview, long time) {
            if (this.cpuMonitoringSupported) {
                double load = hostOverview.getSystemLoadAverage();
                this.cpuMetricsChart.getModel().addItemValues(time, new long[]{(long)(load * 1000.0)});
                this.loadLabel.setText("<nobr><b>" + LOAD_AVERAGE + ":</b> " + formatter.format(load) + " </nobr>");
                this.cpuMetricsChart.setToolTipText("<html><nobr><b>" + LOAD_AVERAGE + ":</b> " + formatter.format(load) + " </nobr></html>");
            }
        }

        private void initComponents() {
            Object contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.cpuMonitoringSupported) {
                this.loadLabel = new HTMLLabel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, refLabelHeight);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.loadLabel.setText("<nobr><b>" + LOAD_AVERAGE + ":</b></nobr>");
                this.loadLabel.setOpaque(false);
                final JPanel cpuMetricsDataPanel = new JPanel(new GridLayout(1, 2));
                cpuMetricsDataPanel.setOpaque(false);
                cpuMetricsDataPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
                cpuMetricsDataPanel.add((Component)this.loadLabel);
                this.cpuMetricsChart = new ChartsSupport.CPUMetricsChart();
                this.cpuMetricsChart.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), this.cpuMetricsChart.getBorder()));
                JPanel cpuMetricsLegendContainer = new JPanel(new FlowLayout(4));
                cpuMetricsLegendContainer.setOpaque(false);
                cpuMetricsLegendContainer.add(this.cpuMetricsChart.getBigLegendPanel());
                final JPanel cpuMetricsPanel = new JPanel(new BorderLayout());
                cpuMetricsPanel.setOpaque(true);
                cpuMetricsPanel.setBackground(Color.WHITE);
                cpuMetricsPanel.add((Component)cpuMetricsDataPanel, "North");
                cpuMetricsPanel.add((Component)((Object)this.cpuMetricsChart), "Center");
                cpuMetricsPanel.add((Component)cpuMetricsLegendContainer, "South");
                final boolean[] cpuMetricsPanelResizing = new boolean[]{false};
                cpuMetricsPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
                cpuMetricsPanel.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent e) {
                        boolean shouldBeVisible;
                        if (cpuMetricsPanelResizing[0]) {
                            cpuMetricsPanelResizing[0] = false;
                            return;
                        }
                        boolean bl = shouldBeVisible = cpuMetricsPanel.getSize().height > 275;
                        if (shouldBeVisible == cpuMetricsDataPanel.isVisible()) {
                            return;
                        }
                        cpuMetricsPanelResizing[0] = true;
                        cpuMetricsDataPanel.setVisible(shouldBeVisible);
                    }
                });
                contents = cpuMetricsPanel;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.HOST);
            }
            this.add((Component)contents, "Center");
        }
    }

    private static class MasterViewSupport
    extends JPanel {
        public MasterViewSupport(Host host) {
            this.initComponents(host);
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Overview"), null, (JComponent)this);
        }

        private void initComponents(Host host) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            HTMLTextArea area = new HTMLTextArea("<nobr>" + this.getGeneralInfo(host) + "</nobr>");
            area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)area, "Center");
        }

        String getGeneralInfo(Host host) {
            HostOverview so = HostOverviewFactory.getSystemOverviewFor((Host)host);
            StringBuilder data = new StringBuilder();
            String hostIp = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Host_IP");
            data.append("<b>" + hostIp + ":</b> " + so.getHostAddress() + "<br>");
            String hostname = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Hostname");
            data.append("<b>" + hostname + ":</b> " + so.getHostName() + "<br><br>");
            String name = so.getName();
            String ver = so.getVersion();
            String patch = so.getPatchLevel();
            patch = "unknown".equals(patch) ? "" : patch;
            String os = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_OS");
            String arch = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Architecture");
            String proc = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Processors");
            String memory = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Total_memory_size");
            String swap = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Swap_size");
            String mb = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_MB");
            data.append("<b>" + os + ":</b> " + name + " (" + ver + ")" + " " + patch + "<br>");
            data.append("<b>" + arch + ":</b> " + so.getArch() + "<br>");
            data.append("<b>" + proc + ":</b> " + so.getAvailableProcessors() + "<br><br>");
            data.append("<b>" + memory + ":</b> " + this.formatBytes(so.getTotalPhysicalMemorySize()) + " " + mb + "<br>");
            data.append("<b>" + swap + ":</b> " + this.formatBytes(so.getTotalSwapSpaceSize()) + " " + mb + "<br>");
            return data.toString();
        }

        private String formatBytes(long l) {
            return NumberFormat.getInstance().format((double)(10L * l / 1024L / 1024L) / 10.0);
        }
    }
}

