/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;
import org.netbeans.lib.profiler.results.memory.SurvGenSet;

public class PresoObjLivenessCCTNode
extends PresoObjAllocCCTNode {
    static int currentEpoch;
    public static final int SORT_BY_LIVE_OBJ_SIZE = 1;
    public static final int SORT_BY_LIVE_OBJ_NUMBER = 2;
    public static final int SORT_BY_ALLOC_OBJ = 3;
    public static final int SORT_BY_AVG_AGE = 4;
    public static final int SORT_BY_SURV_GEN = 5;
    public static final int SORT_BY_NAME = 6;
    public static final int SORT_BY_TOTAL_ALLOC_OBJ = 7;
    private static boolean dontShowZeroLiveObjNodes;
    public float avgObjectAge;
    public int nLiveObjects;
    public int survGen;

    protected PresoObjLivenessCCTNode(RuntimeMemoryCCTNode rtNode) {
        super(rtNode);
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromSnapshot(LivenessMemoryResultsSnapshot snapshot, RuntimeMemoryCCTNode rootRuntimeNode, String classTypeName, int curEpoch, boolean dontShowZeroLiveObjAllocPaths) {
        currentEpoch = curEpoch;
        dontShowZeroLiveObjNodes = dontShowZeroLiveObjAllocPaths;
        SurvGenSet survGens = new SurvGenSet();
        PresoObjAllocCCTNode rootNode = PresoObjLivenessCCTNode.generateMirrorNode(rootRuntimeNode, survGens);
        if (rootNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromSnapshot(snapshot, rootNode, classTypeName);
        }
        return rootNode;
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode rootRuntimeNode, String classTypeName, int curEpoch, boolean dontShowZeroLiveObjAllocPaths) throws ClientUtils.TargetAppOrVMTerminated {
        currentEpoch = curEpoch;
        dontShowZeroLiveObjNodes = dontShowZeroLiveObjAllocPaths;
        SurvGenSet survGens = new SurvGenSet();
        PresoObjAllocCCTNode rootNode = PresoObjLivenessCCTNode.generateMirrorNode(rootRuntimeNode, survGens);
        if (rootNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromVM(profilerClient, rootNode, classTypeName);
        }
        return rootNode;
    }

    public void sortChildren(int sortBy, boolean sortOrder) {
        int nChildren = this.getNChildren();
        if (nChildren == 0) {
            return;
        }
        for (int i = 0; i < nChildren; ++i) {
            this.children[i].sortChildren(sortBy, sortOrder);
        }
        if (nChildren > 1) {
            switch (sortBy) {
                case 1: {
                    this.sortChildrenByLiveObjSize(sortOrder);
                    break;
                }
                case 2: {
                    this.sortChildrenByLiveObjNumber(sortOrder);
                    break;
                }
                case 3: {
                    this.sortChildrenByAllocObjNumber(sortOrder);
                    break;
                }
                case 4: {
                    this.sortChildrenByAvgAge(sortOrder);
                    break;
                }
                case 5: {
                    this.sortChildrenBySurvGen(sortOrder);
                    break;
                }
                case 6: {
                    this.sortChildrenByName(sortOrder);
                }
            }
        }
    }

    protected static PresoObjAllocCCTNode generateMirrorNode(RuntimeMemoryCCTNode rtNode, SurvGenSet survGens) {
        RuntimeMemoryCCTNode[] ar;
        int nChildren;
        Object nodeChildren;
        PresoObjLivenessCCTNode thisNode = null;
        if (rtNode instanceof RuntimeObjLivenessTermCCTNode) {
            RuntimeObjLivenessTermCCTNode rtTermNode = (RuntimeObjLivenessTermCCTNode)rtNode;
            int nLiveObjects = rtTermNode.calculateTotalNLiveObjects();
            if (dontShowZeroLiveObjNodes && nLiveObjects == 0 && rtNode.children == null) {
                return null;
            }
            thisNode = new PresoObjLivenessCCTNode(rtNode);
            thisNode.nLiveObjects = nLiveObjects;
            RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens(rtTermNode, survGens);
            thisNode.survGen = survGens.getTotalNoOfAges();
            thisNode.avgObjectAge = RuntimeObjLivenessTermCCTNode.calculateAvgObjectAgeForAllPaths(rtTermNode, currentEpoch);
            if (rtNode.children != null) {
                int len = rtNode.children instanceof RuntimeMemoryCCTNode ? 1 : ((RuntimeMemoryCCTNode[])rtNode.children).length;
                thisNode.children = new PresoObjAllocCCTNode[len];
            }
        }
        if ((nodeChildren = rtNode.children) != null && (nChildren = (ar = nodeChildren instanceof RuntimeMemoryCCTNode ? new RuntimeMemoryCCTNode[]{(RuntimeMemoryCCTNode)nodeChildren} : (RuntimeMemoryCCTNode[])nodeChildren).length) > 0) {
            double avgAge = 0.0;
            int childIdx = 0;
            for (int i = 0; i < nChildren; ++i) {
                SurvGenSet subNodeSurvGens = nChildren == 1 ? survGens : new SurvGenSet();
                PresoObjLivenessCCTNode child = (PresoObjLivenessCCTNode)PresoObjLivenessCCTNode.generateMirrorNode(ar[i], subNodeSurvGens);
                if (child == null) continue;
                if (thisNode == null) {
                    thisNode = new PresoObjLivenessCCTNode(rtNode);
                    thisNode.children = new PresoObjAllocCCTNode[nChildren];
                }
                thisNode.children[childIdx++] = child;
                child.parent = thisNode;
                thisNode.nCalls += child.nCalls;
                thisNode.totalObjSize += child.totalObjSize;
                thisNode.nLiveObjects += child.nLiveObjects;
                avgAge += (double)(child.avgObjectAge * (float)child.nLiveObjects);
                if (nChildren <= 1) continue;
                survGens.mergeWith(subNodeSurvGens);
            }
            if (dontShowZeroLiveObjNodes && (thisNode == null || thisNode.nLiveObjects == 0)) {
                return null;
            }
            if (childIdx < nChildren) {
                PresoObjAllocCCTNode[] newChildren = new PresoObjAllocCCTNode[childIdx];
                System.arraycopy(thisNode.children, 0, newChildren, 0, childIdx);
                thisNode.children = newChildren;
            }
            thisNode.avgObjectAge = thisNode.nLiveObjects > 0 ? (float)(avgAge / (double)thisNode.nLiveObjects) : 0.0f;
            thisNode.survGen = survGens.getTotalNoOfAges();
        }
        return thisNode;
    }

    protected void sortChildrenByAvgAge(boolean sortOrder) {
        int len = this.children.length;
        float[] values = new float[len];
        for (int i = 0; i < len; ++i) {
            values[i] = ((PresoObjLivenessCCTNode)this.children[i]).avgObjectAge;
        }
        this.sortFloats(values, sortOrder);
    }

    protected void sortChildrenByLiveObjNumber(boolean sortOrder) {
        int len = this.children.length;
        int[] values = new int[len];
        for (int i = 0; i < len; ++i) {
            values[i] = ((PresoObjLivenessCCTNode)this.children[i]).nLiveObjects;
        }
        this.sortInts(values, sortOrder);
    }

    protected void sortChildrenByLiveObjSize(boolean sortOrder) {
        this.sortChildrenByAllocObjSize(sortOrder);
    }

    protected void sortChildrenBySurvGen(boolean sortOrder) {
        int len = this.children.length;
        int[] values = new int[len];
        for (int i = 0; i < len; ++i) {
            values[i] = ((PresoObjLivenessCCTNode)this.children[i]).survGen;
        }
        this.sortInts(values, sortOrder);
    }
}

