/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.results.cpu.marking.MarkBasedNodeVisitor;

public class TimeCollector
extends MarkBasedNodeVisitor {
    private Map timing = new HashMap();

    public synchronized long getNetTime0(Mark mark) {
        if (this.isReset()) {
            return 0L;
        }
        TimingData currentTiming = (TimingData)this.timing.get(mark);
        long time = currentTiming != null ? (long)TimingAdjusterOld.getDefault().adjustTime(currentTiming.netTime0, currentTiming.inCalls, currentTiming.outCalls, false) : 0L;
        return time > 0L ? time : 0L;
    }

    public synchronized long getNetTime1(Mark mark) {
        if (this.isReset()) {
            return 0L;
        }
        TimingData currentTiming = (TimingData)this.timing.get(mark);
        long time = currentTiming != null ? (long)TimingAdjusterOld.getDefault().adjustTime(currentTiming.netTime1, currentTiming.inCalls, currentTiming.outCalls, true) : 0L;
        return time > 0L ? time : 0L;
    }

    public void beforeWalk() {
        super.beforeWalk();
        this.timing.clear();
    }

    public void endTrans() {
        if (this.isReset()) {
            this.timing = new HashMap();
        }
        super.endTrans();
    }

    public void visit(MethodCPUCCTNode node) {
        if (this.isReset()) {
            return;
        }
        Mark mark = this.getCurrentMark();
        Mark parentMark = this.getParentMark();
        if (mark != null) {
            TimingData data = (TimingData)this.timing.get(mark);
            if (data == null) {
                data = new TimingData();
                this.timing.put(mark, data);
            }
            data.inCalls += node.getNCalls();
            data.netTime0 += node.getNetTime0();
            data.netTime1 += node.getNetTime1();
        }
        if (parentMark != null) {
            TimingData parentData = (TimingData)this.timing.get(parentMark);
            if (parentData == null) {
                parentData = new TimingData();
                this.timing.put(parentMark, parentData);
            }
            parentData.outCalls += node.getNCalls();
        }
    }

    private static class TimingData {
        int inCalls;
        int outCalls;
        long netTime0;
        long netTime1;

        private TimingData() {
        }
    }
}

