/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;

class NearestGCRoot {
    private static final int BUFFER_SIZE = 8192;
    private Field referentFiled;
    private HprofHeap heap;
    private LongBuffer readBuffer;
    private LongBuffer writeBuffer;
    private Set referenceClasses;
    private boolean gcRootsComputed;

    NearestGCRoot(HprofHeap h) {
        this.heap = h;
    }

    synchronized Instance getNearestGCRootPointer(Instance instance) {
        if (this.heap.getGCRoot(instance) != null) {
            return instance;
        }
        long nextGCPathId = this.heap.idToOffsetMap.get(instance.getInstanceId()).getNearestGCRootPointer();
        if (nextGCPathId == 0L) {
            nextGCPathId = this.computeGCRootsFor(instance);
        }
        if (nextGCPathId != 0L) {
            return this.heap.getInstanceByID(nextGCPathId);
        }
        return null;
    }

    private boolean isWeakOrSoftReference(FieldValue value, Instance instance) {
        Field f = value.getField();
        return f.equals(this.referentFiled) && this.referenceClasses.contains(instance.getJavaClass());
    }

    private long computeGCRootsFor(Instance instance) {
        if (this.gcRootsComputed) {
            return 0L;
        }
        JavaClass weakRef = this.heap.getJavaClassByName("java.lang.ref.WeakReference");
        JavaClass softRef = this.heap.getJavaClassByName("java.lang.ref.SoftReference");
        this.referenceClasses = new HashSet();
        this.referenceClasses.add(weakRef);
        this.referenceClasses.addAll(weakRef.getSubClasses());
        this.referenceClasses.add(softRef);
        this.referenceClasses.addAll(softRef.getSubClasses());
        this.referentFiled = this.computeReferentFiled();
        try {
            this.createBuffers();
            this.fillZeroLevel();
            do {
                this.switchBuffers();
                this.computeOneLevel();
            } while (this.hasMoreLevels());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.deleteBuffers();
        this.gcRootsComputed = true;
        return this.heap.idToOffsetMap.get(instance.getInstanceId()).getNearestGCRootPointer();
    }

    private void computeOneLevel() throws IOException {
        long instanceId;
        while ((instanceId = this.readLong()) != 0L) {
            List fieldValues;
            Instance refInstance;
            Instance instance = this.heap.getInstanceByID(instanceId);
            if (instance instanceof ObjectArrayInstance) {
                Iterator instanceIt = ((ObjectArrayInstance)instance).getValues().iterator();
                while (instanceIt.hasNext()) {
                    refInstance = (Instance)instanceIt.next();
                    this.writeConnection(instanceId, refInstance);
                }
                continue;
            }
            if (instance instanceof PrimitiveArrayInstance) continue;
            if (instance instanceof ClassDumpInstance) {
                ClassDump javaClass = ((ClassDumpInstance)instance).classDump;
                fieldValues = javaClass.getStaticFieldValues();
            } else if (instance instanceof InstanceDump) {
                fieldValues = instance.getFieldValues();
            } else {
                if (instance == null) {
                    System.err.println("HeapWalker Warning - null instance for " + instanceId);
                    continue;
                }
                throw new IllegalArgumentException("Illegal type " + instance.getClass());
            }
            Iterator valuesIt = fieldValues.iterator();
            while (valuesIt.hasNext()) {
                FieldValue val = (FieldValue)valuesIt.next();
                if (!(val instanceof ObjectFieldValue) || this.isWeakOrSoftReference(val, instance)) continue;
                refInstance = ((ObjectFieldValue)val).getInstance();
                this.writeConnection(instanceId, refInstance);
            }
        }
    }

    private Field computeReferentFiled() {
        JavaClass reference = this.heap.getJavaClassByName("java.lang.ref.Reference");
        Iterator fieldRef = reference.getFields().iterator();
        while (fieldRef.hasNext()) {
            Field f = (Field)fieldRef.next();
            if (!f.getName().equals("referent")) continue;
            return f;
        }
        throw new IllegalArgumentException("reference field not found in " + reference.getName());
    }

    private void createBuffers() {
        this.readBuffer = new LongBuffer(8192);
        this.writeBuffer = new LongBuffer(8192);
    }

    private void deleteBuffers() {
        this.readBuffer.delete();
        this.writeBuffer.delete();
    }

    private void fillZeroLevel() throws IOException {
        Iterator gcIt = this.heap.getGCRoots().iterator();
        while (gcIt.hasNext()) {
            HprofGCRoot root = (HprofGCRoot)gcIt.next();
            this.writeLong(root.getInstanceId());
        }
    }

    private boolean hasMoreLevels() {
        return this.writeBuffer.hasData();
    }

    private long readLong() throws IOException {
        return this.readBuffer.readLong();
    }

    private void switchBuffers() {
        LongBuffer b = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = b;
        this.readBuffer.startReading();
        this.writeBuffer.reset();
    }

    private void writeConnection(long instanceId, Instance refInstance) throws IOException {
        long refInstanceId;
        LongMap.Entry entry;
        if (refInstance != null && (entry = this.heap.idToOffsetMap.get(refInstanceId = refInstance.getInstanceId())).getNearestGCRootPointer() == 0L) {
            this.writeLong(refInstanceId);
            entry.setNearestGCRootPointer(instanceId);
        }
    }

    private void writeLong(long instanceId) throws IOException {
        this.writeBuffer.writeLong(instanceId);
    }
}

