/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

class LongMap {
    File tempFile;
    private final int KEY_SIZE;
    private final int VALUE_SIZE;
    private final int ENTRY_SIZE;
    private final int ID_SIZE;
    private final int FOFFSET_SIZE;
    private Data dumpBuffer;
    private long fileSize;
    private long keys;
    static final /* synthetic */ boolean $assertionsDisabled;

    LongMap(int size, int idSize, int foosetSize) throws FileNotFoundException, IOException {
        if (!$assertionsDisabled && idSize != 4 && idSize != 8) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && foosetSize != 4 && foosetSize != 8) {
            throw new AssertionError();
        }
        this.keys = (long)size * 4L / 3L;
        this.ID_SIZE = idSize;
        this.FOFFSET_SIZE = foosetSize;
        this.KEY_SIZE = this.ID_SIZE;
        this.VALUE_SIZE = this.FOFFSET_SIZE + 4 + this.ID_SIZE;
        this.ENTRY_SIZE = this.KEY_SIZE + this.VALUE_SIZE;
        this.fileSize = this.keys * (long)this.ENTRY_SIZE;
        this.tempFile = File.createTempFile("NBProfiler", ".map");
        byte[] zeros = new byte[524288];
        RandomAccessFile file = new RandomAccessFile(this.tempFile, "rw");
        while (file.length() < this.fileSize) {
            file.write(zeros);
        }
        file.setLength(this.fileSize);
        this.setDumpBuffer(file);
        this.tempFile.deleteOnExit();
    }

    protected void finalize() throws Throwable {
        this.tempFile.delete();
        super.finalize();
    }

    Entry get(long key) {
        long index = this.getIndex(key);
        long mapKey;
        while ((mapKey = this.getID(index)) != key) {
            if (mapKey == 0L) {
                return null;
            }
            index = this.getNextIndex(index);
        }
        return new Entry(index);
    }

    void put(long key, long value) {
        long index = this.getIndex(key);
        while (true) {
            if (this.getID(index) == 0L) {
                this.putID(index, key);
                this.putFoffset(index + (long)this.KEY_SIZE, value);
                return;
            }
            index = this.getNextIndex(index);
        }
    }

    private void setDumpBuffer(RandomAccessFile file) throws IOException {
        long length = file.length();
        try {
            this.dumpBuffer = length > Integer.MAX_VALUE ? new FileData(file, length) : new MemoryMappedData(file, length);
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof OutOfMemoryError) {
                this.dumpBuffer = new FileData(file, length);
            }
            throw ex;
        }
    }

    private long getID(long index) {
        if (this.ID_SIZE == 4) {
            return this.dumpBuffer.getInt(index);
        }
        return this.dumpBuffer.getLong(index);
    }

    private void putID(long index, long key) {
        if (this.ID_SIZE == 4) {
            this.dumpBuffer.putInt(index, (int)key);
        } else {
            this.dumpBuffer.putLong(index, key);
        }
    }

    private long getFoffset(long index) {
        if (this.FOFFSET_SIZE == 4) {
            return this.dumpBuffer.getInt(index);
        }
        return this.dumpBuffer.getLong(index);
    }

    private void putFoffset(long index, long key) {
        if (this.FOFFSET_SIZE == 4) {
            this.dumpBuffer.putInt(index, (int)key);
        } else {
            this.dumpBuffer.putLong(index, key);
        }
    }

    private long getIndex(long key) {
        long hash = key & Long.MAX_VALUE;
        return hash % this.keys * (long)this.ENTRY_SIZE;
    }

    private long getNextIndex(long index) {
        if ((index += (long)this.ENTRY_SIZE) >= this.fileSize) {
            index = 0L;
        }
        return index;
    }

    static {
        $assertionsDisabled = !LongMap.class.desiredAssertionStatus();
    }

    class MemoryMappedData
    implements Data {
        MappedByteBuffer buf;

        MemoryMappedData(RandomAccessFile file, long length) throws IOException {
            FileChannel channel = file.getChannel();
            this.buf = channel.map(FileChannel.MapMode.READ_WRITE, 0L, length);
            channel.close();
        }

        public int getInt(long index) {
            return this.buf.getInt((int)index);
        }

        public long getLong(long index) {
            return this.buf.getLong((int)index);
        }

        public void putInt(long index, int data) {
            this.buf.putInt((int)index, data);
        }

        public void putLong(long index, long data) {
            this.buf.putLong((int)index, data);
        }
    }

    class FileData
    implements Data {
        RandomAccessFile file;
        byte[] buf;
        boolean bufferModified;
        long offset;
        final int BUFFER_SIZE = 128;

        FileData(RandomAccessFile f, long length) throws IOException {
            this.file = f;
            this.buf = new byte[LongMap.this.ENTRY_SIZE * 128];
        }

        public synchronized int getInt(long index) {
            int i = this.loadBufferIfNeeded(index);
            int ch1 = this.buf[i++] & 0xFF;
            int ch2 = this.buf[i++] & 0xFF;
            int ch3 = this.buf[i++] & 0xFF;
            int ch4 = this.buf[i] & 0xFF;
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }

        public synchronized long getLong(long index) {
            int i = this.loadBufferIfNeeded(index);
            return ((long)this.buf[i++] << 56) + ((long)(this.buf[i++] & 0xFF) << 48) + ((long)(this.buf[i++] & 0xFF) << 40) + ((long)(this.buf[i++] & 0xFF) << 32) + ((long)(this.buf[i++] & 0xFF) << 24) + (long)((this.buf[i++] & 0xFF) << 16) + (long)((this.buf[i++] & 0xFF) << 8) + (long)((this.buf[i++] & 0xFF) << 0);
        }

        public synchronized void putInt(long index, int data) {
            int i = this.loadBufferIfNeeded(index);
            this.buf[i++] = (byte)(data >>> 24);
            this.buf[i++] = (byte)(data >>> 16);
            this.buf[i++] = (byte)(data >>> 8);
            this.buf[i++] = (byte)(data >>> 0);
            this.bufferModified = true;
        }

        public synchronized void putLong(long index, long data) {
            int i = this.loadBufferIfNeeded(index);
            this.buf[i++] = (byte)(data >>> 56);
            this.buf[i++] = (byte)(data >>> 48);
            this.buf[i++] = (byte)(data >>> 40);
            this.buf[i++] = (byte)(data >>> 32);
            this.buf[i++] = (byte)(data >>> 24);
            this.buf[i++] = (byte)(data >>> 16);
            this.buf[i++] = (byte)(data >>> 8);
            this.buf[i++] = (byte)(data >>> 0);
            this.bufferModified = true;
        }

        private int loadBufferIfNeeded(long index) {
            int i = (int)(index % (long)(LongMap.this.ENTRY_SIZE * 128));
            long newOffset = index - (long)i;
            if (this.offset != newOffset) {
                try {
                    if (this.bufferModified) {
                        this.file.seek(this.offset);
                        this.file.write(this.buf, 0, this.getBufferSize(this.offset));
                        this.bufferModified = false;
                    }
                    this.file.seek(newOffset);
                    this.file.readFully(this.buf, 0, this.getBufferSize(newOffset));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.offset = newOffset;
            }
            return i;
        }

        private int getBufferSize(long off) {
            int size = this.buf.length;
            if (LongMap.this.fileSize - off < (long)this.buf.length) {
                size = (int)(LongMap.this.fileSize - off);
            }
            return size;
        }
    }

    class Entry {
        private long offset;

        private Entry(long off) {
            this.offset = off;
        }

        void setIndex(int index) {
            LongMap.this.dumpBuffer.putInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE, index);
        }

        int getIndex() {
            return LongMap.this.dumpBuffer.getInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE);
        }

        void setNearestGCRootPointer(long instanceId) {
            LongMap.this.putID(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L, instanceId);
        }

        long getNearestGCRootPointer() {
            return LongMap.this.getID(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L);
        }

        long getOffset() {
            return LongMap.this.getFoffset(this.offset + (long)LongMap.this.KEY_SIZE);
        }
    }

    static interface Data {
        public int getInt(long var1);

        public long getLong(long var1);

        public void putInt(long var1, int var3);

        public void putLong(long var1, long var3);
    }
}

