.TH GXDITVIEW @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.
.
.SH NAME
gxditview \- display groff intermediate output files
.
.
.SH SYNOPSIS
.B \%gxditview
.RI [\fB\- toolkitoption\  .\|.\|.\|]
.RI [\fB\- option\  .\|.\|.\|]
.RI [ filename ]
.
.
.SH DESCRIPTION
The
.B \%gxditview 
program displays the
.I groff intermediate
.IR output ,
see
.BR groff_out (@MAN5EXT@),
on an X\~display.
.
It uses the standard X11 fonts, so it does not require access to the
server machine for font loading.
.
There are several ways to use
.BR \%gxditview .
.
.
.PP
The
.I groff intermediate output
can be generated by
.BR groff\~\-Z .
This can be viewed by explicity calling
.B \%gxditview
.IR \%filename .
If
.I filename
is
.BR \- ,
.B \%gxditview
will read the standard input;
.I \%filename
cannot be omitted.
.
The
.I groff intermediate output
is different for all devices.
.
.B \%gxditview
can view it for all devices, but the quality is not always good.
.
.
.PP
The best result is achieved with the
.BR X *
devices for
.BR groff 's
option
.BR \-T .
.
There are four
.BR X *
devices:
.BR \%\-TX75 ,
.BR \%\-TX75\-12 ,
.BR \%\-TX100 ,
.BR \%\-TX100\-12 .
They differ by the X\~resolution (75dpi or 100dpi) and the used base font
size (10pt or 12pt).
.
They are especially built for
.BR \%gxditview .
When using one of them
.B groff
generates the
.I intermediate output
for this device and calls
.B \%gxditview
automatically for viewing.
.
.
.PP
.BR groff 's
option
.B \-X
should be considered obsolete today; it produces
.I intermediate output
for
.I Postscript
and uses
.B \%gxditview
as a viewer for it, but with a bad quality.
.
Simply don't use it.
.
.
.PP
During the run of
.BR \%gxditview ,
the left mouse button brings up a menu with the following entries:
.
.TP 8
.B "Next Page"
Display the next page.
.
.TP
.B "Previous Page"
Display the previous page.
.
.TP
.B "Select Page"
Select a particular numbered page specified by a dialog box.
.
.TP
.B Print
Print the
.I groff intermediate output
using a command specified by a dialog box.
.
The default command initially displayed is controlled by the
.B printCommand
application resource, and by the
.B \-printCommand
option.
.
.TP
.B Open
Open for display a new file specified by a dialog box.
.
The file should contain some
.I groff intermediate
.IR output .
If the filename starts with
.B |
it will be taken to be a command to read from.
.
.TP
.B Quit
Exit from
.BR \%gxditview .
.
.
.PP
The
.IR n ,
.I Space
and
.I Return
keys are bound to the
.B Next\ Page
action.
.
The
.IR p ,
.I BackSpace
and
.I Delete
keys are bound to the
.B Previous\ Page
action.
.
The
.I q
key is bound to the
.B Quit
action.
.
The
.I r
key is bound to the
.B Rerasterize
action which rereads the current file, and redisplays the current
page; if the current file is a command, the command will be
reexecuted.
.
.
.PP
The
.B paperlength
and
.B paperwidth
commands in the DESC file specify the length and width in machine units
of the virtual page displayed by
.BR \%gxditview .
.
.
.SH OPTIONS
The
.B \%gxditview
program accepts all of the standard X\~Toolkit command line options
along with the additional options listed below:
.
.TP 8
.B \-help
This option indicates that a brief summary of the allowed options should be
printed.
.
.TP
.B \-page
This option specifies the page number of the document to be displayed.
.
.TP
.BI \-backingStore\  backing-store-type
Redisplay of the
.I groff intermediate output
window can take up to a second or so, this option causes the server to
save the window contents so that when it is scrolled around the
viewport, the window is painted from contents saved in backing store.
.I backing-store-type
can be one of
.BR Always ,
.B WhenMapped
or 
.BR NotUseful .
.
.TP
.BI \-printCommand\  command
The default command displayed in the dialog box for the
.B Print
menu entry will be
.IR command .
.
.TP
.BI \-resolution\  res
The
.I groff intermediate output
file will be displayed at a resolution of
.I res
dpi, unless the DESC file contains the
.B X11
command, in which case the device resolution will be used.
.
This corresponds to the
.I Dvi
widget's
.B resolution
resource.
.
The default is 75.
.
.TP
.BI \-filename\  string
The default filename displayed in the dialog box for the
.B Open
menu entry will be
.IR string .
This can be either a filename, or a command starting with
.BR | .
.
.
.PP
The following standard X\~Toolkit command line arguments are commonly used
with 
.BR \%gxditview :
.
.TP 8
.BI \-bg\  color
This option specifies the color to use for the background of the window.  
.
The default is \fIwhite\fP.
.
.TP
.BI \-bd\  color
This option specifies the color to use for the border of the window.
.
The default is \fIblack\fP.
.
.TP
.BI \-bw\  number
This option specifies the width in pixels of the border surrounding the
window.
.
.TP
.BI \-fg\  color
This option specifies the color to use for displaying text.
.
The default is 
\fIblack\fP.
.
.TP
.BI \-fn\  font
This option specifies the font to be used for displaying widget text.
.
The default is \fIfixed\fP.
.
.TP
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.
.TP
.BI \-geometry\  geometry
This option specifies the preferred size and position of the window.
.
.TP
.BI \-display\  host : display
This option specifies the X\~server to contact.
.
.TP
.BI \-xrm\  resourcestring
This option specifies a resource string to be used.
.
.
.SH X DEFAULTS
This program uses the 
.I Dvi
widget in the X\~Toolkit.
.
It understands all of the core resource names and classes as well as:
.
.TP 8
.BR width\  (class\  Width )
Specifies the width of the window.
.
.TP
.BR height\  (class\  Height )
Specifies the height of the window.
.
.TP
.BR foreground\  (class\  Foreground )
Specifies the default foreground color.
.
.TP
.BR font\  (class\  Font )
Specifies the font to be used for error messages.
.
.TP
.BR fontMap\  (class\  FontMap )
Specifies the mapping from
.I groff
font names to X\~font names.
.
This must be a string containing a sequence of lines.
.
Each line contains two whitespace separated fields: first the
.I groff
font name, and secondly the X\~font name.
.
The default is
.nf
"\e
TR	-adobe-times-medium-r-normal--*-100-*-*-*-*-iso8859-1\en\e
TI	-adobe-times-medium-i-normal--*-100-*-*-*-*-iso8859-1\en\e
TB	-adobe-times-bold-r-normal--*-100-*-*-*-*-iso8859-1\en\e
TBI	-adobe-times-bold-i-normal--*-100-*-*-*-*-iso8859-1\en\e
CR	-adobe-courier-medium-r-normal--*-100-*-*-*-*-iso8859-1\en\e
CI	-adobe-courier-medium-o-normal--*-100-*-*-*-*-iso8859-1\en\e
CB	-adobe-courier-bold-r-normal--*-100-*-*-*-*-iso8859-1\en\e
CBI	-adobe-courier-bold-o-normal--*-100-*-*-*-*-iso8859-1\en\e
HR	-adobe-helvetica-medium-r-normal--*-100-*-*-*-*-iso8859-1\en\e
HI	-adobe-helvetica-medium-o-normal--*-100-*-*-*-*-iso8859-1\en\e
HB	-adobe-helvetica-bold-r-normal--*-100-*-*-*-*-iso8859-1\en\e
HBI	-adobe-helvetica-bold-o-normal--*-100-*-*-*-*-iso8859-1\en\e
NR	-adobe-new century schoolbook-medium-r-normal--*-100-*-*-*-*-iso8859-1\en\e
NI	-adobe-new century schoolbook-medium-i-normal--*-100-*-*-*-*-iso8859-1\en\e
NB	-adobe-new century schoolbook-bold-r-normal--*-100-*-*-*-*-iso8859-1\en\e
NBI	-adobe-new century schoolbook-bold-i-normal--*-100-*-*-*-*-iso8859-1\en\e
S	-adobe-symbol-medium-r-normal--*-100-*-*-*-*-adobe-fontspecific\en\e
SS	-adobe-symbol-medium-r-normal--*-100-*-*-*-*-adobe-fontspecific\en\e
"
.fi
.
.
.SH "SEE ALSO"
.BR X (1),
.BR xrdb (1),
.BR xditview (1),
.BR groff (@MAN1EXT@),
.BR groff_out (@MAN5EXT@)
.
.
.SH ORIGIN
This program is derived from
.BR \%xditview ;
portions of
.B \%xditview
originated in
.B \%xtroff
which was derived from
.BR \%suntroff .
.
.
.SH COPYRIGHT
Copyright 1989, Massachusetts Institute of Technology.
.br
See
.BR X (1)
for a full statement of rights and permissions.
.
.
.SH AUTHORS
Keith Packard (MIT X Consortium)
.br
Richard L. Hyde (Purdue)
.br
David Slattengren (Berkeley)
.br
Malcolm Slaney (Schlumberger Palo Alto Research)
.br
Mark Moraes (University of Toronto)
.br
James Clark
.
.\" Local Variables:
.\" mode: nroff
.\" End:
