/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.InvalidObjectException;
import java.text.DontCareFieldPosition;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TimeZone;
import sun.util.LocaleServiceProviderPool;

public abstract class DateFormat
extends Format {
    protected Calendar calendar;
    protected NumberFormat numberFormat;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;
    private static final long serialVersionUID = 7218322306649953788L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format(new Date(((Number)object).longValue()), stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Date");
    }

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    public final String format(Date date) {
        return this.format(date, new StringBuffer(), DontCareFieldPosition.INSTANCE).toString();
    }

    public Date parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parse(string, parsePosition);
        if (parsePosition.index == 0) {
            throw new ParseException("Unparseable date: \"" + string + "\"", parsePosition.errorIndex);
        }
        return date;
    }

    public abstract Date parse(String var1, ParsePosition var2);

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public static final DateFormat getTimeInstance() {
        return DateFormat.get(2, 0, 1, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int n) {
        return DateFormat.get(n, 0, 1, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int n, Locale locale) {
        return DateFormat.get(n, 0, 1, locale);
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.get(0, 2, 2, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int n) {
        return DateFormat.get(0, n, 2, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int n, Locale locale) {
        return DateFormat.get(0, n, 2, locale);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.get(2, 2, 3, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int n, int n2) {
        return DateFormat.get(n2, n, 3, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
        return DateFormat.get(n2, n, 3, locale);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    public static Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(DateFormatProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public void setLenient(boolean bl) {
        this.calendar.setLenient(bl);
    }

    public boolean isLenient() {
        return this.calendar.isLenient();
    }

    public int hashCode() {
        return this.numberFormat.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DateFormat dateFormat = (DateFormat)object;
        return this.calendar.getFirstDayOfWeek() == dateFormat.calendar.getFirstDayOfWeek() && this.calendar.getMinimalDaysInFirstWeek() == dateFormat.calendar.getMinimalDaysInFirstWeek() && this.calendar.isLenient() == dateFormat.calendar.isLenient() && this.calendar.getTimeZone().equals(dateFormat.calendar.getTimeZone()) && this.numberFormat.equals(dateFormat.numberFormat);
    }

    public Object clone() {
        DateFormat dateFormat = (DateFormat)super.clone();
        dateFormat.calendar = (Calendar)this.calendar.clone();
        dateFormat.numberFormat = (NumberFormat)this.numberFormat.clone();
        return dateFormat;
    }

    private static DateFormat get(int n, int n2, int n3, Locale locale) {
        if ((n3 & 1) != 0) {
            if (n < 0 || n > 3) {
                throw new IllegalArgumentException("Illegal time style " + n);
            }
        } else {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            if (n2 < 0 || n2 > 3) {
                throw new IllegalArgumentException("Illegal date style " + n2);
            }
        } else {
            n2 = -1;
        }
        try {
            DateFormat dateFormat;
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(DateFormatProvider.class);
            if (localeServiceProviderPool.hasProviders() && (dateFormat = localeServiceProviderPool.getLocalizedObject(DateFormatGetter.INSTANCE, locale, n, n2, n3)) != null) {
                return dateFormat;
            }
            return new SimpleDateFormat(n, n2, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return new SimpleDateFormat("M/d/yy h:mm a");
        }
    }

    protected DateFormat() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateFormatGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<DateFormatProvider, DateFormat> {
        private static final DateFormatGetter INSTANCE = new DateFormatGetter();

        private DateFormatGetter() {
        }

        @Override
        public DateFormat getObject(DateFormatProvider dateFormatProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 3);
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            int n3 = (Integer)objectArray[2];
            switch (n3) {
                case 1: {
                    return dateFormatProvider.getTimeInstance(n, locale);
                }
                case 2: {
                    return dateFormatProvider.getDateInstance(n2, locale);
                }
                case 3: {
                    return dateFormatProvider.getDateTimeInstance(n2, n, locale);
                }
            }
            assert (false) : "should not happen";
            return null;
        }
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7441350119349544720L;
        private static final Map instanceMap = new HashMap(18);
        private static final Field[] calendarToFieldMapping = new Field[17];
        private int calendarField;
        public static final Field ERA = new Field("era", 0);
        public static final Field YEAR = new Field("year", 1);
        public static final Field MONTH = new Field("month", 2);
        public static final Field DAY_OF_MONTH = new Field("day of month", 5);
        public static final Field HOUR_OF_DAY1 = new Field("hour of day 1", -1);
        public static final Field HOUR_OF_DAY0 = new Field("hour of day", 11);
        public static final Field MINUTE = new Field("minute", 12);
        public static final Field SECOND = new Field("second", 13);
        public static final Field MILLISECOND = new Field("millisecond", 14);
        public static final Field DAY_OF_WEEK = new Field("day of week", 7);
        public static final Field DAY_OF_YEAR = new Field("day of year", 6);
        public static final Field DAY_OF_WEEK_IN_MONTH = new Field("day of week in month", 8);
        public static final Field WEEK_OF_YEAR = new Field("week of year", 3);
        public static final Field WEEK_OF_MONTH = new Field("week of month", 4);
        public static final Field AM_PM = new Field("am pm", 9);
        public static final Field HOUR1 = new Field("hour 1", -1);
        public static final Field HOUR0 = new Field("hour", 10);
        public static final Field TIME_ZONE = new Field("time zone", -1);

        public static Field ofCalendarField(int n) {
            if (n < 0 || n >= calendarToFieldMapping.length) {
                throw new IllegalArgumentException("Unknown Calendar constant " + n);
            }
            return calendarToFieldMapping[n];
        }

        protected Field(String string, int n) {
            super(string);
            this.calendarField = n;
            if (this.getClass() == Field.class) {
                instanceMap.put(string, this);
                if (n >= 0) {
                    Field.calendarToFieldMapping[n] = this;
                }
            }
        }

        public int getCalendarField() {
            return this.calendarField;
        }

        protected Object readResolve() throws InvalidObjectException {
            if (this.getClass() != Field.class) {
                throw new InvalidObjectException("subclass didn't correctly implement readResolve");
            }
            Object v = instanceMap.get(this.getName());
            if (v != null) {
                return v;
            }
            throw new InvalidObjectException("unknown attribute name");
        }
    }
}

