/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.parser;

import com.sun.xml.internal.ws.model.ParameterBinding;
import com.sun.xml.internal.ws.server.DocInfo;
import com.sun.xml.internal.ws.streaming.TidyXMLStreamReader;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.parser.Binding;
import com.sun.xml.internal.ws.wsdl.parser.BindingOperation;
import com.sun.xml.internal.ws.wsdl.parser.MIMEConstants;
import com.sun.xml.internal.ws.wsdl.parser.Message;
import com.sun.xml.internal.ws.wsdl.parser.ParserUtil;
import com.sun.xml.internal.ws.wsdl.parser.Port;
import com.sun.xml.internal.ws.wsdl.parser.PortType;
import com.sun.xml.internal.ws.wsdl.parser.PortTypeOperation;
import com.sun.xml.internal.ws.wsdl.parser.SOAPConstants;
import com.sun.xml.internal.ws.wsdl.parser.Service;
import com.sun.xml.internal.ws.wsdl.parser.WSDLConstants;
import com.sun.xml.internal.ws.wsdl.parser.WSDLDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeWSDLParser {
    private final WSDLDocument wsdlDoc = new WSDLDocument();
    private String targetNamespace;
    private final Set<String> importedWSDLs = new HashSet<String>();
    private final EntityResolver resolver;

    public static WSDLDocument parse(URL uRL, EntityResolver entityResolver) throws IOException, XMLStreamException, SAXException {
        assert (entityResolver != null);
        RuntimeWSDLParser runtimeWSDLParser = new RuntimeWSDLParser(entityResolver);
        runtimeWSDLParser.parseWSDL(uRL);
        return runtimeWSDLParser.wsdlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillDocInfo(DocInfo docInfo, QName qName, QName qName2) throws XMLStreamException {
        RuntimeWSDLParser runtimeWSDLParser = new RuntimeWSDLParser(null);
        InputSource inputSource = new InputSource(docInfo.getDoc());
        XMLStreamReader xMLStreamReader = RuntimeWSDLParser.createReader(inputSource);
        try {
            Object object;
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            if (xMLStreamReader.getName().equals(WSDLConstants.QNAME_SCHEMA)) {
                docInfo.setDocType(DocInfo.DOC_TYPE.SCHEMA);
                String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "targetNamespace");
                docInfo.setTargetNamespace(string);
                return;
            }
            if (xMLStreamReader.getName().equals(WSDLConstants.QNAME_DEFINITIONS)) {
                docInfo.setDocType(DocInfo.DOC_TYPE.WSDL);
                object = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "targetNamespace");
                runtimeWSDLParser.targetNamespace = object;
                docInfo.setTargetNamespace((String)object);
            } else {
                docInfo.setDocType(DocInfo.DOC_TYPE.OTHER);
                return;
            }
            while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
                String string;
                if (xMLStreamReader.getEventType() == 8) {
                    break;
                }
                object = xMLStreamReader.getName();
                if (WSDLConstants.QNAME_PORT_TYPE.equals(object)) {
                    string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
                    if (qName2 != null && qName2.getLocalPart().equals(string) && qName2.getNamespaceURI().equals(docInfo.getTargetNamespace())) {
                        docInfo.setHavingPortType(true);
                    }
                    XMLStreamReaderUtil.skipElement(xMLStreamReader);
                    continue;
                }
                if (WSDLConstants.QNAME_SERVICE.equals(object)) {
                    string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
                    QName qName3 = new QName(docInfo.getTargetNamespace(), string);
                    if (qName.equals(qName3)) {
                        runtimeWSDLParser.parseService(xMLStreamReader);
                        docInfo.setService(runtimeWSDLParser.wsdlDoc.getService(qName3));
                        if (xMLStreamReader.getEventType() == 2) continue;
                        XMLStreamReaderUtil.next(xMLStreamReader);
                        continue;
                    }
                    XMLStreamReaderUtil.skipElement(xMLStreamReader);
                    continue;
                }
                XMLStreamReaderUtil.skipElement(xMLStreamReader);
            }
        }
        finally {
            xMLStreamReader.close();
        }
    }

    private RuntimeWSDLParser(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    private static XMLStreamReader createReader(InputSource inputSource) {
        if (inputSource.getCharacterStream() != null) {
            Reader reader = inputSource.getCharacterStream();
            return new TidyXMLStreamReader(XMLStreamReaderFactory.createFreshXMLStreamReader(inputSource.getSystemId(), reader), reader);
        }
        if (inputSource.getByteStream() != null) {
            InputStream inputStream = inputSource.getByteStream();
            return new TidyXMLStreamReader(XMLStreamReaderFactory.createFreshXMLStreamReader(inputSource.getSystemId(), inputStream), inputStream);
        }
        try {
            InputStream inputStream = new URL(inputSource.getSystemId()).openStream();
            return new TidyXMLStreamReader(XMLStreamReaderFactory.createFreshXMLStreamReader(inputSource.getSystemId(), inputStream), inputStream);
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    private void parseWSDL(URL uRL) throws XMLStreamException, IOException, SAXException {
        InputSource inputSource = this.resolver.resolveEntity(null, uRL.toExternalForm());
        if (inputSource == null) {
            inputSource = new InputSource(uRL.toExternalForm());
        } else if (inputSource.getSystemId() == null) {
            inputSource.setSystemId(uRL.toExternalForm());
        }
        if (!this.importedWSDLs.add(inputSource.getSystemId())) {
            return;
        }
        XMLStreamReader xMLStreamReader = RuntimeWSDLParser.createReader(inputSource);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        if (!xMLStreamReader.getName().equals(WSDLConstants.QNAME_DEFINITIONS)) {
            ParserUtil.failWithFullName("runtime.parser.wsdl.invalidElement", xMLStreamReader);
        }
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "targetNamespace");
        String string2 = this.targetNamespace;
        this.targetNamespace = string;
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2 && xMLStreamReader.getEventType() != 8) {
            QName qName = xMLStreamReader.getName();
            if (WSDLConstants.QNAME_IMPORT.equals(qName)) {
                this.parseImport(uRL, xMLStreamReader);
                continue;
            }
            if (WSDLConstants.QNAME_MESSAGE.equals(qName)) {
                this.parseMessage(xMLStreamReader);
                continue;
            }
            if (WSDLConstants.QNAME_PORT_TYPE.equals(qName)) {
                this.parsePortType(xMLStreamReader);
                continue;
            }
            if (WSDLConstants.QNAME_BINDING.equals(qName)) {
                this.parseBinding(xMLStreamReader);
                continue;
            }
            if (WSDLConstants.QNAME_SERVICE.equals(qName)) {
                this.parseService(xMLStreamReader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
        this.targetNamespace = string2;
        xMLStreamReader.close();
    }

    private void parseService(XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        Service service = new Service(new QName(this.targetNamespace, string));
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (WSDLConstants.QNAME_PORT.equals(qName)) {
                RuntimeWSDLParser.parsePort(xMLStreamReader, service);
                if (xMLStreamReader.getEventType() == 2) continue;
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
        this.wsdlDoc.addService(service);
    }

    private static void parsePort(XMLStreamReader xMLStreamReader, Service service) {
        QName qName;
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        String string2 = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "binding");
        QName qName2 = ParserUtil.getQName(xMLStreamReader, string2);
        String string3 = null;
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            qName = xMLStreamReader.getName();
            if (SOAPConstants.QNAME_ADDRESS.equals(qName) || SOAPConstants.QNAME_SOAP12ADDRESS.equals(qName)) {
                string3 = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "location");
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
        qName = new QName(service.getName().getNamespaceURI(), string);
        service.put(qName, new Port(qName, qName2, string3));
    }

    private void parseBinding(XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        String string2 = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "type");
        if (string == null || string2 == null) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            return;
        }
        Binding binding = new Binding(new QName(this.targetNamespace, string), ParserUtil.getQName(xMLStreamReader, string2));
        binding.setWsdlDocument(this.wsdlDoc);
        this.wsdlDoc.addBinding(binding);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (WSDLConstants.NS_SOAP_BINDING.equals(qName)) {
                binding.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/http");
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            if (WSDLConstants.NS_SOAP12_BINDING.equals(qName)) {
                binding.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/");
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            if (WSDLConstants.QNAME_OPERATION.equals(qName)) {
                RuntimeWSDLParser.parseBindingOperation(xMLStreamReader, binding);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private static void parseBindingOperation(XMLStreamReader xMLStreamReader, Binding binding) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        if (string == null) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            return;
        }
        BindingOperation bindingOperation = new BindingOperation(string);
        binding.put(string, bindingOperation);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (WSDLConstants.QNAME_INPUT.equals(qName)) {
                RuntimeWSDLParser.parseInputBinding(xMLStreamReader, bindingOperation);
                continue;
            }
            if (WSDLConstants.QNAME_OUTPUT.equals(qName)) {
                RuntimeWSDLParser.parseOutputBinding(xMLStreamReader, bindingOperation);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private static void parseInputBinding(XMLStreamReader xMLStreamReader, BindingOperation bindingOperation) {
        boolean bl = false;
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if ((SOAPConstants.QNAME_BODY.equals(qName) || SOAPConstants.QNAME_SOAP12BODY.equals(qName)) && !bl) {
                bl = true;
                bindingOperation.setInputExplicitBodyParts(RuntimeWSDLParser.parseSOAPBodyBinding(xMLStreamReader, bindingOperation, BindingMode.INPUT));
                RuntimeWSDLParser.goToEnd(xMLStreamReader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(qName) || SOAPConstants.QNAME_SOAP12HEADER.equals(qName)) {
                RuntimeWSDLParser.parseSOAPHeaderBinding(xMLStreamReader, bindingOperation.getInputParts());
                continue;
            }
            if (MIMEConstants.QNAME_MULTIPART_RELATED.equals(qName)) {
                RuntimeWSDLParser.parseMimeMultipartBinding(xMLStreamReader, bindingOperation, BindingMode.INPUT);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private static void parseOutputBinding(XMLStreamReader xMLStreamReader, BindingOperation bindingOperation) {
        boolean bl = false;
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if ((SOAPConstants.QNAME_BODY.equals(qName) || SOAPConstants.QNAME_SOAP12BODY.equals(qName)) && !bl) {
                bl = true;
                bindingOperation.setOutputExplicitBodyParts(RuntimeWSDLParser.parseSOAPBodyBinding(xMLStreamReader, bindingOperation, BindingMode.OUTPUT));
                RuntimeWSDLParser.goToEnd(xMLStreamReader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(qName) || SOAPConstants.QNAME_SOAP12HEADER.equals(qName)) {
                RuntimeWSDLParser.parseSOAPHeaderBinding(xMLStreamReader, bindingOperation.getOutputParts());
                continue;
            }
            if (MIMEConstants.QNAME_MULTIPART_RELATED.equals(qName)) {
                RuntimeWSDLParser.parseMimeMultipartBinding(xMLStreamReader, bindingOperation, BindingMode.OUTPUT);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private static boolean parseSOAPBodyBinding(XMLStreamReader xMLStreamReader, BindingOperation bindingOperation, BindingMode bindingMode) {
        String string = xMLStreamReader.getAttributeValue(null, "namespace");
        if (bindingMode == BindingMode.INPUT) {
            bindingOperation.reqNamespace = string;
            return RuntimeWSDLParser.parseSOAPBodyBinding(xMLStreamReader, bindingOperation.getInputParts());
        }
        bindingOperation.respNamespace = string;
        return RuntimeWSDLParser.parseSOAPBodyBinding(xMLStreamReader, bindingOperation.getOutputParts());
    }

    private static boolean parseSOAPBodyBinding(XMLStreamReader xMLStreamReader, Map<String, ParameterBinding> map) {
        String string = xMLStreamReader.getAttributeValue(null, "parts");
        if (string != null) {
            List<String> list = XmlUtil.parseTokenList(string);
            if (list.isEmpty()) {
                map.put(" ", ParameterBinding.BODY);
            } else {
                for (String string2 : list) {
                    map.put(string2, ParameterBinding.BODY);
                }
            }
            return true;
        }
        return false;
    }

    private static void parseSOAPHeaderBinding(XMLStreamReader xMLStreamReader, Map<String, ParameterBinding> map) {
        String string = xMLStreamReader.getAttributeValue(null, "part");
        if (string == null | string.equals("")) {
            return;
        }
        map.put(string, ParameterBinding.HEADER);
        RuntimeWSDLParser.goToEnd(xMLStreamReader);
    }

    private static void parseMimeMultipartBinding(XMLStreamReader xMLStreamReader, BindingOperation bindingOperation, BindingMode bindingMode) {
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (MIMEConstants.QNAME_PART.equals(qName)) {
                RuntimeWSDLParser.parseMIMEPart(xMLStreamReader, bindingOperation, bindingMode);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private static void parseMIMEPart(XMLStreamReader xMLStreamReader, BindingOperation bindingOperation, BindingMode bindingMode) {
        boolean bl = false;
        Map<String, ParameterBinding> map = null;
        Map<String, String> map2 = null;
        if (bindingMode == BindingMode.INPUT) {
            map = bindingOperation.getInputParts();
            map2 = bindingOperation.getInputMimeTypes();
        } else {
            map = bindingOperation.getOutputParts();
            map2 = bindingOperation.getOutputMimeTypes();
        }
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (SOAPConstants.QNAME_BODY.equals(qName) && !bl) {
                bl = true;
                RuntimeWSDLParser.parseSOAPBodyBinding(xMLStreamReader, bindingOperation, bindingMode);
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(qName)) {
                bl = true;
                RuntimeWSDLParser.parseSOAPHeaderBinding(xMLStreamReader, map);
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            if (MIMEConstants.QNAME_CONTENT.equals(qName)) {
                String string = xMLStreamReader.getAttributeValue(null, "part");
                String string2 = xMLStreamReader.getAttributeValue(null, "type");
                if (string == null || string2 == null) {
                    XMLStreamReaderUtil.skipElement(xMLStreamReader);
                    continue;
                }
                ParameterBinding parameterBinding = ParameterBinding.createAttachment(string2);
                map.put(string, parameterBinding);
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    protected void parseImport(URL uRL, XMLStreamReader xMLStreamReader) throws IOException, SAXException, XMLStreamException {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "location");
        URL uRL2 = new URL(uRL, string);
        this.parseWSDL(uRL2);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private void parsePortType(XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        if (string == null) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            return;
        }
        PortType portType = new PortType(new QName(this.targetNamespace, string));
        this.wsdlDoc.addPortType(portType);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (WSDLConstants.QNAME_OPERATION.equals(qName)) {
                this.parsePortTypeOperation(xMLStreamReader, portType);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private void parsePortTypeOperation(XMLStreamReader xMLStreamReader, PortType portType) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        if (string == null) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            return;
        }
        QName qName = new QName(portType.getName().getNamespaceURI(), string);
        PortTypeOperation portTypeOperation = new PortTypeOperation(qName);
        String string2 = ParserUtil.getAttribute(xMLStreamReader, "parameterOrder");
        portTypeOperation.setParameterOrder(string2);
        portType.put(string, portTypeOperation);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName2 = xMLStreamReader.getName();
            if (qName2.equals(WSDLConstants.QNAME_INPUT)) {
                this.parsePortTypeOperationInput(xMLStreamReader, portTypeOperation);
                continue;
            }
            if (qName2.equals(WSDLConstants.QNAME_OUTPUT)) {
                this.parsePortTypeOperationOutput(xMLStreamReader, portTypeOperation);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private void parsePortTypeOperationInput(XMLStreamReader xMLStreamReader, PortTypeOperation portTypeOperation) {
        String string = ParserUtil.getAttribute(xMLStreamReader, "message");
        QName qName = ParserUtil.getQName(xMLStreamReader, string);
        portTypeOperation.setInputMessage(qName);
        RuntimeWSDLParser.goToEnd(xMLStreamReader);
    }

    private void parsePortTypeOperationOutput(XMLStreamReader xMLStreamReader, PortTypeOperation portTypeOperation) {
        String string = ParserUtil.getAttribute(xMLStreamReader, "message");
        QName qName = ParserUtil.getQName(xMLStreamReader, string);
        portTypeOperation.setOutputMessage(qName);
        RuntimeWSDLParser.goToEnd(xMLStreamReader);
    }

    private void parseMessage(XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        Message message = new Message(new QName(this.targetNamespace, string));
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (WSDLConstants.QNAME_PART.equals(qName)) {
                String string2 = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
                message.add(string2);
                if (xMLStreamReader.getEventType() == 2) continue;
                RuntimeWSDLParser.goToEnd(xMLStreamReader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
        this.wsdlDoc.addMessage(message);
        if (xMLStreamReader.getEventType() != 2) {
            RuntimeWSDLParser.goToEnd(xMLStreamReader);
        }
    }

    private static void goToEnd(XMLStreamReader xMLStreamReader) {
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BindingMode {
        INPUT,
        OUTPUT;

    }
}

