/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class Ellipse2D
extends RectangularShape {
    protected Ellipse2D() {
    }

    public boolean contains(double x, double y) {
        double rx = this.getWidth() / 2.0;
        double ry = this.getHeight() / 2.0;
        double tx = (x - this.getCenterX()) / rx;
        double ty = (y - this.getCenterY()) / ry;
        double d = tx;
        double d2 = ty;
        return d * d + d2 * d2 <= 1.0;
    }

    public boolean contains(double x, double y, double w, double h) {
        double x2 = x + w;
        double y2 = y + h;
        return this.contains(x, y) && this.contains(x, y2) && this.contains(x2, y) && this.contains(x2, y2);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new Arc2D.ArcIterator(this, at);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return false;
    }

    public static class Float
    extends Ellipse2D {
        public float height;
        public float width;
        public float x;
        public float y;

        public Float() {
        }

        public Float(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.height = h;
            this.width = w;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public boolean isEmpty() {
            return this.height <= 0.0f || this.width <= 0.0f;
        }

        public void setFrame(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.height = h;
            this.width = w;
        }

        public void setFrame(double x, double y, double w, double h) {
            this.x = (float)x;
            this.y = (float)y;
            this.height = (float)h;
            this.width = (float)w;
        }
    }

    public static class Double
    extends Ellipse2D {
        public double height;
        public double width;
        public double x;
        public double y;

        public Double() {
        }

        public Double(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.height = h;
            this.width = w;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public boolean isEmpty() {
            return this.height <= 0.0 || this.width <= 0.0;
        }

        public void setFrame(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.height = h;
            this.width = w;
        }
    }
}

