
/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "icons.h"
#include "misc.h"
#include "settings.h"
/****   calbacks  ***/

G_MODULE_EXPORT
void zoom(gboolean increase){
    int tree_id;

     if (increase) tree_details->icon_size++;
     else tree_details->icon_size--;
     if (tree_details->icon_size > 3) tree_details->icon_size=0;
     if (tree_details->icon_size < 0) tree_details->icon_size=3;
     for (tree_id=0;tree_id<TREECOUNT;tree_id++) {
	gtk_tree_model_foreach (tree_details->treestuff[tree_id].treemodel,
		  (increase)?increase_size:decrease_size,
		  (gpointer) tree_details->treestuff[tree_id].treeview);
    }
     write_local_xffm_config (); 
}


/* FIXME: too many junky functions. Two will do fine
  (one for GtkMenuItem one for GtkButton*/
G_MODULE_EXPORT
void on_zoom_in_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    zoom(TRUE);
}


G_MODULE_EXPORT
void on_zoom_out_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    zoom(FALSE);
}

G_MODULE_EXPORT
void tb_zoom_in(GtkButton * button, gpointer user_data)
{
    zoom(TRUE);
}


G_MODULE_EXPORT
void tb_zoom_out(GtkButton * button, gpointer user_data)
{
    zoom(FALSE);
}

G_MODULE_EXPORT
void sb_zoom_in(GtkWidget *w)
{
    zoom(TRUE);
}


G_MODULE_EXPORT
void sb_zoom_out(GtkWidget *w)
{
    zoom(FALSE);
}
