#!/bin/sh
if [ -z $udev_root ]; then
	  . /etc/udev/udev.conf
fi

getlock() {
	until (set -o noclobber ; echo $$ >/dev/cd-lockfile) 2>/dev/null
	do
	   sleep 1 
	done
}

givelock() {
	rm /dev/cd-lockfile
} 

# NOTICE:  This script is not used unless there is a rule for it
# under /etc/udev/rules.d/, and the one in udev.rules is COMMENTED
# OUT for now (unless you'd like to test it).  It is better to put
# the rule under /etc/udev/rules.d/ in a file of your own name, as
# the udev.rules file is overwritten with each udev upgrade...

# initialize some variables:
OPTICAL_DEVICE=$1
ID=${PHYSDEVPATH##*/}
let `/lib/udev/cdrom_id --export /dev/${OPTICAL_DEVICE}`

if ! [ -z $ID_CDROM ] && ! [ -e /dev/coldplug ]; then
	getlock
	if ! [ -e /etc/udev/rules.d/cd-devices.rules ]; then
		cat <<EOF > /etc/udev/rules.d/cd-devices.rules		
# Local CD/DVD rules to make the symlinks for your CD/DVD devices.
# These rules were generated by cdrom-symlinks.sh, but you can customize
# them if needed.
#
# If you delete this file, /lib/udev/cdrom-symlinks.sh will try to
# generate it again the next time udev is started.

EOF
	fi

	MATCH="BUS==\"$PHYSDEVBUS\", ID==\"$ID\", SYMLINK+="
	NUMBER=`grep -c "SYMLINK+=\"cdrom." /etc/udev/rules.d/cd-devices.rules`

	if ! grep "$MATCH" /etc/udev/rules.d/* &>/dev/null ; then
		cd $udev_root
		if [ "$NUMBER" = "0" ]; then
			CDROM=" cdrom"
			ln -sf $OPTICAL_DEVICE cdrom
		elif ! [ -L cdrom ]; then
			CDROM=" cdrom"
			ln -sf $OPTICAL_DEVICE cdrom
		fi
		CDROM="\"cdrom${NUMBER}${CDROM}\""
		ln -sf $OPTICAL_DEVICE cdrom${NUMBER}

		echo ${MATCH}${CDROM} >> /etc/udev/rules.d/cd-devices.rules
	
		if [ -n "$ID_CDROM_DVD" ]; then
			if [ "$NUMBER" = "0" ]; then
				DVDROM=" dvd"
				ln -sf $OPTICAL_DEVICE dvd 
			elif ! [ -L dvd ]; then
				DVDROM=" dvd"
				ln -sf $OPTICAL_DEVICE dvd 
			fi
			DVDROM="\"dvd${NUMBER}${DVDROM}\""
			ln -sf $OPTICAL_DEVICE dvd${NUMBER}
			
			echo ${MATCH}${DVDROM} >> /etc/udev/rules.d/cd-devices.rules

			if [ -n "$ID_CDROM_DVD_R" ] || [ -n "$ID_CDROM_DVD_RAM" ]; then
				if [ "$NUMBER" = "0" ]; then
					DVDRW=" dvdrw dvdwriter"
					ln -sf $OPTICAL_DEVICE dvdrw
					ln -sf $OPTICAL_DEVICE dvdwriter
				elif ! [ -L dvdrw ]; then
					DVDRW=" dvdrw dvdwriter"
					ln -sf $OPTICAL_DEVICE dvdrw
					ln -sf $OPTICAL_DEVICE dvdwriter
				fi
				DVDRW="\"dvdrw${NUMBER}${DVDRW}\""
				ln -sf $OPTICAL_DEVICE dvdrw${NUMBER}
				
				echo ${MATCH}${DVDRW} >> /etc/udev/rules.d/cd-devices.rules
			fi	
		fi

		if [ -n "$ID_CDROM_CD_R" ]; then
			if [ "$NUMBER" = "0" ]; then
				CDR=" cdr cdwriter"
				ln -sf $OPTICAL_DEVICE cdr
				ln -sf $OPTICAL_DEVICE cdwriter
			elif ! [ -L cdr ]; then
				CDR=" cdr cdwriter"
				ln -sf $OPTICAL_DEVICE cdr
				ln -sf $OPTICAL_DEVICE cdwriter
			fi
			CDR="\"cdr${NUMBER}${CDR}\""
			ln -sf $OPTICAL_DEVICE cdr${NUMBER}

			echo ${MATCH}${CDR} >> /etc/udev/rules.d/cd-devices.rules

			if [ -n "$ID_CDROM_CD_RW" ]; then
				if [ "$NUMBER" = "0" ]; then
					CDRW=" cdrw"
					ln -sf $OPTICAL_DEVICE cdrw
				elif ! [ -L cdrw ]; then
					CDRW=" cdrw"
					ln -sf $OPTICAL_DEVICE cdrw
				fi
				CDRW="\"cdrw${NUMBER}${CDRW}\""
				ln -sf $OPTICAL_DEVICE cdrw${NUMBER}

				echo ${MATCH}${CDRW} >> /etc/udev/rules.d/cd-devices.rules
			fi
		fi
	fi
	givelock
else
	exit 1
fi
