/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

class JsseX509KeyManager
extends X509ExtendedKeyManager {
    private static final Debug debug = Debug.getInstance("ssl");
    private X509ExtendedKeyManager keyManager;

    JsseX509KeyManager(KeyManager[] keyManagerArray) {
        for (int i = 0; keyManagerArray != null && i < keyManagerArray.length; ++i) {
            if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
            if (keyManagerArray[i] instanceof X509ExtendedKeyManager) {
                this.keyManager = (X509ExtendedKeyManager)keyManagerArray[i];
                break;
            }
            if (debug != null && Debug.isOn("sslctx")) {
                System.out.println("X509KeyManager passed to SSLContext.init():  need an X509ExtendedKeyManager for SSLEngine use");
            }
            this.keyManager = new AbstractWrapper((X509KeyManager)keyManagerArray[i]);
            break;
        }
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        if (this.keyManager != null) {
            return this.keyManager.getClientAliases(string, principalArray);
        }
        return null;
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (this.keyManager != null) {
            return this.keyManager.chooseClientAlias(stringArray, principalArray, socket);
        }
        return null;
    }

    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        if (this.keyManager != null) {
            try {
                return this.keyManager.chooseEngineClientAlias(stringArray, principalArray, sSLEngine);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return null;
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        if (this.keyManager != null) {
            return this.keyManager.getServerAliases(string, principalArray);
        }
        return null;
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        if (this.keyManager != null) {
            return this.keyManager.chooseServerAlias(string, principalArray, socket);
        }
        return null;
    }

    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        if (this.keyManager != null) {
            try {
                return this.keyManager.chooseEngineServerAlias(string, principalArray, sSLEngine);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return null;
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (this.keyManager != null) {
            return this.keyManager.getCertificateChain(string);
        }
        return null;
    }

    public PrivateKey getPrivateKey(String string) {
        if (this.keyManager != null) {
            return this.keyManager.getPrivateKey(string);
        }
        return null;
    }

    static class AbstractWrapper
    extends X509ExtendedKeyManager {
        private X509KeyManager km;

        AbstractWrapper(X509KeyManager x509KeyManager) {
            this.km = x509KeyManager;
        }

        public String[] getClientAliases(String string, Principal[] principalArray) {
            return this.km.getClientAliases(string, principalArray);
        }

        public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
            return this.km.chooseClientAlias(stringArray, principalArray, socket);
        }

        public String[] getServerAliases(String string, Principal[] principalArray) {
            return this.km.getServerAliases(string, principalArray);
        }

        public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
            return this.km.chooseServerAlias(string, principalArray, socket);
        }

        public X509Certificate[] getCertificateChain(String string) {
            return this.km.getCertificateChain(string);
        }

        public PrivateKey getPrivateKey(String string) {
            return this.km.getPrivateKey(string);
        }
    }
}

