/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;

public final class DatagramPacket {
    private byte[] buffer;
    private int offset;
    int length;
    int maxlen;
    private InetAddress address;
    private int port;

    public DatagramPacket(byte[] buf, int offset, int length) {
        this.setData(buf, offset, length);
        this.address = null;
        this.port = -1;
    }

    public DatagramPacket(byte[] buf, int length) {
        this(buf, 0, length);
    }

    public DatagramPacket(byte[] buf, int offset, int length, InetAddress address, int port) {
        this.setData(buf, offset, length);
        this.setAddress(address);
        this.setPort(port);
    }

    public DatagramPacket(byte[] buf, int length, InetAddress address, int port) {
        this(buf, 0, length, address, port);
    }

    public DatagramPacket(byte[] buf, int offset, int length, SocketAddress address) throws SocketException {
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetSocketAddress tmp = (InetSocketAddress)address;
        this.setData(buf, offset, length);
        this.setAddress(tmp.getAddress());
        this.setPort(tmp.getPort());
    }

    public DatagramPacket(byte[] buf, int length, SocketAddress address) throws SocketException {
        this(buf, 0, length, address);
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized byte[] getData() {
        return this.buffer;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void setAddress(InetAddress iaddr) {
        if (iaddr == null) {
            throw new NullPointerException("Null address");
        }
        this.address = iaddr;
    }

    public synchronized void setPort(int iport) {
        if (iport < 0 || iport > 65535) {
            throw new IllegalArgumentException("Invalid port: " + iport);
        }
        this.port = iport;
    }

    public void setSocketAddress(SocketAddress address) throws IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("address may not be null");
        }
        InetSocketAddress tmp = (InetSocketAddress)address;
        this.address = tmp.getAddress();
        this.port = tmp.getPort();
    }

    public SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.address, this.port);
    }

    public void setData(byte[] buf) {
        this.setData(buf, 0, buf.length);
    }

    public synchronized void setData(byte[] buf, int offset, int length) {
        if (buf == null) {
            throw new NullPointerException("Null buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid offset: " + offset);
        }
        this.buffer = buf;
        this.offset = offset;
        this.setLength(length);
    }

    public synchronized void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        if (this.offset + length > this.buffer.length) {
            throw new IllegalArgumentException("Potential buffer overflow - offset: " + this.offset + " length: " + length);
        }
        this.length = length;
        this.maxlen = length;
    }
}

