/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Some code in here contributed by the FSF
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <errno.h>
#include <grp.h>
#include <pwd.h>
#include <regex.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "modules.h"

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "filter.h"

#include "misc.h"
#include "refresh.h"

#ifdef USE_FILTER_BAR
static xfc_combo_info_t *filter_combo_info=NULL;
#endif

G_MODULE_EXPORT
void set_filter_combo(void){
#ifndef USE_FILTER_BAR
    return ;
#else
    gchar *f;
    GtkWidget *filter_combo;
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    /* let's postpone module loading if filter is hidden */
    if(!GTK_WIDGET_VISIBLE(WIDGET( "filter_box")))
	    return;
    f=g_build_filename(xdg_dir,FILTER_DBH_FILE,NULL);

    g_free(xdg_dir);
    filter_combo = WIDGET("filter_combo");

    if (!filter_combo_info){
	 filter_combo_info = XFC_init_combo((GtkCombo *)filter_combo);
	 filter_combo_info->activate_func = on_filter_activate;
         XFC_read_history(filter_combo_info,f);
    }
    g_free (f);
    XFC_set_blank(filter_combo_info);
    return;
#endif
}

G_MODULE_EXPORT
const gchar *get_filter(GtkWidget * window)
{
#ifndef USE_FILTER_BAR
    return NULL;
#else
    GtkWidget *filter_entry, *filter_combo;
    char *f;
    static gchar *last_filter=NULL;
    gchar *ff;

    filter_entry = WIDGET("combo_entry2");
    filter_combo = WIDGET("filter_combo");
    if(!GTK_WIDGET_VISIBLE(WIDGET("filter_box")))
    {
	return "*";
    }
    if(!filter_entry) assert_not_reached();
    if (!filter_combo_info){
	set_filter_combo();
    }
   
    f = (char *)gtk_entry_get_text(GTK_ENTRY(filter_entry));
    if(!f || !strlen(f)) return "*";
    if (last_filter && strcmp(last_filter,f)==0) return last_filter;
    
    g_free(last_filter);
    last_filter=g_strdup(f);
    {
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	ff=g_build_filename(xdg_dir,FILTER_DBH_FILE,NULL);
	g_free(xdg_dir);
    }
    XFC_read_history(filter_combo_info,ff);
    filter_combo_info->list = g_list_prepend(filter_combo_info->list,g_strdup(f));
    XFC_save_to_history(ff,f);
    g_free (ff);
      
    if (!strlen(last_filter)) return "*";
    else return (const gchar *)last_filter;
#endif
}


static 
const gchar *
filter2regex(		const gchar *filter, 
			gboolean shows_hidden)
{
#ifndef USE_FILTER_BAR
    return NULL;
#else
    static char *regex=NULL;
    g_free(regex);
    /* change stars to regexp */
    if(!filter || strcmp(filter, "*") == 0 || strlen(filter) == 0)
    {
	regex = g_strdup("^.+$");
    }
    else
    {
	/*Let's translate stars to regexp */
	regex = (char *)malloc(2 * strlen(filter) + 1 + strlen("|^\\..+"));
	if(filter[0] == '*' && filter[strlen(filter) - 1] == '*')
	{
	    strcpy(regex, filter + 1);
	    regex[strlen(regex) - 1] = 0;
	}
	else if(filter[0] == '*')
	{
	    strcpy(regex, filter + 1);
	    strcat(regex, "$");
	    if(shows_hidden)
	    {
		strcat(regex, "|\\.");
		strcat(regex, filter + 1);
		strcat(regex, "$");
	    }
	}
	else if(filter[strlen(filter) - 1] == '*')
	{
	    strcpy(regex + 1, filter);
	    regex[0] = '^';
	    regex[strlen(filter)] = 0;
	    if(shows_hidden)
	    {
		strcat(regex, "|^\\.");
		strcat(regex, filter);
		regex[strlen(regex) - 1] = 0;
	    }
	}
	else if(strchr(filter, '*'))
	{
	    strcpy(regex + 1, filter);
	    regex[0] = '^';
	    *strchr(regex, '*') = 0;
	    strcat(regex, ".+");
	    strcat(regex, strchr(filter, '*') + 1);
	    strcat(regex, "$");
	    if(shows_hidden)
	    {
		char *aux;
		aux = g_strdup(regex + 1);
		strcat(regex, "|^\\.");
		strcat(regex, aux);
		g_free(aux);
		aux=NULL;
	    }
	}
	else
	    strcpy(regex, filter);

    }
    /*printf("DBG:regex=%s\n",regex); */
    return (const gchar *)regex;
#endif
}

G_MODULE_EXPORT
const regex_t *
compile_regex_filter(		const gchar *filter,
				gboolean shows_hidden)
{
#ifndef USE_FILTER_BAR
    return NULL;
#else
    static regex_t preg;
    const char *regex;
    static gboolean compiled=FALSE;

        
    if (!filter || !strlen(filter) || strcmp(filter,"*")==0) return NULL;
    regex = filter2regex(filter, shows_hidden);
    

    /*printf("compile_regex_filter(%s)\n",filter);*/
    if (compiled) regfree(&preg);
    if (regcomp(&preg, regex, REG_EXTENDED | REG_ICASE | REG_NOSUB)==0)
	compiled=TRUE;
    else 
	compiled=FALSE;
    return &preg;
#endif
}


/* callbacks */

G_MODULE_EXPORT
void on_filter_activate(GtkEntry * entry, gpointer user_data)
{
#ifdef USE_FILTER_BAR
    on_refresh((GtkButton *) entry, user_data);
#endif
}


