//
//  kjots
//
//  Copyright (C) 1997 Christoph Neerfeld
//  Copyright (C) 2002, 2003 Aaron J. Seigo
//  Copyright (C) 2003 Stanislav Kljuhhin
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __KJOTSENTRY_H
#define __KJOTSENTRY_H

#include <klistview.h>
#include <kprinter.h>

//
// class KJotsEntryBase
//

class KURL;
class KJotsPage;
class KProgressDialog;
class KJotsEdit;

namespace KIO
{
    class Job;
}

class KJotsEntryBase : public QObject, public KListViewItem
{
    Q_OBJECT
    public:
        KJotsEntryBase(KListView*, QListViewItem*);
        KJotsEntryBase(KListViewItem*, QListViewItem*);

    public:
        virtual void setSubject(const QString&);
        QString subject() { return text(0); }
        void setText(int,const QString&);
        virtual void saveToFile(KURL, bool plainText) = 0;
        virtual void print(QFont& defaultFont) = 0;
        virtual QString defaultSubject() = 0; //!< "subject" is the caption name
        virtual void rename() = 0;
};

//
// class KjotsBook
//

class KJotsBook : public KJotsEntryBase
{
    Q_OBJECT
    public:
        KJotsBook(KListView*, QString, QListViewItem* after = 0);
        ~KJotsBook();

        static bool isBookFile(const QString& book);
        bool openBook();
        void closeBook(bool saveOnly = false);
        void annihilateBook(void);
        void setSubject(const QString&);
        void rename();
        void setDeleteFlag() { m_deleteFlag = true; }
        void saveToFile(KURL, bool plainText);
        KJotsPage* addPage(QString subject = QString::null, QListViewItem* after = 0, int id = -1);
        void print(QFont& defaultFont);
        bool isDirty();
        void setDirty() { m_dirty = true; } //!< Noone outside the class can turn dirty off.
        bool isActive();
        void setActive(bool active) { m_active = active; }
        int nextID() { return ++m_pageID; }
        QString defaultSubject();

    protected slots:
        void saveDataReq(KIO::Job* job, QByteArray& data);
        void slotSaveResult(KIO::Job*);

    private:
        bool m_dirty; //!< Set when a child page has been changed.
        bool m_active; //!< Set when a child page is being edited.
        bool m_open;
        bool m_deleteFlag;
        QString m_beforeRename;
        int  m_pageID;
        QListViewItem*  m_saveInProgress;
        bool m_saveToPlainText;
        KProgressDialog* m_saveProgressDialog;
};

//
// class KJotsPage
//
class KJotsPage : public KJotsEntryBase
{
    Q_OBJECT
    public:
        KJotsPage(KJotsBook* parent, QString subj, int id, QListViewItem* after = 0);

    public:
        QString body();
        void setBody(const QString&);
        void write(QTextStream &stream, bool plainText = true);
        void saveToFile(KURL, bool plainText);
        void print(QFont& defaultFont);
        int  print(KPrinter& printer, QPainter& painter, int y);
        QString defaultSubject();
        int id() { return m_id; }
        void rename();

        void setEditor(KJotsEdit*);
        bool isDirty();

    protected slots:
        void saveDataReq(KIO::Job* job, QByteArray& data);
        void slotSaveResult(KIO::Job*);

    private:
        QString m_text;
        int     m_id;
        bool    m_saveInProgress;
        bool    m_saveToPlainText;
        KJotsEdit *m_editor; //!< ptr to editor if this is the active subject
};

#endif // __KJOTSENTRY_H
/* ex: set tabstop=4 softtabstop=4 shiftwidth=4 expandtab: */
