#!/usr/bin/env kjscmd

//
// Demo that connects C++ signals to JS slots of various types.
//

// Load the demo gui
var top = Factory.loadui( 'connect.ui' );

// Util func to print a msg
function msg(s)
{
  top.child('output').append(s);
}

// JS object we connect to
function DemoObj()
{
   this.func_void = function() { msg('void'); }
   this.func_bool = function(b) { msg(b); }
   this.func_int = function(i) { msg(i); }
   this.func_string = function(s) { msg(s); }
   this.func_double = function(d) { msg(d); }
}

//
// Main
//

var obj = new DemoObj();

var ve = top.child('v');
var be = top.child('b');
var ie = top.child('i');
var se = top.child('s');
var de = top.child('d');

top.connect( ve, 'clicked()', obj, 'func_void' );
top.connect( be, 'toggled(bool)', obj, 'func_bool' );
top.connect( ie, 'valueChanged(int)', obj, 'func_int' );
top.connect( se, 'textChanged(const QString&)', obj, 'func_string' );
top.connect( de, 'valueChanged(double)', obj, 'func_double' );

top.show();
application.exec();
