/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * static char copyright[] = "Copyright (c) 1990 Regents of the University 
 * of California.\nAll rights reserved.\n";
 * static char SccsId[] = "@(#)@(#)popper.h	2.2  2.2 4/2/91";
 *
 */

/* MAX_BULL defines the maximum number of motd messages a user may
 * get at any time.
 */
#define MAX_BULL	20

#define NEWUSERBULLS            20              /* Max # of msgs given to
                                                   a new pop user */
#if (MAX_BULL < NEWUSERBULLS)
#define MAX_BULL NEWUSERBULLS
#endif

#define MAXUSERNAMELEN  65
#define MAXDROPLEN      64
#define MAXLINELEN      1024
#define MAXMSGLINELEN   MAXLINELEN

/* Define the path to the bulletin dir.
 *	-DBULLDIR= "/var/mail/popmotd"
 * in the make file works well or you can define BULLDIR before the #ifdef.
 */

/* BULLDIR defines what directory motd files will be placed in.
*/
#ifndef BULLDIR
#define BULLDIR		"/var/mail/popmotd"
#endif

			/* Defines the minimum number of bulletins a new user
			   receives */
#define NEWBULLCNT	1
#define POP_SUCCESS     0
#define POP_FAILURE     -1

typedef struct  {                               /*  POP parameter block */
    char                user[MAXUSERNAMELEN];   /*  Name of the POP user */

    char                drop_name[MAXDROPLEN];  /*  The name of the user's 
                                                    temporary maildrop */
    FILE            *   drop;                   /*  (Temporary) mail drop */
    char                bulldir[128];           /*  Bulletin directory */
    char		homedir[100];		/*  Put the homedir here */
    long 	        bullfiles[MAX_BULL];    /*  List of files to
						    append to temp file */
} POP;
