/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import sun.jvm.hotspot.tools.HeapSummary;
import sun.jvm.hotspot.tools.ObjectHistogram;
import sun.jvm.hotspot.tools.PMap;
import sun.jvm.hotspot.tools.PermStat;
import sun.jvm.hotspot.tools.Tool;

public class JMap
extends Tool {
    public static final int MODE_HEAP_SUMMARY = 0;
    public static final int MODE_HISTOGRAM = 1;
    public static final int MODE_PERMSTAT = 2;
    public static final int MODE_PMAP = 3;
    private int mode;

    public JMap(int m) {
        this.mode = m;
    }

    public JMap() {
        this(3);
    }

    protected boolean needsJavaPrefix() {
        return false;
    }

    public String getName() {
        return "jmap";
    }

    protected String getCommandFlags() {
        return "-heap|-histo|-permstat";
    }

    protected void printFlagsUsage() {
        System.out.println("    <no option>\tto print same info as Solaris pmap");
        System.out.println("    -heap\tto print java heap summary");
        System.out.println("    -histo\tto print histogram of java object heap");
        System.out.println("    -permstat\tto print classloader-wise perm gen statistics");
        super.printFlagsUsage();
    }

    public void run() {
        Tool tool = null;
        switch (this.mode) {
            case 0: {
                tool = new HeapSummary();
                break;
            }
            case 1: {
                tool = new ObjectHistogram();
                break;
            }
            case 2: {
                tool = new PermStat();
                break;
            }
            case 3: {
                tool = new PMap();
                break;
            }
            default: {
                this.usage();
            }
        }
        tool.setAgent(this.getAgent());
        tool.setDebugeeType(this.getDebugeeType());
        tool.run();
    }

    public static void main(String[] args) {
        int mode = 3;
        if (args.length > 1) {
            String modeFlag = args[0];
            boolean copyArgs = true;
            if (modeFlag.equals("-heap")) {
                mode = 0;
            } else if (modeFlag.equals("-histo")) {
                mode = 1;
            } else if (modeFlag.equals("-permstat")) {
                mode = 2;
            } else {
                copyArgs = false;
            }
            if (copyArgs) {
                String[] newArgs = new String[args.length - 1];
                for (int i = 0; i < newArgs.length; ++i) {
                    newArgs[i] = args[i + 1];
                }
                args = newArgs;
            }
        }
        JMap jmap = new JMap(mode);
        jmap.start(args);
        jmap.stop();
    }
}

