/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class JavaCallWrapper
extends VMObject {
    protected static AddressField anchorField;
    private static AddressField lastJavaSPField;
    private static AddressField lastJavaPCField;
    private static AddressField notAtCallIDField;
    private static CIntegerField anchorFlagsField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaCallWrapper");
        Type anchorType = db.lookupType("JavaFrameAnchor");
        anchorField = type.getAddressField("_anchor");
        lastJavaSPField = anchorType.getAddressField("_last_Java_sp");
        lastJavaPCField = anchorType.getAddressField("_last_Java_pc");
        anchorFlagsField = anchorType.getCIntegerField("_flags");
        notAtCallIDField = anchorType.getAddressField("_not_at_call_id");
    }

    public JavaCallWrapper(Address addr) {
        super(addr);
    }

    public Address getLastJavaSP() {
        return lastJavaSPField.getValue(this.addr.addOffsetTo(anchorField.getOffset()));
    }

    public Address getLastJavaPC() {
        return lastJavaPCField.getValue(this.addr.addOffsetTo(anchorField.getOffset()));
    }

    public long getAnchorFlags() {
        return anchorFlagsField.getValue(this.addr.addOffsetTo(anchorField.getOffset()));
    }

    public Address getNotAtCallID() {
        return notAtCallIDField.getValue(this.addr.addOffsetTo(anchorField.getOffset()));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                JavaCallWrapper.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

