/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.TypeArrayKlass;

public class ObjectHistogramElement {
    private Klass klass;
    private long count;
    private long size;

    public ObjectHistogramElement(Klass k) {
        this.klass = k;
        this.count = 0L;
        this.size = 0L;
    }

    public void updateWith(Oop obj) {
        ++this.count;
        this.size += obj.getObjectSize();
    }

    public int compare(ObjectHistogramElement other) {
        return (int)(other.size - this.size);
    }

    public Klass getKlass() {
        return this.klass;
    }

    public long getCount() {
        return this.count;
    }

    public long getSize() {
        return this.size;
    }

    private String getInternalName(Klass k) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.getKlass().printValueOn(new PrintStream(bos));
        return "* " + bos.toString();
    }

    public String getDescription() {
        Klass k = this.getKlass();
        if (k instanceof InstanceKlass) {
            return k.getName().asString().replace('/', '.');
        }
        if (k instanceof ArrayKlass) {
            ArrayKlass ak = (ArrayKlass)k;
            if (k instanceof TypeArrayKlass) {
                TypeArrayKlass tak = (TypeArrayKlass)ak;
                return tak.getElementTypeName() + "[]";
            }
            if (k instanceof ObjArrayKlass) {
                ObjArrayKlass oak = (ObjArrayKlass)ak;
                Klass bottom = oak.getBottomKlass();
                int dim = (int)oak.getDimension();
                StringBuffer buf = new StringBuffer();
                if (bottom instanceof TypeArrayKlass) {
                    buf.append(((TypeArrayKlass)bottom).getElementTypeName());
                } else if (bottom instanceof InstanceKlass) {
                    buf.append(bottom.getName().asString().replace('/', '.'));
                } else {
                    throw new RuntimeException("should not reach here");
                }
                for (int i = 0; i < dim; ++i) {
                    buf.append("[]");
                }
                return buf.toString();
            }
        }
        return this.getInternalName(k);
    }

    public static void titleOn(PrintStream tty) {
        tty.println("Object Histogram:");
        tty.println();
        tty.println("Size\tCount\tClass description");
        tty.println("-------------------------------------------------------");
    }

    public void printOn(PrintStream tty) {
        tty.print(this.size + "\t" + this.count + "\t");
        tty.print(this.getDescription());
        tty.println();
    }
}

