/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.BytecodeWithKlass;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeNew
extends BytecodeWithKlass {
    BytecodeNew(Method method, int bci) {
        super(method, bci);
    }

    public InstanceKlass getNewKlass() {
        return (InstanceKlass)this.getKlass();
    }

    public void verify() {
        Assert.that(this.isValid(), "check new");
    }

    public boolean isValid() {
        return this.javaCode() == 187;
    }

    public static BytecodeNew at(Method method, int bci) {
        BytecodeNew b = new BytecodeNew(method, bci);
        b.verify();
        return b;
    }

    public static BytecodeNew atCheck(Method method, int bci) {
        BytecodeNew b = new BytecodeNew(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeNew at(BytecodeStream bcs) {
        return new BytecodeNew(bcs.method(), bcs.bci());
    }
}

