/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.File;
import java.net.URI;
import java.security.AccessController;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.AttributeUpdater;
import sun.print.PSPrinterJob;
import sun.print.ServiceNotifier;
import sun.print.SunPrinterJobService;
import sun.print.UnixPrintJob;
import sun.print.UnixPrintServiceLookup;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixPrintService
implements PrintService,
AttributeUpdater,
SunPrinterJobService {
    private static String encoding = "ISO8859_1";
    private static DocFlavor textByteFlavor;
    private static final DocFlavor[] supportedDocFlavors;
    String[] lpcStatusCom = new String[]{"", "| grep -E '^[ 0-9a-zA-Z]*@' | awk '{print $2, $3}'"};
    String[] lpcQueueCom = new String[]{"", "| grep -E '^[ 0-9a-zA-Z]*@' | awk '{print $4}'"};
    private static final Class[] serviceAttrCats;
    private static final Class[] otherAttrCats;
    private static int MAXCOPIES;
    private static final MediaSizeName[] mediaSizes;
    private String printer;
    private PrinterName name;
    private transient PrintServiceAttributeSet lastSet;
    private transient ServiceNotifier notifier = null;
    private static MediaPrintableArea[] mpas;

    UnixPrintService(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null printer name");
        }
        this.printer = string;
    }

    @Override
    public String getName() {
        return this.printer;
    }

    private PrinterName getPrinterName() {
        if (this.name == null) {
            this.name = new PrinterName(this.printer, null);
        }
        return this.name;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobsSysV() {
        String string = "/usr/bin/lpstat -a " + this.printer;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        if (stringArray != null && stringArray.length > 0 && stringArray[0].startsWith(this.printer + " accepting requests")) {
            return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
        }
        return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobsBSD() {
        String string;
        String[] stringArray;
        if (UnixPrintServiceLookup.cmdIndex == -1) {
            UnixPrintServiceLookup.cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(string = "/usr/sbin/lpc status " + this.printer + this.lpcStatusCom[UnixPrintServiceLookup.cmdIndex])) != null && stringArray.length > 0 && (UnixPrintServiceLookup.cmdIndex == 1 ? stringArray[0].startsWith("enabled enabled") : stringArray[1].trim().startsWith("queuing is enabled") && stringArray[2].trim().startsWith("printing is enabled") || stringArray.length >= 4 && stringArray[2].trim().startsWith("queuing is enabled") && stringArray[3].trim().startsWith("printing is enabled"))) {
            return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
        }
        return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobs() {
        if (UnixPrintServiceLookup.isSysV()) {
            return this.getPrinterIsAcceptingJobsSysV();
        }
        if (UnixPrintServiceLookup.isBSD()) {
            return this.getPrinterIsAcceptingJobsBSD();
        }
        return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
    }

    private QueuedJobCount getQueuedJobCountSysV() {
        String string = "/usr/bin/lpstat -R " + this.printer;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        int n2 = stringArray == null ? 0 : stringArray.length;
        return new QueuedJobCount(n2);
    }

    private QueuedJobCount getQueuedJobCountBSD() {
        if (UnixPrintServiceLookup.cmdIndex == -1) {
            UnixPrintServiceLookup.cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        int n2 = 0;
        String string = "/usr/sbin/lpc status " + this.printer + this.lpcQueueCom[UnixPrintServiceLookup.cmdIndex];
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        if (stringArray != null && stringArray.length > 0) {
            String string2;
            if (UnixPrintServiceLookup.cmdIndex == 1) {
                string2 = stringArray[0];
            } else {
                string2 = stringArray[3].trim();
                if (string2.startsWith("no")) {
                    return new QueuedJobCount(0);
                }
                string2 = string2.substring(0, string2.indexOf(32));
            }
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new QueuedJobCount(n2);
    }

    private QueuedJobCount getQueuedJobCount() {
        if (UnixPrintServiceLookup.isSysV()) {
            return this.getQueuedJobCountSysV();
        }
        if (UnixPrintServiceLookup.isBSD()) {
            return this.getQueuedJobCountBSD();
        }
        return new QueuedJobCount(0);
    }

    private PrintServiceAttributeSet getSysVServiceAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getQueuedJobCountSysV());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobsSysV());
        return hashPrintServiceAttributeSet;
    }

    private PrintServiceAttributeSet getBSDServiceAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getQueuedJobCountBSD());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobsBSD());
        return hashPrintServiceAttributeSet;
    }

    private boolean isSupportedCopies(Copies copies) {
        int n2 = copies.getValue();
        return n2 > 0 && n2 < MAXCOPIES;
    }

    private boolean isSupportedMedia(MediaSizeName mediaSizeName) {
        for (int i2 = 0; i2 < mediaSizes.length; ++i2) {
            if (!mediaSizeName.equals(mediaSizes[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public DocPrintJob createPrintJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new UnixPrintJob(this);
    }

    private PrintServiceAttributeSet getDynamicAttributes() {
        if (UnixPrintServiceLookup.isSysV()) {
            return this.getSysVServiceAttributes();
        }
        return this.getBSDServiceAttributes();
    }

    @Override
    public PrintServiceAttributeSet getUpdatedAttributes() {
        PrintServiceAttributeSet printServiceAttributeSet = this.getDynamicAttributes();
        if (this.lastSet == null) {
            this.lastSet = printServiceAttributeSet;
            return AttributeSetUtilities.unmodifiableView(printServiceAttributeSet);
        }
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        Attribute[] attributeArray = printServiceAttributeSet.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            Attribute attribute = attributeArray[i2];
            if (this.lastSet.containsValue(attribute)) continue;
            hashPrintServiceAttributeSet.add(attribute);
        }
        this.lastSet = printServiceAttributeSet;
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNotifier() {
        UnixPrintService unixPrintService = this;
        synchronized (unixPrintService) {
            if (this.notifier != null) {
                this.notifier.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        UnixPrintService unixPrintService = this;
        synchronized (unixPrintService) {
            if (printServiceAttributeListener == null) {
                return;
            }
            if (this.notifier == null) {
                this.notifier = new ServiceNotifier(this);
            }
            this.notifier.addListener(printServiceAttributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        UnixPrintService unixPrintService = this;
        synchronized (unixPrintService) {
            if (printServiceAttributeListener == null || this.notifier == null) {
                return;
            }
            this.notifier.removeListener(printServiceAttributeListener);
            if (this.notifier.isEmpty()) {
                this.notifier.stopNotifier();
                this.notifier = null;
            }
        }
    }

    @Override
    public <T extends PrintServiceAttribute> T getAttribute(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("category");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        if (clazz == PrinterName.class) {
            return (T)this.getPrinterName();
        }
        if (clazz == QueuedJobCount.class) {
            return (T)this.getQueuedJobCount();
        }
        if (clazz == PrinterIsAcceptingJobs.class) {
            return (T)this.getPrinterIsAcceptingJobs();
        }
        return null;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getPrinterName());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobs());
        hashPrintServiceAttributeSet.add(this.getQueuedJobCount());
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        int n2 = supportedDocFlavors.length;
        DocFlavor[] docFlavorArray = new DocFlavor[n2];
        System.arraycopy(supportedDocFlavors, 0, docFlavorArray, 0, n2);
        return docFlavorArray;
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        for (int i2 = 0; i2 < supportedDocFlavors.length; ++i2) {
            if (!docFlavor.equals(supportedDocFlavors[i2])) continue;
            return true;
        }
        return false;
    }

    public Class[] getSupportedAttributeCategories() {
        int n2 = otherAttrCats.length;
        Class[] classArray = new Class[n2];
        System.arraycopy(otherAttrCats, 0, classArray, 0, otherAttrCats.length);
        return classArray;
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        for (int i2 = 0; i2 < otherAttrCats.length; ++i2) {
            if (clazz != otherAttrCats[i2]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getDefaultAttributeValue(Class<? extends Attribute> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == Copies.class) {
            return new Copies(1);
        }
        if (clazz == Chromaticity.class) {
            return Chromaticity.COLOR;
        }
        if (clazz == Destination.class) {
            try {
                return new Destination(new File("out.ps").toURI());
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        if (clazz == Fidelity.class) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (clazz == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (clazz == JobSheets.class) {
            return JobSheets.STANDARD;
        }
        if (clazz == Media.class) {
            String string = Locale.getDefault().getCountry();
            if (string != null && (string.equals("") || string.equals(Locale.US.getCountry()) || string.equals(Locale.CANADA.getCountry()))) {
                return MediaSizeName.NA_LETTER;
            }
            return MediaSizeName.ISO_A4;
        }
        if (clazz == MediaPrintableArea.class) {
            float f2;
            float f3;
            String string = Locale.getDefault().getCountry();
            if (string != null && (string.equals("") || string.equals(Locale.US.getCountry()) || string.equals(Locale.CANADA.getCountry()))) {
                f3 = MediaSize.NA.LETTER.getX(25400) - 2.0f;
                f2 = MediaSize.NA.LETTER.getY(25400) - 2.0f;
            } else {
                f3 = MediaSize.ISO.A4.getX(25400) - 2.0f;
                f2 = MediaSize.ISO.A4.getY(25400) - 2.0f;
            }
            return new MediaPrintableArea(0.25f, 0.25f, f3, f2, 25400);
        }
        if (clazz == OrientationRequested.class) {
            return OrientationRequested.PORTRAIT;
        }
        if (clazz == PageRanges.class) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (clazz == RequestingUserName.class) {
            String string = "";
            try {
                string = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string, null);
        }
        if (clazz == SheetCollate.class) {
            return SheetCollate.UNCOLLATED;
        }
        if (clazz == Sides.class) {
            return Sides.ONE_SIDED;
        }
        return null;
    }

    private boolean isAutoSense(DocFlavor docFlavor) {
        return docFlavor.equals(DocFlavor.BYTE_ARRAY.AUTOSENSE) || docFlavor.equals(DocFlavor.INPUT_STREAM.AUTOSENSE) || docFlavor.equals(DocFlavor.URL.AUTOSENSE);
    }

    @Override
    public Object getSupportedAttributeValues(Class<? extends Attribute> clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " does not implement Attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor)) {
                return null;
            }
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == Chromaticity.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.COLOR};
                return chromaticityArray;
            }
            return null;
        }
        if (clazz == Destination.class) {
            try {
                return new Destination(new File("out.ps").toURI());
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        if (clazz == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (clazz == JobSheets.class) {
            JobSheets[] jobSheetsArray = new JobSheets[]{JobSheets.NONE, JobSheets.STANDARD};
            return jobSheetsArray;
        }
        if (clazz == RequestingUserName.class) {
            String string = "";
            try {
                string = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string, null);
        }
        if (clazz == OrientationRequested.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                OrientationRequested[] orientationRequestedArray = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                return orientationRequestedArray;
            }
            return null;
        }
        if (clazz == Copies.class || clazz == CopiesSupported.class) {
            return new CopiesSupported(1, MAXCOPIES);
        }
        if (clazz == Media.class) {
            Media[] mediaArray = new Media[mediaSizes.length];
            System.arraycopy(mediaSizes, 0, mediaArray, 0, mediaSizes.length);
            return mediaArray;
        }
        if (clazz == Fidelity.class) {
            Fidelity[] fidelityArray = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return fidelityArray;
        }
        if (clazz == MediaPrintableArea.class) {
            MediaSizeName mediaSizeName;
            if (attributeSet == null) {
                return this.getAllPrintableAreas();
            }
            MediaSize mediaSize = (MediaSize)attributeSet.get(MediaSize.class);
            Media media = (Media)attributeSet.get(Media.class);
            if (mediaSize == null && media == null) {
                return this.getAllPrintableAreas();
            }
            MediaPrintableArea[] mediaPrintableAreaArray = new MediaPrintableArea[1];
            if (mediaSize == null && media instanceof MediaSizeName && (mediaSize = MediaSize.getMediaSizeForName(mediaSizeName = (MediaSizeName)media)) == null) {
                media = (Media)this.getDefaultAttributeValue(Media.class);
                if (media instanceof MediaSizeName) {
                    mediaSizeName = (MediaSizeName)media;
                    mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                }
                if (mediaSize == null) {
                    mediaPrintableAreaArray[0] = new MediaPrintableArea(0.25f, 0.25f, 8.0f, 10.5f, 25400);
                    return mediaPrintableAreaArray;
                }
            }
            assert (mediaSize != null);
            mediaPrintableAreaArray[0] = new MediaPrintableArea(0.25f, 0.25f, mediaSize.getX(25400) - 0.5f, mediaSize.getY(25400) - 0.5f, 25400);
            return mediaPrintableAreaArray;
        }
        if (clazz == PageRanges.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                PageRanges[] pageRangesArray = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                return pageRangesArray;
            }
            return null;
        }
        if (clazz == SheetCollate.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.UNCOLLATED, SheetCollate.COLLATED};
                return sheetCollateArray;
            }
            return null;
        }
        if (clazz == Sides.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                Sides[] sidesArray = new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE};
                return sidesArray;
            }
            return null;
        }
        return null;
    }

    private MediaPrintableArea[] getAllPrintableAreas() {
        DocAttribute[] docAttributeArray;
        if (mpas == null) {
            docAttributeArray = (Media[])this.getSupportedAttributeValues(Media.class, null, null);
            mpas = new MediaPrintableArea[docAttributeArray.length];
            for (int i2 = 0; i2 < mpas.length; ++i2) {
                if (!(docAttributeArray[i2] instanceof MediaSizeName)) continue;
                MediaSizeName mediaSizeName = (MediaSizeName)docAttributeArray[i2];
                MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                UnixPrintService.mpas[i2] = mediaSize == null ? (MediaPrintableArea)this.getDefaultAttributeValue(MediaPrintableArea.class) : new MediaPrintableArea(0.25f, 0.25f, mediaSize.getX(25400) - 0.5f, mediaSize.getY(25400) - 0.5f, 25400);
            }
        }
        docAttributeArray = new MediaPrintableArea[mpas.length];
        System.arraycopy(mpas, 0, docAttributeArray, 0, mpas.length);
        return docAttributeArray;
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        Class<? extends Attribute> clazz;
        if (attribute == null) {
            throw new NullPointerException("null attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor)) {
                return false;
            }
        }
        if (!this.isAttributeCategorySupported(clazz = attribute.getCategory())) {
            return false;
        }
        if (attribute.getCategory() == Chromaticity.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                return attribute == Chromaticity.COLOR;
            }
            return false;
        }
        if (attribute.getCategory() == Copies.class) {
            return this.isSupportedCopies((Copies)attribute);
        }
        if (attribute.getCategory() == Destination.class) {
            URI uRI = ((Destination)attribute).getURI();
            return "file".equals(uRI.getScheme()) && !uRI.getSchemeSpecificPart().equals("");
        }
        if (attribute.getCategory() == Media.class && attribute instanceof MediaSizeName) {
            return this.isSupportedMedia((MediaSizeName)attribute);
        }
        return !(attribute.getCategory() == OrientationRequested.class ? attribute == OrientationRequested.REVERSE_PORTRAIT || docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) && !docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) && !docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) && !docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) && !docFlavor.equals(DocFlavor.URL.GIF) && !docFlavor.equals(DocFlavor.URL.JPEG) && !docFlavor.equals(DocFlavor.URL.PNG) : (attribute.getCategory() == PageRanges.class ? docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : (attribute.getCategory() == SheetCollate.class ? docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : attribute.getCategory() == Sides.class && docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE))));
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor " + docFlavor + "is not supported");
        }
        if (attributeSet == null) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            try {
                Attribute attribute = attributeArray[i2];
                if (!this.isAttributeCategorySupported(attribute.getCategory())) {
                    hashAttributeSet.add(attribute);
                    continue;
                }
                if (this.isAttributeValueSupported(attribute, docFlavor, attributeSet)) continue;
                hashAttributeSet.add(attribute);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (hashAttributeSet.isEmpty()) {
            return null;
        }
        return hashAttributeSet;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public String toString() {
        return "Unix Printer : " + this.getName();
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof UnixPrintService && ((UnixPrintService)object).getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }

    @Override
    public boolean usesClass(Class clazz) {
        return clazz == PSPrinterJob.class;
    }

    static {
        supportedDocFlavors = new DocFlavor[]{DocFlavor.BYTE_ARRAY.POSTSCRIPT, DocFlavor.INPUT_STREAM.POSTSCRIPT, DocFlavor.URL.POSTSCRIPT, DocFlavor.BYTE_ARRAY.GIF, DocFlavor.INPUT_STREAM.GIF, DocFlavor.URL.GIF, DocFlavor.BYTE_ARRAY.JPEG, DocFlavor.INPUT_STREAM.JPEG, DocFlavor.URL.JPEG, DocFlavor.BYTE_ARRAY.PNG, DocFlavor.INPUT_STREAM.PNG, DocFlavor.URL.PNG, DocFlavor.CHAR_ARRAY.TEXT_PLAIN, DocFlavor.READER.TEXT_PLAIN, DocFlavor.STRING.TEXT_PLAIN, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_HOST, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_8, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16BE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16LE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_US_ASCII, DocFlavor.INPUT_STREAM.TEXT_PLAIN_HOST, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_8, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16BE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16LE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_US_ASCII, DocFlavor.URL.TEXT_PLAIN_HOST, DocFlavor.URL.TEXT_PLAIN_UTF_8, DocFlavor.URL.TEXT_PLAIN_UTF_16, DocFlavor.URL.TEXT_PLAIN_UTF_16BE, DocFlavor.URL.TEXT_PLAIN_UTF_16LE, DocFlavor.URL.TEXT_PLAIN_US_ASCII, DocFlavor.SERVICE_FORMATTED.PAGEABLE, DocFlavor.SERVICE_FORMATTED.PRINTABLE, DocFlavor.BYTE_ARRAY.AUTOSENSE, DocFlavor.URL.AUTOSENSE, DocFlavor.INPUT_STREAM.AUTOSENSE};
        encoding = (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        serviceAttrCats = new Class[]{PrinterName.class, PrinterIsAcceptingJobs.class, QueuedJobCount.class};
        otherAttrCats = new Class[]{Chromaticity.class, Copies.class, Destination.class, Fidelity.class, JobName.class, JobSheets.class, Media.class, MediaPrintableArea.class, OrientationRequested.class, PageRanges.class, RequestingUserName.class, SheetCollate.class, Sides.class};
        MAXCOPIES = 1000;
        mediaSizes = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5};
        mpas = null;
    }
}

