/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import sun.awt.image.RemoteOffScreenImage;
import sun.awt.image.ToolkitImage;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontManager;
import sun.font.PhysicalFont;
import sun.print.ProxyGraphics2D;
import sun.print.RasterPrinterJob;

public abstract class PathGraphics
extends ProxyGraphics2D {
    private Printable mPainter;
    private PageFormat mPageFormat;
    private int mPageIndex;
    private boolean mCanRedraw;
    protected static SoftReference<Hashtable<Font2DHandle, Object>> fontMapRef = new SoftReference<Object>(null);

    protected PathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n2, boolean bl2) {
        super(graphics2D, printerJob);
        this.mPainter = printable;
        this.mPageFormat = pageFormat;
        this.mPageIndex = n2;
        this.mCanRedraw = bl2;
    }

    protected Printable getPrintable() {
        return this.mPainter;
    }

    protected PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    protected int getPageIndex() {
        return this.mPageIndex;
    }

    public boolean canDoRedraws() {
        return this.mCanRedraw;
    }

    public abstract void redrawRegion(Rectangle2D var1, double var2, double var4, Rectangle2D var6, AffineTransform var7) throws PrinterException;

    public void drawLine(int n2, int n3, int n4, int n5) {
        Paint paint = this.getPaint();
        try {
            AffineTransform affineTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(affineTransform));
            }
            this.deviceDrawLine(n2, n3, n4, n5, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void drawRect(int n2, int n3, int n4, int n5) {
        Paint paint = this.getPaint();
        try {
            AffineTransform affineTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(affineTransform));
            }
            this.deviceFrameRect(n2, n3, n4, n5, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        Paint paint = this.getPaint();
        try {
            AffineTransform affineTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(affineTransform));
            }
            this.deviceFillRect(n2, n3, n4, n5, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        this.fill(new Rectangle2D.Float(n2, n3, n4, n5), this.getBackground());
    }

    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw(new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n7));
    }

    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fill(new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n7));
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        this.draw(new Ellipse2D.Float(n2, n3, n4, n5));
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        this.fill(new Ellipse2D.Float(n2, n3, n4, n5));
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw(new Arc2D.Float(n2, n3, n4, n5, n6, n7, 0));
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fill(new Arc2D.Float(n2, n3, n4, n5, n6, n7, 2));
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        if (n2 > 0) {
            float f2 = nArray[0];
            float f3 = nArray2[0];
            for (int i2 = 1; i2 < n2; ++i2) {
                float f4 = nArray[i2];
                float f5 = nArray2[i2];
                this.draw(new Line2D.Float(f2, f3, f4, f5));
                f2 = f4;
                f3 = f5;
            }
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.draw(new Polygon(nArray, nArray2, n2));
    }

    public void drawPolygon(Polygon polygon) {
        this.draw(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.fill(new Polygon(nArray, nArray2, n2));
    }

    public void fillPolygon(Polygon polygon) {
        this.fill(polygon);
    }

    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (float)n2, (float)n3);
    }

    public void drawString(String string, float f2, float f3) {
        if (string.length() == 0) {
            return;
        }
        TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
        textLayout.draw(this, f2, f3);
    }

    protected void drawString(String string, float f2, float f3, Font font, FontRenderContext fontRenderContext, float f4) {
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f2, f3));
        this.fill(shape);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this.drawString(attributedCharacterIterator, (float)n2, (float)n3);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        textLayout.draw(this, f2, f3);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        if (RasterPrinterJob.shapeTextProp || !this.printedSimpleGlyphVector(glyphVector, f2, f3)) {
            this.fill(glyphVector.getOutline(f2, f3));
        }
    }

    protected int platformFontCount(Font font, String string) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean printedSimpleGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        int n2 = glyphVector.getLayoutFlags();
        if (n2 != 0 && n2 != 2) {
            return false;
        }
        Font font = glyphVector.getFont();
        Font2D font2D = FontManager.getFont2D(font);
        if (font2D.handle.font2D != font2D) {
            return false;
        }
        Class<PathGraphics> clazz = PathGraphics.class;
        synchronized (PathGraphics.class) {
            int n3;
            int n4;
            Object object;
            Object[] objectArray;
            Object object2;
            FontRenderContext fontRenderContext;
            GlyphVector glyphVector2;
            int n5;
            int n6;
            int n7;
            Hashtable<Font2DHandle, Object> hashtable = fontMapRef.get();
            if (hashtable == null) {
                hashtable = new Hashtable();
                fontMapRef = new SoftReference<Hashtable<Font2DHandle, Object>>(hashtable);
            }
            // ** MonitorExit[var8_7] (shouldn't be in output)
            int n8 = glyphVector.getNumGlyphs();
            int[] nArray = glyphVector.getGlyphCodes(0, n8, null);
            char[] cArray = null;
            Object object3 = null;
            CompositeFont compositeFont = null;
            Object object4 = hashtable;
            synchronized (object4) {
                if (font2D instanceof CompositeFont) {
                    compositeFont = (CompositeFont)font2D;
                    n7 = compositeFont.getNumSlots();
                    object3 = (char[][])hashtable.get(font2D.handle);
                    if (object3 == null) {
                        object3 = new char[n7][];
                        hashtable.put(font2D.handle, object3);
                    }
                    for (n6 = 0; n6 < n8; ++n6) {
                        n5 = nArray[n6] >>> 24;
                        if (n5 >= n7) {
                            return false;
                        }
                        if (object3[n5] != null) continue;
                        PhysicalFont physicalFont = compositeFont.getSlotFont(n5);
                        char[] cArray2 = (char[])hashtable.get(physicalFont.handle);
                        if (cArray2 == null) {
                            cArray2 = PathGraphics.getGlyphToCharMapForFont(physicalFont);
                        }
                        object3[n5] = cArray2;
                    }
                } else {
                    cArray = (char[])hashtable.get(font2D.handle);
                    if (cArray == null) {
                        cArray = PathGraphics.getGlyphToCharMapForFont(font2D);
                        hashtable.put(font2D.handle, cArray);
                    }
                }
            }
            object4 = new char[n8];
            if (compositeFont != null) {
                for (n7 = 0; n7 < n8; ++n7) {
                    n6 = nArray[n7];
                    char[] cArray3 = object3[n6 >>> 24];
                    n6 &= 0xFFFFFF;
                    if (cArray3 == null) {
                        return false;
                    }
                    if (n6 < 0 || n6 >= cArray3.length) {
                        return false;
                    }
                    char c2 = cArray3[n6];
                    if (c2 == '\uffff') {
                        return false;
                    }
                    object4[n7] = c2;
                }
            } else {
                for (n7 = 0; n7 < n8; ++n7) {
                    n6 = nArray[n7];
                    if (n6 < 0 || n6 >= cArray.length) {
                        return false;
                    }
                    n5 = cArray[n6];
                    if (n5 == 65535) {
                        return false;
                    }
                    object4[n7] = n5;
                }
            }
            if ((glyphVector2 = font.createGlyphVector(fontRenderContext = glyphVector.getFontRenderContext(), (char[])object4)).getNumGlyphs() != n8) {
                return false;
            }
            int[] nArray2 = glyphVector2.getGlyphCodes(0, n8, null);
            for (int i2 = 0; i2 < n8; ++i2) {
                if (nArray[i2] == nArray2[i2]) continue;
                return false;
            }
            FontRenderContext fontRenderContext2 = this.getFontRenderContext();
            boolean bl2 = fontRenderContext.equals(fontRenderContext2);
            if (!bl2 && fontRenderContext.usesFractionalMetrics() == fontRenderContext2.usesFractionalMetrics()) {
                object2 = fontRenderContext.getTransform();
                AffineTransform affineTransform = this.getTransform();
                objectArray = new double[4];
                object = new double[4];
                ((AffineTransform)object2).getMatrix((double[])objectArray);
                affineTransform.getMatrix((double[])object);
                bl2 = true;
                for (int i3 = 0; i3 < 4; ++i3) {
                    if (objectArray[i3] == object[i3]) continue;
                    bl2 = false;
                    break;
                }
            }
            if ((n4 = this.platformFontCount(font, (String)(object2 = new String((char[])object4, 0, n8)))) == 0) {
                return false;
            }
            if (bl2) {
                this.drawString((String)object2, f2, f3, font, fontRenderContext, 0.0f);
                return true;
            }
            objectArray = glyphVector.getGlyphPositions(0, n8, null);
            if (n4 == 1 && this.canDrawStringToWidth() && ((n2 & 2) == 0 || this.samePositions(glyphVector2, nArray2, nArray, (float[])objectArray))) {
                object = glyphVector.getGlyphPosition(n8);
                this.drawString((String)object2, f2, f3, font, fontRenderContext, (float)((Point2D)object).getX());
                return true;
            }
            for (n3 = 0; n3 < ((Object)object4).length; ++n3) {
                if (object4[n3] < 1424 || object4[n3] > 4255) continue;
                return false;
            }
            for (n3 = 0; n3 < n8; ++n3) {
                String string = new String((char[])object4, n3, 1);
                this.drawString(string, f2 + objectArray[n3 * 2], f3 + objectArray[n3 * 2 + 1], font, fontRenderContext, 0.0f);
            }
            return true;
        }
    }

    private boolean samePositions(GlyphVector glyphVector, int[] nArray, int[] nArray2, float[] fArray) {
        int n2 = glyphVector.getNumGlyphs();
        float[] fArray2 = glyphVector.getGlyphPositions(0, n2, null);
        if (n2 != nArray.length || nArray2.length != nArray.length || fArray.length != fArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == nArray2[i2] && fArray2[i2] == fArray[i2]) continue;
            return false;
        }
        return true;
    }

    protected boolean canDrawStringToWidth() {
        return false;
    }

    private static char[] getGlyphToCharMapForFont(Font2D font2D) {
        int n2;
        int n3 = font2D.getNumGlyphs();
        int n4 = font2D.getMissingGlyphCode();
        char[] cArray = new char[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            cArray[n2] = 65535;
        }
        for (n2 = 0; n2 < 55296; n2 = (int)((char)(n2 + 1))) {
            int n5 = font2D.charToGlyph(n2);
            if (n5 == n4 || n5 >= n3) continue;
            cArray[n5] = n2;
        }
        return cArray;
    }

    public void draw(Shape shape) {
        this.fill(this.getStroke().createStrokedShape(shape));
    }

    public void fill(Shape shape) {
        Paint paint = this.getPaint();
        try {
            this.fill(shape, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void fill(Shape shape, Color color) {
        AffineTransform affineTransform = this.getTransform();
        if (this.getClip() != null) {
            this.deviceClip(this.getClip().getPathIterator(affineTransform));
        }
        this.deviceFill(shape.getPathIterator(affineTransform), color);
    }

    protected abstract void deviceFill(PathIterator var1, Color var2);

    protected abstract void deviceClip(PathIterator var1);

    protected abstract void deviceFrameRect(int var1, int var2, int var3, int var4, Color var5);

    protected abstract void deviceDrawLine(int var1, int var2, int var3, int var4, Color var5);

    protected abstract void deviceFillRect(int var1, int var2, int var3, int var4, Color var5);

    protected BufferedImage getBufferedImage(Image image) {
        if (image instanceof RemoteOffScreenImage) {
            return ((RemoteOffScreenImage)image).getSnapshot();
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        if (image instanceof ToolkitImage) {
            return ((ToolkitImage)image).getBufferedImage();
        }
        if (image instanceof VolatileImage) {
            return ((VolatileImage)image).getSnapshot();
        }
        return null;
    }

    protected boolean hasTransparentPixels(BufferedImage bufferedImage) {
        boolean bl2;
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl3 = colorModel == null ? true : (bl2 = colorModel.getTransparency() != 1);
        if (bl2 && bufferedImage != null && (bufferedImage.getType() == 2 || bufferedImage.getType() == 3)) {
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
            if (dataBuffer instanceof DataBufferInt && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n2 = bufferedImage.getMinX();
                int n3 = bufferedImage.getMinY();
                int n4 = bufferedImage.getWidth();
                int n5 = bufferedImage.getHeight();
                int n6 = singlePixelPackedSampleModel.getScanlineStride();
                boolean bl4 = false;
                for (int i2 = n3; i2 < n3 + n5; ++i2) {
                    int n7 = n3 * n6;
                    for (int i3 = n2; i3 < n2 + n4; ++i3) {
                        if ((nArray[n7 + i3] & 0xFF000000) == -16777216) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl4) break;
                }
                if (!bl4) {
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    protected boolean isBitmaskTransparency(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        return colorModel != null && colorModel.getTransparency() == 2;
    }

    protected boolean drawBitmaskImage(BufferedImage bufferedImage, AffineTransform affineTransform, Color color, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        ColorModel colorModel = bufferedImage.getColorModel();
        if (!(colorModel instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        if (colorModel.getTransparency() != 2) {
            return false;
        }
        if (color != null && color.getAlpha() < 128) {
            return false;
        }
        if ((affineTransform.getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        if ((this.getTransform().getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        BufferedImage bufferedImage2 = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n10 = indexColorModel.getTransparentPixel();
        byte[] byArray = new byte[indexColorModel.getMapSize()];
        indexColorModel.getAlphas(byArray);
        if (n10 >= 0) {
            byArray[n10] = 0;
        }
        int n11 = writableRaster.getWidth();
        int n12 = writableRaster.getHeight();
        if (n2 > n11 || n3 > n12) {
            return false;
        }
        if (n2 + n4 > n11) {
            n9 = n11;
            n8 = n9 - n2;
        } else {
            n9 = n2 + n4;
            n8 = n4;
        }
        if (n3 + n5 > n12) {
            n7 = n12;
            n6 = n7 - n3;
        } else {
            n7 = n3 + n5;
            n6 = n5;
        }
        int[] nArray = new int[n8];
        for (int i2 = n3; i2 < n7; ++i2) {
            int n13 = -1;
            writableRaster.getPixels(n2, i2, n8, 1, nArray);
            for (int i3 = n2; i3 < n9; ++i3) {
                if (byArray[nArray[i3 - n2]] == 0) {
                    if (n13 < 0) continue;
                    bufferedImage2 = bufferedImage.getSubimage(n13, i2, i3 - n13, 1);
                    affineTransform.translate(n13, i2);
                    this.drawImageToPlatform(bufferedImage2, affineTransform, color, 0, 0, i3 - n13, 1, true);
                    affineTransform.translate(-n13, -i2);
                    n13 = -1;
                    continue;
                }
                if (n13 >= 0) continue;
                n13 = i3;
            }
            if (n13 < 0) continue;
            bufferedImage2 = bufferedImage.getSubimage(n13, i2, n9 - n13, 1);
            affineTransform.translate(n13, i2);
            this.drawImageToPlatform(bufferedImage2, affineTransform, color, 0, 0, n9 - n13, 1, true);
            affineTransform.translate(-n13, -i2);
        }
        return true;
    }

    protected abstract boolean drawImageToPlatform(Image var1, AffineTransform var2, Color var3, int var4, int var5, int var6, int var7, boolean var8);

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        boolean bl2 = n4 < 0 || n5 < 0 ? false : this.drawImage(image, n2, n3, n4, n5, color, imageObserver);
        return bl2;
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        boolean bl2 = n6 < 0 || n7 < 0 ? false : this.drawImage(image, n2, n3, n2 + n4, n3 + n5, 0, 0, n6, n7, imageObserver);
        return bl2;
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n10 = n8 - n6;
        int n11 = n9 - n7;
        float f2 = (float)(n4 - n2) / (float)n10;
        float f3 = (float)(n5 - n3) / (float)n11;
        AffineTransform affineTransform = new AffineTransform(f2, 0.0f, 0.0f, f3, (float)n2 - (float)n6 * f2, (float)n3 - (float)n7 * f3);
        return this.drawImageToPlatform(image, affineTransform, color, n6, n7, n10, n11, false);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        boolean bl2 = n2 < 0 || n3 < 0 ? false : this.drawImageToPlatform(image, affineTransform, null, 0, 0, n2, n3, false);
        return bl2;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        if (bufferedImage == null) {
            return;
        }
        int n4 = bufferedImage.getWidth(null);
        int n5 = bufferedImage.getHeight(null);
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        if (n4 < 0 || n5 < 0) {
            boolean bl2 = false;
        } else {
            AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n2, n3);
            boolean bl3 = this.drawImageToPlatform(bufferedImage, affineTransform, null, 0, 0, n4, n5, false);
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (renderedImage == null) {
            return;
        }
        BufferedImage bufferedImage = null;
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
        }
        this.drawImageToPlatform(bufferedImage, affineTransform, null, 0, 0, n2, n3, false);
    }
}

