/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GraphicAttribute;
import java.awt.geom.Rectangle2D;
import sun.font.BidiUtils;
import sun.font.CoreMetrics;
import sun.font.Decoration;
import sun.font.TextLineComponent;

public final class GraphicComponent
implements TextLineComponent,
Decoration.Label {
    public static final float GRAPHIC_LEADING = 2.0f;
    private GraphicAttribute graphic;
    private int graphicCount;
    private int[] charsLtoV;
    private byte[] levels;
    private Rectangle2D visualBounds = null;
    private float graphicAdvance;
    private CoreMetrics cm;
    private Decoration decorator;

    public GraphicComponent(GraphicAttribute graphicAttribute, Decoration decoration, int[] nArray, byte[] byArray, int n2, int n3) {
        if (n3 <= n2) {
            throw new IllegalArgumentException("0 or negative length in GraphicComponent");
        }
        this.graphic = graphicAttribute;
        this.graphicAdvance = graphicAttribute.getAdvance();
        this.decorator = decoration;
        this.cm = GraphicComponent.createCoreMetrics(graphicAttribute);
        this.initLocalOrdering(nArray, byArray, n2, n3);
    }

    private GraphicComponent(GraphicComponent graphicComponent, int n2, int n3, int n4) {
        this.graphic = graphicComponent.graphic;
        this.graphicAdvance = graphicComponent.graphicAdvance;
        this.decorator = graphicComponent.decorator;
        this.cm = graphicComponent.cm;
        int[] nArray = null;
        byte[] byArray = null;
        if (n4 == 2) {
            nArray = graphicComponent.charsLtoV;
            byArray = graphicComponent.levels;
        } else if (n4 == 0 || n4 == 1) {
            n3 -= n2;
            n2 = 0;
            if (n4 == 1) {
                nArray = new int[n3];
                byArray = new byte[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    nArray[i2] = n3 - i2 - 1;
                    byArray[i2] = 1;
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid direction flag");
        }
        this.initLocalOrdering(nArray, byArray, n2, n3);
    }

    private void initLocalOrdering(int[] nArray, byte[] byArray, int n2, int n3) {
        this.graphicCount = n3 - n2;
        this.charsLtoV = nArray == null || nArray.length == this.graphicCount ? nArray : BidiUtils.createNormalizedMap(nArray, byArray, n2, n3);
        if (byArray == null || byArray.length == this.graphicCount) {
            this.levels = byArray;
        } else {
            this.levels = new byte[this.graphicCount];
            System.arraycopy(byArray, n2, this.levels, 0, this.graphicCount);
        }
    }

    public Rectangle2D handleGetVisualBounds() {
        Rectangle2D rectangle2D = this.graphic.getBounds();
        float f2 = (float)rectangle2D.getWidth() + this.graphicAdvance * (float)(this.graphicCount - 1);
        return new Rectangle2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY(), f2, (float)rectangle2D.getHeight());
    }

    public CoreMetrics getCoreMetrics() {
        return this.cm;
    }

    public static CoreMetrics createCoreMetrics(GraphicAttribute graphicAttribute) {
        return new CoreMetrics(graphicAttribute.getAscent(), graphicAttribute.getDescent(), 2.0f, graphicAttribute.getAscent() + graphicAttribute.getDescent() + 2.0f, graphicAttribute.getAlignment(), new float[]{0.0f, -graphicAttribute.getAscent() / 2.0f, -graphicAttribute.getAscent()}, -graphicAttribute.getAscent() / 2.0f, graphicAttribute.getAscent() / 12.0f, graphicAttribute.getDescent() / 3.0f, graphicAttribute.getAscent() / 12.0f, 0.0f, 0.0f);
    }

    public float getItalicAngle() {
        return 0.0f;
    }

    public Rectangle2D getVisualBounds() {
        if (this.visualBounds == null) {
            this.visualBounds = this.decorator.getVisualBounds(this);
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(this.visualBounds);
        return float_;
    }

    public Shape handleGetOutline(float f2, float f3) {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(this.handleGetVisualBounds());
        float_.x += f2;
        float_.y += f3;
        return float_;
    }

    public Shape getOutline(float f2, float f3) {
        return this.decorator.getOutline(this, f2, f3);
    }

    public void handleDraw(Graphics2D graphics2D, float f2, float f3) {
        for (int i2 = 0; i2 < this.graphicCount; ++i2) {
            this.graphic.draw(graphics2D, f2, f3);
            f2 += this.graphicAdvance;
        }
    }

    public void draw(Graphics2D graphics2D, float f2, float f3) {
        this.decorator.drawTextAndDecorations(this, graphics2D, f2, f3);
    }

    public Rectangle2D getCharVisualBounds(int n2) {
        return this.decorator.getCharVisualBounds(this, n2);
    }

    public int getNumCharacters() {
        return this.graphicCount;
    }

    public float getCharX(int n2) {
        int n3 = this.charsLtoV == null ? n2 : this.charsLtoV[n2];
        return this.graphicAdvance * (float)n3;
    }

    public float getCharY(int n2) {
        return 0.0f;
    }

    public float getCharAdvance(int n2) {
        return this.graphicAdvance;
    }

    public boolean caretAtOffsetIsValid(int n2) {
        return true;
    }

    public Rectangle2D handleGetCharVisualBounds(int n2) {
        Rectangle2D rectangle2D = this.graphic.getBounds();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(rectangle2D);
        float_.x += this.graphicAdvance * (float)n2;
        return float_;
    }

    public int getLineBreakIndex(int n2, float f2) {
        int n3 = (int)(f2 / this.graphicAdvance);
        if (n3 > this.graphicCount - n2) {
            n3 = this.graphicCount - n2;
        }
        return n3;
    }

    public float getAdvanceBetween(int n2, int n3) {
        return this.graphicAdvance * (float)(n3 - n2);
    }

    public Rectangle2D getLogicalBounds() {
        float f2 = 0.0f;
        float f3 = -this.cm.ascent;
        float f4 = this.graphicAdvance * (float)this.graphicCount;
        float f5 = this.cm.descent - f3;
        return new Rectangle2D.Float(f2, f3, f4, f5);
    }

    public float getAdvance() {
        return this.graphicAdvance * (float)this.graphicCount;
    }

    public Rectangle2D getItalicBounds() {
        return this.getLogicalBounds();
    }

    public TextLineComponent getSubset(int n2, int n3, int n4) {
        if (n2 < 0 || n3 > this.graphicCount || n2 >= n3) {
            throw new IllegalArgumentException("Invalid range.  start=" + n2 + "; limit=" + n3);
        }
        if (n2 == 0 && n3 == this.graphicCount && n4 == 2) {
            return this;
        }
        return new GraphicComponent(this, n2, n3, n4);
    }

    public String toString() {
        return "[graphic=" + this.graphic + ":count=" + this.getNumCharacters() + "]";
    }

    public int getNumJustificationInfos() {
        return 0;
    }

    public void getJustificationInfos(GlyphJustificationInfo[] glyphJustificationInfoArray, int n2, int n3, int n4) {
    }

    public TextLineComponent applyJustificationDeltas(float[] fArray, int n2, boolean[] blArray) {
        return this;
    }
}

