/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class JPasswordField
extends JTextField {
    private static final String uiClassID = "PasswordFieldUI";
    private char echoChar = (char)42;

    public JPasswordField() {
        this(null, null, 0);
    }

    public JPasswordField(String string) {
        this(null, string, 0);
    }

    public JPasswordField(int n2) {
        this(null, null, n2);
    }

    public JPasswordField(String string, int n2) {
        this(null, string, n2);
    }

    public JPasswordField(Document document, String string, int n2) {
        super(document, string, n2);
        this.enableInputMethods(false);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char c2) {
        this.echoChar = c2;
        this.repaint();
        this.revalidate();
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public void cut() {
        if (this.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        } else {
            super.cut();
        }
    }

    public void copy() {
        if (this.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        } else {
            super.copy();
        }
    }

    @Deprecated
    public String getText() {
        return super.getText();
    }

    @Deprecated
    public String getText(int n2, int n3) throws BadLocationException {
        return super.getText(n2, n3);
    }

    public char[] getPassword() {
        Document document = this.getDocument();
        Segment segment = new Segment();
        try {
            document.getText(0, document.getLength(), segment);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        char[] cArray = new char[segment.count];
        System.arraycopy(segment.array, segment.offset, cArray, 0, segment.count);
        return cArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        return super.paramString() + ",echoChar=" + this.echoChar;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPasswordField();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJPasswordField
    extends JTextField.AccessibleJTextField {
        protected AccessibleJPasswordField() {
            super(JPasswordField.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PASSWORD_TEXT;
        }
    }
}

