/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;

public class CheckedOutputStream
extends FilterOutputStream {
    private Checksum cksum;

    public CheckedOutputStream(OutputStream outputStream, Checksum checksum) {
        super(outputStream);
        this.cksum = checksum;
    }

    public void write(int n2) throws IOException {
        this.out.write(n2);
        this.cksum.update(n2);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
        this.cksum.update(byArray, n2, n3);
    }

    public Checksum getChecksum() {
        return this.cksum;
    }
}

