/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.HeapDoubleBufferR;

class HeapDoubleBuffer
extends DoubleBuffer {
    HeapDoubleBuffer(int n2, int n3) {
        super(-1, 0, n3, n2, new double[n2], 0);
    }

    HeapDoubleBuffer(double[] dArray, int n2, int n3) {
        super(-1, n2, n2 + n3, dArray.length, dArray, 0);
    }

    protected HeapDoubleBuffer(double[] dArray, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, dArray, n6);
    }

    public DoubleBuffer slice() {
        return new HeapDoubleBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    public DoubleBuffer duplicate() {
        return new HeapDoubleBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public DoubleBuffer asReadOnlyBuffer() {
        return new HeapDoubleBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n2) {
        return n2 + this.offset;
    }

    public double get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public double get(int n2) {
        return this.hb[this.ix(this.checkIndex(n2))];
    }

    public DoubleBuffer get(double[] dArray, int n2, int n3) {
        HeapDoubleBuffer.checkBounds(n2, n3, dArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), dArray, n2, n3);
        this.position(this.position() + n3);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public DoubleBuffer put(double d2) {
        this.hb[this.ix((int)this.nextPutIndex())] = d2;
        return this;
    }

    public DoubleBuffer put(int n2, double d2) {
        this.hb[this.ix((int)this.checkIndex((int)n2))] = d2;
        return this;
    }

    public DoubleBuffer put(double[] dArray, int n2, int n3) {
        HeapDoubleBuffer.checkBounds(n2, n3, dArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(dArray, n2, this.hb, this.ix(this.position()), n3);
        this.position(this.position() + n3);
        return this;
    }

    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        if (doubleBuffer instanceof HeapDoubleBuffer) {
            if (doubleBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapDoubleBuffer heapDoubleBuffer = (HeapDoubleBuffer)doubleBuffer;
            int n2 = heapDoubleBuffer.remaining();
            if (n2 > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapDoubleBuffer.hb, heapDoubleBuffer.ix(heapDoubleBuffer.position()), this.hb, this.ix(this.position()), n2);
            heapDoubleBuffer.position(heapDoubleBuffer.position() + n2);
            this.position(this.position() + n2);
        } else if (doubleBuffer.isDirect()) {
            int n3 = doubleBuffer.remaining();
            if (n3 > this.remaining()) {
                throw new BufferOverflowException();
            }
            doubleBuffer.get(this.hb, this.ix(this.position()), n3);
            this.position(this.position() + n3);
        } else {
            super.put(doubleBuffer);
        }
        return this;
    }

    public DoubleBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

